/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base;

import com.agfa.pacs.base.swing.util.RestartNotifier;
import com.agfa.pacs.listtext.lta.base.LTAComponentFactory;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.ISession;
import com.agfa.pacs.login.LoginSessionFactory;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.URLEncodeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordChange
extends JDialog {
    private static final long serialVersionUID = -7492242409901329375L;
    private JButton cancelButton = null;
    private JButton okButton = null;
    private JLabel jLabelMessage = null;
    private JLabel jLabelPassword = null;
    private JLabel jLabelPasswordReenter = null;
    private JLabel jLabelPasswordOriginal = null;
    private JPanel jPanel = null;
    private JPanel buttonPanel = null;
    private JPasswordField jPasswordFieldPassword = null;
    private JPasswordField jPasswordFieldPasswordReenter = null;
    private JPasswordField jPasswordFieldPasswordOriginal = null;

    public PasswordChange(Frame frame, String string) {
        super(frame, string);
        this.setSize(new Dimension(494, 247));
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(string);
        this.setContentPane(this.getJPanel());
        this.rootPane.setDefaultButton(this.okButton);
        SwingUtilities2.centerOnFrame((Frame)frame, (Window)this);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabelMessage = LTAComponentFactory.instance.createLabel(Messages.getString("PasswordChange.Message"));
            this.jLabelPasswordReenter = LTAComponentFactory.instance.createLabel(String.valueOf(Messages.getString("PasswordChange.ConfirmPassword")) + ":");
            this.jLabelPassword = LTAComponentFactory.instance.createLabel(String.valueOf(Messages.getString("PasswordChange.EnterPassword")) + ":");
            this.jLabelPasswordOriginal = LTAComponentFactory.instance.createLabel(String.valueOf(Messages.getString("PasswordChange.OriginalPassword")) + ":");
            this.jPanel = LTAComponentFactory.instance.createPanel(new GridBagLayout());
            this.jPasswordFieldPasswordOriginal = new JPasswordField();
            this.jPasswordFieldPassword = new JPasswordField();
            this.jPasswordFieldPassword.setToolTipText(Messages.getString("PasswordChange.PasswordToolTip"));
            this.jPasswordFieldPasswordReenter = new JPasswordField();
            this.jPasswordFieldPasswordReenter.setToolTipText(Messages.getString("PasswordChange.PasswordReenterToolTip"));
            this.addComponent(this.jPanel, 0, 0, 2, this.jLabelMessage);
            this.addComponent(this.jPanel, 0, 1, 1, this.jLabelPasswordOriginal);
            this.addComponent(this.jPanel, 1, 1, 1, this.jPasswordFieldPasswordOriginal);
            this.addComponent(this.jPanel, 0, 2, 1, this.jLabelPassword);
            this.addComponent(this.jPanel, 1, 2, 1, this.jPasswordFieldPassword);
            this.addComponent(this.jPanel, 0, 3, 1, this.jLabelPasswordReenter);
            this.addComponent(this.jPanel, 1, 3, 1, this.jPasswordFieldPasswordReenter);
            this.addComponent(this.jPanel, 0, 4, 2, this.getButtonPanel());
        }
        return this.jPanel;
    }

    private JPanel getButtonPanel() {
        this.cancelButton = SwingUtilities2.createButton((String)Messages.getString("PasswordChange.Cancel"), (String)Messages.getString("PasswordChange.CancelToolTip"), null, null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PasswordChange.this.setVisible(false);
            }
        });
        this.okButton = SwingUtilities2.createButton((String)Messages.getString("PasswordChange.OK"), (String)Messages.getString("PasswordChange.OKToolTip"), null, null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = URLProviderFactory.getProvider().getLoginInformation().getPassword();
                boolean bl = string2.equals(string = new String(PasswordChange.this.jPasswordFieldPasswordOriginal.getPassword()));
                if (bl) {
                    int n;
                    char[] cArray = PasswordChange.this.jPasswordFieldPassword.getPassword();
                    char[] cArray2 = PasswordChange.this.jPasswordFieldPasswordReenter.getPassword();
                    boolean bl2 = true;
                    if (cArray.length != cArray2.length) {
                        bl2 = false;
                    } else {
                        n = 0;
                        while (n < cArray.length) {
                            if (cArray[n] != cArray2[n]) {
                                bl2 = false;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (bl2) {
                        PasswordChange.this.setVisible(false);
                        n = PasswordChange.this.changePasswordOnArchiveViaHTTPRequest(new String(cArray)) ? 1 : 0;
                        if (n != 0) {
                            JOptionPane.showMessageDialog(PasswordChange.this.getParent(), Messages.getString("PasswordChange.PasswordChangedOK"));
                            RestartNotifier.setRestartRequired();
                        } else {
                            JOptionPane.showMessageDialog(PasswordChange.this.getParent(), Messages.getString("PasswordChange.PasswordChangeFailed"));
                        }
                    } else {
                        JOptionPane.showMessageDialog(PasswordChange.this, Messages.getString("PasswordChange.ErrorMessageConfirmationFailed"), Messages.getString("PasswordChange.ErrorTitleConfirmationFailed"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(PasswordChange.this, Messages.getString("PasswordChange.ErrorMessageConfirmationFailed"), Messages.getString("PasswordChange.ErrorTitleConfirmationFailed"), 0);
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        return this.buttonPanel;
    }

    private boolean changePasswordOnArchiveViaHTTPRequest(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(String.valueOf(URLProviderFactory.getProvider().getServerUrl()) + "Agility/passwordchange?newP=" + URLEncodeUtil.encode((String)string));
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            ISession iSession = LoginSessionFactory.getSession();
            if (iSession == null) {
                return false;
            }
            iSession.attach(httpURLConnection);
            httpURLConnection.setRequestMethod("GET");
            int n = httpURLConnection.getResponseCode();
            return n == 200;
            {
            }
        }
        catch (Exception exception) {
            ALogger.getLogger((String)"PasswordChange").error("Error while trying to change password", (Throwable)exception);
            return false;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private boolean isASCIIString(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (!this.isValidChar(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isValidChar(char c) {
        return c <= '\u007f';
    }

    public void addComponent(JPanel jPanel, int n, int n2, int n3, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add(component, gridBagConstraints);
    }
}

