/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.GenericKeyword;
import com.agfa.pacs.data.export.tce.keyword.GenericKeywordNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class SearchableKeywordTreeModel
extends DefaultTreeModel {
    private GenericKeywordNode unqualifiedRoot;
    private Map<String, GenericKeywordNode> searchMap;
    private GenericKeywordNode firstMatchingNode;
    private String qualifier;

    public SearchableKeywordTreeModel(GenericKeywordNode genericKeywordNode) {
        super((TreeNode)genericKeywordNode);
        this.unqualifiedRoot = genericKeywordNode;
        this.searchMap = new LinkedHashMap<String, GenericKeywordNode>();
        List list = genericKeywordNode.toList();
        if (list != null) {
            for (GenericKeywordNode genericKeywordNode2 : list) {
                if (genericKeywordNode2.getKeyword() == null) continue;
                this.searchMap.put(genericKeywordNode2.getKeyword().toString().toLowerCase(), genericKeywordNode2);
            }
        }
    }

    public GenericKeywordNode getFirstMatchingNode() {
        return this.firstMatchingNode;
    }

    public GenericKeywordNode findNode(GenericKeyword genericKeyword) {
        List list;
        if (genericKeyword != null && (list = this.unqualifiedRoot.toList()) != null) {
            for (GenericKeywordNode genericKeywordNode : list) {
                GenericKeyword genericKeyword2 = genericKeywordNode.getKeyword();
                if (genericKeyword2 == null || !genericKeyword2.getValueId().equals(genericKeyword.getValueId())) continue;
                return genericKeywordNode;
            }
        }
        return null;
    }

    public void reset() {
        if (this.qualifier != null) {
            this.qualifier = null;
            this.firstMatchingNode = null;
            this.setRoot((TreeNode)this.unqualifiedRoot);
        }
    }

    public void qualify(String string) {
        if (string == null) {
            this.reset();
        } else if (!string.equals(this.qualifier)) {
            string = string.replaceAll("\\*", ".*");
            this.qualifier = string = string.replaceAll("\\?", ".");
            String string2 = ".*" + string.toLowerCase() + ".*";
            ArrayList<GenericKeywordNode> arrayList = new ArrayList<GenericKeywordNode>();
            for (Map.Entry<String, GenericKeywordNode> genericKeywordNode2 : this.searchMap.entrySet()) {
                if (!genericKeywordNode2.getKey().matches(string2)) continue;
                arrayList.add(genericKeywordNode2.getValue());
            }
            this.firstMatchingNode = !arrayList.isEmpty() ? (GenericKeywordNode)arrayList.get(0) : null;
            GenericKeywordNode genericKeywordNode = new GenericKeywordNode();
            HashMap hashMap = new HashMap();
            for (GenericKeywordNode genericKeywordNode2 : arrayList) {
                GenericKeywordNode genericKeywordNode3 = genericKeywordNode;
                List list = genericKeywordNode2.getPath();
                list.remove(0);
                for (GenericKeywordNode genericKeywordNode4 : list) {
                    GenericKeywordNode genericKeywordNode5 = (GenericKeywordNode)hashMap.get(genericKeywordNode4.getKeyword().toString());
                    if (genericKeywordNode5 == null) {
                        genericKeywordNode5 = new GenericKeywordNode(genericKeywordNode4.getKeyword());
                        hashMap.put(genericKeywordNode5.getKeyword().toString(), genericKeywordNode5);
                        genericKeywordNode3.addChildren(genericKeywordNode5);
                    }
                    genericKeywordNode3 = genericKeywordNode5;
                }
                this.checkToAddSubTree(genericKeywordNode2, genericKeywordNode3, hashMap);
            }
            this.setRoot((TreeNode)genericKeywordNode);
        }
    }

    private void checkToAddSubTree(GenericKeywordNode genericKeywordNode, GenericKeywordNode genericKeywordNode2, Map<String, GenericKeywordNode> map) {
        GenericKeywordNode genericKeywordNode3 = map.get(genericKeywordNode.getKeyword().toString());
        if (genericKeywordNode3 == null) {
            genericKeywordNode3 = new GenericKeywordNode(genericKeywordNode.getKeyword());
            genericKeywordNode2.addChildren(genericKeywordNode3);
            map.put(genericKeywordNode3.getKeyword().toString(), genericKeywordNode3);
        }
        if (genericKeywordNode.getChildCount() > 0) {
            for (GenericKeywordNode genericKeywordNode4 : genericKeywordNode.getChildren()) {
                this.checkToAddSubTree(genericKeywordNode4, genericKeywordNode3, map);
            }
        }
    }
}

