/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.tce.editors;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.export.tce.TeachingFileDicomTag;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.TeachingFilePropertyValue;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.export.tce.keyword.Keyword;
import com.agfa.pacs.impaxee.tce.Messages;
import com.agfa.pacs.impaxee.tce.editors.ITeachingFilePropertyValueEditor;
import com.agfa.pacs.impaxee.tce.keyword.IKeywordProviderUI;
import com.agfa.pacs.impaxee.tce.keyword.IKeywordUI;
import com.agfa.pacs.impaxee.tce.keyword.KeywordUIProviderFactory;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.swingx.controls.DateBox;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public abstract class AbstractTeachingFilePropertyValueEditor<T>
extends JPanel
implements ITeachingFilePropertyValueEditor<T> {
    private TeachingFileProperty<T> property;
    private TeachingFilePropertyValue<T> value;
    private Collection<ChangeListener> listeners;
    private JLabel label;
    private JComponent editor;

    protected AbstractTeachingFilePropertyValueEditor(TeachingFileProperty<T> teachingFileProperty, TeachingFilePropertyValue<T> teachingFilePropertyValue, String string) {
        this.property = teachingFileProperty;
        this.value = teachingFilePropertyValue;
        this.label = this.createLabel(string);
        this.setOpaque(false);
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.editor == null) {
            this.editor = this.createEditor(this.value);
            this.installLayout();
        }
        return this;
    }

    @Override
    public TeachingFileProperty<T> getProperty() {
        return this.property;
    }

    @Override
    public TeachingFilePropertyValue<T> getValue() {
        return this.value;
    }

    @Override
    public void setValue(TeachingFilePropertyValue<T> teachingFilePropertyValue) {
        this.setValues(teachingFilePropertyValue.getValues());
        this.valuesChanged(teachingFilePropertyValue.getValues());
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public static <T> ITeachingFilePropertyValueEditor<T> create(TeachingFileProperty<T> teachingFileProperty, TeachingFilePropertyValue<T> teachingFilePropertyValue) {
        return AbstractTeachingFilePropertyValueEditor.create(teachingFileProperty, teachingFilePropertyValue, null, null, false);
    }

    public static <T> ITeachingFilePropertyValueEditor<T> create(TeachingFileProperty<T> teachingFileProperty, TeachingFilePropertyValue<T> teachingFilePropertyValue, ChangeListener changeListener) {
        return AbstractTeachingFilePropertyValueEditor.create(teachingFileProperty, teachingFilePropertyValue, changeListener, null, false);
    }

    public static <T> ITeachingFilePropertyValueEditor<T> create(TeachingFileProperty<?> teachingFileProperty, TeachingFilePropertyValue<T> teachingFilePropertyValue, ChangeListener changeListener, String string, boolean bl) {
        Class clazz = teachingFilePropertyValue.getValueType().getValueClass();
        if (String.class.isAssignableFrom(clazz)) {
            AbstractTeachingFilePropertyValueEditor abstractTeachingFilePropertyValueEditor;
            AbstractTeachingFilePropertyValueEditor abstractTeachingFilePropertyValueEditor2 = abstractTeachingFilePropertyValueEditor = bl ? new MultiLineStringEditor((TeachingFileProperty<String>)teachingFileProperty, (TeachingFilePropertyValue<String>)teachingFilePropertyValue, string) : new StringEditor((TeachingFileProperty<String>)teachingFileProperty, (TeachingFilePropertyValue<String>)teachingFilePropertyValue, string);
            if (changeListener != null) {
                abstractTeachingFilePropertyValueEditor.addChangeListener(changeListener);
            }
            return abstractTeachingFilePropertyValueEditor;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            IntegerEditor integerEditor = new IntegerEditor((TeachingFileProperty<Integer>)teachingFileProperty, (TeachingFilePropertyValue<Integer>)teachingFilePropertyValue, string);
            if (changeListener != null) {
                integerEditor.addChangeListener(changeListener);
            }
            return integerEditor;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            DateEditor dateEditor = new DateEditor((TeachingFileProperty<Date>)teachingFileProperty, (TeachingFilePropertyValue<Date>)teachingFilePropertyValue, string);
            if (changeListener != null) {
                dateEditor.addChangeListener(changeListener);
            }
            return dateEditor;
        }
        if (Modality.class.isAssignableFrom(clazz)) {
            ModalityEditor modalityEditor = new ModalityEditor((TeachingFileProperty<Modality>)teachingFileProperty, (TeachingFilePropertyValue<Modality>)teachingFilePropertyValue, string);
            if (changeListener != null) {
                modalityEditor.addChangeListener(changeListener);
            }
            return modalityEditor;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            EnumEditor enumEditor = new EnumEditor((TeachingFileProperty<Enum<?>>)teachingFileProperty, (TeachingFilePropertyValue<Enum<?>>)teachingFilePropertyValue, string);
            if (changeListener != null) {
                enumEditor.addChangeListener(changeListener);
            }
            return enumEditor;
        }
        if (IKeyword.class.isAssignableFrom(clazz)) {
            AbstractTeachingFilePropertyValueEditor abstractTeachingFilePropertyValueEditor = null;
            IKeywordProvider iKeywordProvider = teachingFileProperty.getKeywordProvider();
            abstractTeachingFilePropertyValueEditor = iKeywordProvider != null ? new KeywordEditor(teachingFileProperty, teachingFilePropertyValue, string, iKeywordProvider) : (bl ? new MultiLineStringKeywordEditor((TeachingFileProperty<IKeyword>)teachingFileProperty, (TeachingFilePropertyValue<IKeyword>)teachingFilePropertyValue, string) : new StringKeywordEditor((TeachingFileProperty<IKeyword>)teachingFileProperty, (TeachingFilePropertyValue<IKeyword>)teachingFilePropertyValue, string));
            if (changeListener != null) {
                abstractTeachingFilePropertyValueEditor.addChangeListener(changeListener);
            }
            return abstractTeachingFilePropertyValueEditor;
        }
        if (TeachingFileDicomTag.class.isAssignableFrom(clazz)) {
            DicomTagEditor dicomTagEditor = new DicomTagEditor((TeachingFileProperty<TeachingFileDicomTag>)teachingFileProperty, (TeachingFilePropertyValue<TeachingFileDicomTag>)teachingFilePropertyValue, string);
            if (changeListener != null) {
                dicomTagEditor.addChangeListener(changeListener);
            }
            return dicomTagEditor;
        }
        return null;
    }

    public static <T> ITeachingFilePropertyValueEditor<T> createMultiValueEditor(TeachingFileProperty<T> teachingFileProperty, TeachingFilePropertyValue<T> teachingFilePropertyValue, ChangeListener changeListener) {
        MultiValueEditor<T> multiValueEditor = new MultiValueEditor<T>(teachingFileProperty, teachingFilePropertyValue, null);
        if (changeListener != null) {
            multiValueEditor.addChangeListener(changeListener);
        }
        return multiValueEditor;
    }

    public static ITeachingFilePropertyValueEditor<IKeyword> createKeywordEditor(TeachingFileProperty<IKeyword> teachingFileProperty, TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue, IKeywordProvider iKeywordProvider, ChangeListener changeListener, String string, boolean bl) {
        AbstractTeachingFilePropertyValueEditor abstractTeachingFilePropertyValueEditor = null;
        abstractTeachingFilePropertyValueEditor = iKeywordProvider != null ? new KeywordEditor(teachingFileProperty, teachingFilePropertyValue, string, iKeywordProvider) : (bl ? new MultiLineStringKeywordEditor(teachingFileProperty, teachingFilePropertyValue, string) : new StringKeywordEditor(teachingFileProperty, teachingFilePropertyValue, string));
        if (changeListener != null) {
            abstractTeachingFilePropertyValueEditor.addChangeListener(changeListener);
        }
        return abstractTeachingFilePropertyValueEditor;
    }

    public static <E extends Enum<E>> ITeachingFilePropertyValueEditor<String> createEnumEditor(TeachingFileProperty<String> teachingFileProperty, TeachingFilePropertyValue<String> teachingFilePropertyValue, Class<E> clazz, String string, ChangeListener changeListener) {
        EnumStringEditor<E> enumStringEditor = new EnumStringEditor<E>(teachingFileProperty, teachingFilePropertyValue, clazz, string);
        if (changeListener != null) {
            enumStringEditor.addChangeListener(changeListener);
        }
        return enumStringEditor;
    }

    public static ITeachingFilePropertyValueEditor<String> createStringEditor(TeachingFileProperty<String> teachingFileProperty, TeachingFilePropertyValue<String> teachingFilePropertyValue, String string, ChangeListener changeListener, String ... stringArray) {
        StringEditor stringEditor = new StringEditor(teachingFileProperty, teachingFilePropertyValue, string, stringArray);
        if (changeListener != null) {
            stringEditor.addChangeListener(changeListener);
        }
        return stringEditor;
    }

    protected abstract JComponent createEditor(TeachingFilePropertyValue<T> var1);

    protected void setValues(T ... TArray) {
        this.value.setValues((Object[])TArray);
        this.fireValueChanged();
    }

    protected void valuesChanged(T ... TArray) {
    }

    protected JComponent getEditor() {
        return this.editor;
    }

    protected JLabel createLabel(String string) {
        if (string != null) {
            JLabel jLabel = SwingUtilities2.createLabel((String)string, null, null, null);
            jLabel.setHorizontalAlignment(2);
            return jLabel;
        }
        return null;
    }

    private void installLayout() {
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-1.0});
        tableLayout.setHGap(this.label != null ? GUI.getScaledInt((int)5) : 0);
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)this.editor, "1,0");
        if (this.label != null) {
            this.add((Component)this.label, "0,0");
        }
    }

    protected void fireValueChanged() {
        if (this.listeners != null) {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }

    private static class AddMultiValueAction<T>
    extends AbstractAction {
        private TeachingFileProperty<T> p;
        private TeachingFilePropertyValueListModelWrapper<T> listModel;

        public AddMultiValueAction(TeachingFileProperty<T> teachingFileProperty, TeachingFilePropertyValueListModelWrapper<T> teachingFilePropertyValueListModelWrapper) {
            super(null, UIManager.getIcon("add"));
            this.p = teachingFileProperty;
            this.listModel = teachingFilePropertyValueListModelWrapper;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            TeachingFilePropertyValue teachingFilePropertyValue = this.p.createValue(new Object[0]);
            JComponent jComponent = null;
            IKeywordUI iKeywordUI = null;
            if (this.p.getKeywordProvider() != null && this.p.isKeywordProviderExclusive()) {
                object = KeywordUIProviderFactory.getInstance().getKeywordUIProvider(this.p.getKeywordProvider().getType());
                iKeywordUI = object.getUI(this.p.getKeywordProvider());
                iKeywordUI.setSelectedKeyword(null);
                jComponent = iKeywordUI.getRootComponent();
            } else {
                object = AbstractTeachingFilePropertyValueEditor.create(this.p, teachingFilePropertyValue, null, null, false);
                jComponent = object.getEditorComponent();
                jComponent.setPreferredSize(new Dimension(GUI.getScaledInt((int)440), jComponent.getPreferredSize().height));
            }
            object = MessageDialog.createMessageDialog((Component)LTAUtil.getMainWindow(), (String)Messages.getString("TeachingFileExportView.AddKeywordDialog.Title"), (Object)jComponent, (boolean)true, (int)3, (String)"OK_CANCEL_OPTION");
            object.showCenteredInOwner();
            if ("OK_OPTION".equals(object.getSelectedOption())) {
                Object object2;
                Object object3 = object2 = iKeywordUI != null ? iKeywordUI.getSelectedKeyword() : teachingFilePropertyValue.getValue();
                if (object2 != null) {
                    this.listModel.addValue((IKeyword)object2);
                }
            }
        }
    }

    private static class DateEditor
    extends AbstractTeachingFilePropertyValueEditor<Date> {
        public DateEditor(TeachingFileProperty<Date> teachingFileProperty, TeachingFilePropertyValue<Date> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        protected DateBox createEditor(TeachingFilePropertyValue<Date> teachingFilePropertyValue) {
            final DateBox dateBox = new DateBox((Date)teachingFilePropertyValue.getValue(), true, false, true, false, false);
            dateBox.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), dateBox.getPreferredSize().height));
            dateBox.setDate((Date)teachingFilePropertyValue.getValue());
            dateBox.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("DATE_VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                        DateEditor.this.setValues(dateBox.getDate());
                    }
                }
            });
            return dateBox;
        }

        protected void valuesChanged(Date ... dateArray) {
            if (dateArray != null && dateArray.length > 0) {
                ((DateBox)this.getEditor()).setDate(dateArray[0]);
            }
        }
    }

    private static class DicomTagEditor
    extends AbstractTeachingFilePropertyValueEditor<TeachingFileDicomTag> {
        public DicomTagEditor(TeachingFileProperty<TeachingFileDicomTag> teachingFileProperty, TeachingFilePropertyValue<TeachingFileDicomTag> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        protected JComboBox createEditor(TeachingFilePropertyValue<TeachingFileDicomTag> teachingFilePropertyValue) {
            JComboBox jComboBox = SwingUtilities2.createComboBox((Object[])this.getProperty().getCompatibleDicomTags(), null);
            jComboBox.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jComboBox.getPreferredSize().height));
            jComboBox.setSelectedItem(teachingFilePropertyValue.getValue());
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TeachingFileDicomTag teachingFileDicomTag = (TeachingFileDicomTag)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    DicomTagEditor.this.setValues(teachingFileDicomTag);
                }
            });
            return jComboBox;
        }

        protected void valuesChanged(TeachingFileDicomTag ... teachingFileDicomTagArray) {
            TeachingFileDicomTag teachingFileDicomTag = teachingFileDicomTagArray != null && teachingFileDicomTagArray.length > 0 ? teachingFileDicomTagArray[0] : null;
            ((JComboBox)this.getEditor()).setSelectedItem(teachingFileDicomTag);
        }
    }

    private static class EnumEditor
    extends AbstractTeachingFilePropertyValueEditor<Enum<?>> {
        public EnumEditor(TeachingFileProperty<Enum<?>> teachingFileProperty, TeachingFilePropertyValue<Enum<?>> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        protected JComboBox createEditor(TeachingFilePropertyValue<Enum<?>> teachingFilePropertyValue) {
            JComboBox jComboBox = SwingUtilities2.createComboBox((Object[])teachingFilePropertyValue.getValueType().getValueSet(), null);
            jComboBox.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jComboBox.getPreferredSize().height));
            jComboBox.setSelectedItem(teachingFilePropertyValue.getValue());
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Enum enum_ = (Enum)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    EnumEditor.this.setValues(enum_);
                }
            });
            return jComboBox;
        }

        protected void valuesChanged(Enum<?> ... enumArray) {
            Enum<?> enum_ = enumArray != null && enumArray.length > 0 ? enumArray[0] : null;
            ((JComboBox)this.getEditor()).setSelectedItem(enum_);
        }
    }

    private static class EnumStringEditor<E extends Enum<E>>
    extends AbstractTeachingFilePropertyValueEditor<String> {
        private Class<E> enumClass;

        public EnumStringEditor(TeachingFileProperty<String> teachingFileProperty, TeachingFilePropertyValue<String> teachingFilePropertyValue, Class<E> clazz, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
            this.enumClass = clazz;
        }

        protected JComboBox<E> createEditor(TeachingFilePropertyValue<String> teachingFilePropertyValue) {
            final JComboBox jComboBox = SwingUtilities2.createComboBox((Object[])this.enumClass.getEnumConstants(), null);
            jComboBox.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jComboBox.getPreferredSize().height));
            jComboBox.setSelectedItem(teachingFilePropertyValue.getValue());
            jComboBox.setEditable(true);
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = jComboBox.getSelectedItem();
                    EnumStringEditor.this.setValues(object != null ? object.toString() : null);
                }
            });
            return jComboBox;
        }

        protected void valuesChanged(String ... stringArray) {
            String string;
            String string2 = string = stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
            if (string != null && !string.isEmpty()) {
                Enum[] enumArray = (Enum[])this.enumClass.getEnumConstants();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enum enum_ = enumArray[n2];
                    if (string.equals(enum_.toString())) {
                        ((JComboBox)this.getEditor()).setSelectedItem(enum_);
                        return;
                    }
                    ++n2;
                }
            }
            ((JComboBox)this.getEditor()).setSelectedItem(string);
        }
    }

    private static class IntegerEditor
    extends AbstractTeachingFilePropertyValueEditor<Integer> {
        public IntegerEditor(TeachingFileProperty<Integer> teachingFileProperty, TeachingFilePropertyValue<Integer> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        protected JSpinner createEditor(TeachingFilePropertyValue<Integer> teachingFilePropertyValue) {
            int n = (Integer)teachingFilePropertyValue.getValueType().getMinValue();
            int n2 = (Integer)teachingFilePropertyValue.getValueType().getMaxValue();
            Integer n3 = (Integer)teachingFilePropertyValue.getValue();
            JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n3 != null ? n3 : n, n, n2, 1));
            jSpinner.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jSpinner.getPreferredSize().height));
            jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    IntegerEditor.this.setValues((Integer)((JSpinner)changeEvent.getSource()).getValue());
                }
            });
            return jSpinner;
        }

        protected void valuesChanged(Integer ... integerArray) {
            if (integerArray != null && integerArray.length > 0) {
                ((JSpinner)this.getEditor()).setValue(integerArray[0]);
            }
        }
    }

    private static class KeywordEditor
    extends AbstractTeachingFilePropertyValueEditor<IKeyword> {
        private IKeywordProvider keyprov;
        private IKeywordUI ui;
        private boolean updatingValue;

        public KeywordEditor(TeachingFileProperty<IKeyword> teachingFileProperty, TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue, String string, IKeywordProvider iKeywordProvider) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
            this.keyprov = iKeywordProvider;
            this.updatingValue = false;
        }

        @Override
        protected JComponent createEditor(TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue) {
            if (this.keyprov == null) {
                String string = teachingFilePropertyValue.getValue() != null ? ((IKeyword)teachingFilePropertyValue.getValue()).getText() : null;
                final JTextField jTextField = SwingUtilities2.createTextField((String)string, (String)string, null);
                jTextField.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jTextField.getPreferredSize().height));
                jTextField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.setValue(documentEvent.getDocument());
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.setValue(documentEvent.getDocument());
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.setValue(documentEvent.getDocument());
                    }

                    private void setValue(Document document) {
                        try {
                            String string = document.getText(0, document.getLength());
                            jTextField.setToolTipText(string);
                            KeywordEditor.this.setValues(Keyword.createText((String)string));
                        }
                        catch (Exception exception) {}
                    }
                });
                return jTextField;
            }
            IKeywordProviderUI iKeywordProviderUI = KeywordUIProviderFactory.getInstance().getKeywordUIProvider(this.keyprov.getType());
            this.ui = iKeywordProviderUI.getUI(this.keyprov);
            String string = teachingFilePropertyValue.getValue() != null ? ((IKeyword)teachingFilePropertyValue.getValue()).toString() : null;
            final JTextField jTextField = SwingUtilities2.createTextField((String)string, (String)string, null);
            jTextField.setPreferredSize(new Dimension(GUI.getScaledInt((int)200), jTextField.getPreferredSize().height));
            jTextField.setEnabled(false);
            if (!this.getProperty().isKeywordProviderExclusive()) {
                jTextField.setEnabled(true);
                jTextField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.updateModel();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.updateModel();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.updateModel();
                    }

                    private void updateModel() {
                        if (!KeywordEditor.this.updatingValue) {
                            try {
                                KeywordEditor.this.updatingValue = true;
                                KeywordEditor.this.setValues(Keyword.createText((String)jTextField.getText()));
                            }
                            finally {
                                KeywordEditor.this.updatingValue = false;
                            }
                        }
                    }
                });
            }
            final JButton jButton = SwingUtilities2.createButton((String)"...");
            jButton.setPreferredSize(new Dimension(GUI.getScaledInt((int)25), jButton.getPreferredSize().height));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    KeywordEditor.this.ui.setSelectedKeyword((IKeyword)KeywordEditor.this.getValue().getValue());
                    MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)jButton, (String)Messages.getString("TeachingFilePropertyEditor.KeywordDialog.Title"), (Object)KeywordEditor.this.ui.getRootComponent(), (boolean)true, (int)3, (String)"OK_CANCEL_OPTION");
                    messageDialog.showCenteredInOwner();
                    if ("OK_OPTION".equals(messageDialog.getSelectedOption())) {
                        try {
                            KeywordEditor.this.updatingValue = true;
                            KeywordEditor.this.setValues(KeywordEditor.this.ui.getSelectedKeyword());
                            String string = KeywordEditor.this.getValue().getValue() != null ? ((IKeyword)KeywordEditor.this.getValue().getValue()).toString() : null;
                            jTextField.setText(string);
                            jTextField.setToolTipText(string);
                            jTextField.setCaretPosition(0);
                        }
                        finally {
                            KeywordEditor.this.updatingValue = false;
                        }
                    }
                }
            });
            JButton jButton2 = SwingUtilities2.createButton((Icon)UIManager.getIcon("delete"));
            jButton2.setPreferredSize(new Dimension(GUI.getScaledInt((int)25), jButton.getPreferredSize().height));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jTextField.setText(null);
                    jTextField.setToolTipText(null);
                    KeywordEditor.this.setValues(new IKeyword[0]);
                }
            });
            JPanel jPanel = SwingUtilities2.createPanel((Boolean)false, null);
            jPanel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0, -2.0, -2.0}, new double[]{-2.0}));
            jPanel.add((Component)jTextField, "0,0");
            jPanel.add((Component)jButton, "1,0");
            jPanel.add((Component)jButton2, "2,0");
            return jPanel;
        }

        protected void valuesChanged(IKeyword ... iKeywordArray) {
            if (!this.updatingValue) {
                IKeyword iKeyword;
                IKeyword iKeyword2 = iKeyword = iKeywordArray != null && iKeywordArray.length > 0 ? iKeywordArray[0] : null;
                if (this.keyprov == null) {
                    ((JTextField)this.getEditor()).setText(iKeyword != null ? iKeyword.getText() : null);
                } else {
                    ((JTextField)((JPanel)this.getEditor()).getComponent(0)).setText(iKeyword != null ? iKeyword.getText() : null);
                }
            }
        }
    }

    private static class ModalityEditor
    extends AbstractTeachingFilePropertyValueEditor<Modality> {
        public ModalityEditor(TeachingFileProperty<Modality> teachingFileProperty, TeachingFilePropertyValue<Modality> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        protected JComboBox createEditor(TeachingFilePropertyValue<Modality> teachingFilePropertyValue) {
            JComboBox jComboBox = SwingUtilities2.createComboBox((Object[])teachingFilePropertyValue.getValueType().getValueSet(), null);
            jComboBox.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jComboBox.getPreferredSize().height));
            jComboBox.setSelectedItem(teachingFilePropertyValue.getValue());
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Modality modality = (Modality)((JComboBox)actionEvent.getSource()).getSelectedItem();
                    ModalityEditor.this.setValues(modality);
                }
            });
            return jComboBox;
        }

        protected void valuesChanged(Modality ... modalityArray) {
            Modality modality = modalityArray != null && modalityArray.length > 0 ? modalityArray[0] : null;
            ((JComboBox)this.getEditor()).setSelectedItem(modality);
        }
    }

    private static class MultiLineStringEditor
    extends AbstractTeachingFilePropertyValueEditor<String> {
        public MultiLineStringEditor(TeachingFileProperty<String> teachingFileProperty, TeachingFilePropertyValue<String> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        @Override
        protected JComponent createEditor(TeachingFilePropertyValue<String> teachingFilePropertyValue) {
            JTextArea jTextArea = SwingUtilities2.createTextArea((String)((String)teachingFilePropertyValue.getValue()), null, null);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                private void setValue(Document document) {
                    try {
                        MultiLineStringEditor.this.setValues(document.getText(0, document.getLength()));
                    }
                    catch (Exception exception) {}
                }
            });
            JScrollPane jScrollPane = SwingUtilities2.createScrollPane((Component)jTextArea, (Integer)20, (Integer)31, (Boolean)false, (Boolean)false);
            jScrollPane.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), GUI.getScaledInt((int)80)));
            return jScrollPane;
        }

        protected void valuesChanged(String ... stringArray) {
            JTextArea jTextArea = (JTextArea)((JScrollPane)this.getEditor()).getViewport().getView();
            jTextArea.setText(null);
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    jTextArea.append(string);
                    ++n2;
                }
            }
        }
    }

    private static class MultiLineStringKeywordEditor
    extends AbstractTeachingFilePropertyValueEditor<IKeyword> {
        public MultiLineStringKeywordEditor(TeachingFileProperty<IKeyword> teachingFileProperty, TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        @Override
        protected JComponent createEditor(TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue) {
            JTextArea jTextArea = SwingUtilities2.createTextArea((String)(teachingFilePropertyValue.getValue() != null ? ((IKeyword)teachingFilePropertyValue.getValue()).toString() : null), null, null);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                private void setValue(Document document) {
                    try {
                        MultiLineStringKeywordEditor.this.setValues(Keyword.createText((String)document.getText(0, document.getLength())));
                    }
                    catch (Exception exception) {}
                }
            });
            JScrollPane jScrollPane = SwingUtilities2.createScrollPane((Component)jTextArea, (Integer)20, (Integer)31, (Boolean)false, (Boolean)false);
            jScrollPane.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), GUI.getScaledInt((int)80)));
            return jScrollPane;
        }

        protected void valuesChanged(IKeyword ... iKeywordArray) {
            JTextArea jTextArea = (JTextArea)((JScrollPane)this.getEditor()).getViewport().getView();
            jTextArea.setText(null);
            if (iKeywordArray != null) {
                IKeyword[] iKeywordArray2 = iKeywordArray;
                int n = iKeywordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IKeyword iKeyword = iKeywordArray2[n2];
                    jTextArea.append(iKeyword != null ? iKeyword.getText() : null);
                    ++n2;
                }
            }
        }
    }

    private static class MultiValueEditor<T>
    extends AbstractTeachingFilePropertyValueEditor<T> {
        public MultiValueEditor(TeachingFileProperty<T> teachingFileProperty, TeachingFilePropertyValue<T> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        @Override
        protected JComponent createEditor(TeachingFilePropertyValue<T> teachingFilePropertyValue) {
            TeachingFilePropertyValueListModelWrapper<T> teachingFilePropertyValueListModelWrapper = new TeachingFilePropertyValueListModelWrapper<T>(this, teachingFilePropertyValue);
            JList<T> jList = new JList<T>(teachingFilePropertyValueListModelWrapper);
            JButton jButton = new JButton(new AddMultiValueAction(this.getProperty(), teachingFilePropertyValueListModelWrapper));
            JButton jButton2 = new JButton(new RemoveMultiValueAction<T>(jList, teachingFilePropertyValueListModelWrapper));
            TableLayout tableLayout = new TableLayout(new double[]{-1.0, -2.0}, new double[]{-2.0, -2.0, -1.0});
            JPanel jPanel = SwingUtilities2.createPanel((Boolean)false, null);
            jPanel.setLayout((LayoutManager)tableLayout);
            jPanel.add((Component)jButton, "1,0");
            jPanel.add((Component)jButton2, "1,1");
            jPanel.add((Component)SwingUtilities2.createScrollPane(jList, null, null, (Boolean)true, (Boolean)false), "0,0,0,2");
            return jPanel;
        }
    }

    private static class RemoveMultiValueAction<T>
    extends AbstractAction
    implements ListSelectionListener {
        private JList<T> list;
        private TeachingFilePropertyValueListModelWrapper<T> listModel;

        public RemoveMultiValueAction(JList<T> jList, TeachingFilePropertyValueListModelWrapper<T> teachingFilePropertyValueListModelWrapper) {
            super(null, UIManager.getIcon("remove"));
            this.listModel = teachingFilePropertyValueListModelWrapper;
            this.list = jList;
            this.list.addListSelectionListener(this);
            this.setEnabled(jList.getSelectedIndex() >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<T> list = this.list.getSelectedValuesList();
            if (list != null) {
                for (T t : list) {
                    this.listModel.removeValue(t);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(this.list.getSelectedIndex() >= 0);
        }
    }

    private static class StringEditor
    extends AbstractTeachingFilePropertyValueEditor<String> {
        private String[] options;

        public StringEditor(TeachingFileProperty<String> teachingFileProperty, TeachingFilePropertyValue<String> teachingFilePropertyValue, String string) {
            this(teachingFileProperty, teachingFilePropertyValue, string, null);
        }

        public StringEditor(TeachingFileProperty<String> teachingFileProperty, TeachingFilePropertyValue<String> teachingFilePropertyValue, String string, String ... stringArray) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
            this.options = stringArray;
        }

        @Override
        protected JComponent createEditor(TeachingFilePropertyValue<String> teachingFilePropertyValue) {
            JComponent jComponent = null;
            if (this.options != null && this.options.length > 0) {
                final JComboBox jComboBox = SwingUtilities2.createComboBox((Object[])this.options, null);
                jComboBox.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jComboBox.getPreferredSize().height));
                jComboBox.setSelectedItem(teachingFilePropertyValue.getValue());
                jComboBox.setEditable(true);
                jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object object = jComboBox.getSelectedItem();
                        StringEditor.this.setValues(object != null ? object.toString() : null);
                    }
                });
                jComponent = jComboBox;
            } else {
                JTextField jTextField = SwingUtilities2.createTextField((String)((String)teachingFilePropertyValue.getValue()), null, null);
                jTextField.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jTextField.getPreferredSize().height));
                jTextField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.setValue(documentEvent.getDocument());
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.setValue(documentEvent.getDocument());
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.setValue(documentEvent.getDocument());
                    }

                    private void setValue(Document document) {
                        try {
                            StringEditor.this.setValues(document.getText(0, document.getLength()));
                        }
                        catch (Exception exception) {}
                    }
                });
                jComponent = jTextField;
            }
            return jComponent;
        }

        protected void valuesChanged(String ... stringArray) {
            JComponent jComponent = this.getEditor();
            if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).setText(stringArray != null ? stringArray[0] : null);
            } else if (jComponent instanceof JComboBox) {
                ((JComboBox)jComponent).setSelectedItem(stringArray != null && stringArray.length > 0 ? stringArray[0] : null);
            }
        }
    }

    private static class StringKeywordEditor
    extends AbstractTeachingFilePropertyValueEditor<IKeyword> {
        public StringKeywordEditor(TeachingFileProperty<IKeyword> teachingFileProperty, TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue, String string) {
            super(teachingFileProperty, teachingFilePropertyValue, string);
        }

        @Override
        protected JComponent createEditor(TeachingFilePropertyValue<IKeyword> teachingFilePropertyValue) {
            JTextField jTextField = SwingUtilities2.createTextField((String)(teachingFilePropertyValue.getValue() != null ? ((IKeyword)teachingFilePropertyValue.getValue()).toString() : null), null, null);
            jTextField.setPreferredSize(new Dimension(GUI.getScaledInt((int)250), jTextField.getPreferredSize().height));
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.setValue(documentEvent.getDocument());
                }

                private void setValue(Document document) {
                    try {
                        StringKeywordEditor.this.setValues(Keyword.createText((String)document.getText(0, document.getLength())));
                    }
                    catch (Exception exception) {}
                }
            });
            return jTextField;
        }

        protected void valuesChanged(IKeyword ... iKeywordArray) {
            IKeyword iKeyword = iKeywordArray != null && iKeywordArray.length > 0 ? iKeywordArray[0] : null;
            ((JTextField)this.getEditor()).setText(iKeyword != null ? iKeyword.getText() : null);
        }
    }

    private static class TeachingFilePropertyValueListModelWrapper<T>
    extends AbstractListModel<T> {
        private AbstractTeachingFilePropertyValueEditor<?> editor;
        private TeachingFilePropertyValue<T> value;

        public TeachingFilePropertyValueListModelWrapper(AbstractTeachingFilePropertyValueEditor<?> abstractTeachingFilePropertyValueEditor, TeachingFilePropertyValue<T> teachingFilePropertyValue) {
            this.editor = abstractTeachingFilePropertyValueEditor;
            this.value = teachingFilePropertyValue;
        }

        public boolean removeValue(T t) {
            int n = this.value.getIndexOfValue(t);
            if (this.value.removeValues(new Object[]{t})) {
                this.fireIntervalRemoved(this, n, n);
                this.editor.fireValueChanged();
                return true;
            }
            return false;
        }

        public boolean addValue(T t) {
            if (this.value.addValues(new Object[]{t})) {
                int n = this.value.getIndexOfValue(t);
                this.fireIntervalAdded(this, n, n);
                this.editor.fireValueChanged();
                return true;
            }
            return false;
        }

        @Override
        public int getSize() {
            return this.value.getValueCount();
        }

        @Override
        public T getElementAt(int n) {
            return (T)this.value.getValueAt(n);
        }
    }
}

