/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.iod.sr;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.listtext.dicomobject.sr.content.Content;
import com.agfa.pacs.listtext.dicomobject.sr.content.ContentTemplate;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentRelationship;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.sr.contenttree.DocumentContentTree;
import com.agfa.pacs.listtext.dicomobject.sr.contenttree.DocumentContentTreeNode;
import com.agfa.pacs.listtext.dicomobject.type.ContinuityOfContent;
import com.agfa.pacs.listtext.dicomobject.type.RelationshipType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyObjectData {
    public static final ContentTemplate KeyObjectContentTemplate = new ContentTemplate("2010", "DCMR");
    protected String description;
    protected Code documentTitle;
    protected List<Code> documentTitleModifier;
    protected Date observationDateTime;
    protected Code language;
    protected String observerName;
    protected String observersOrganizationName;
    protected Code observersRoleInOrganization;
    protected Code observersRoleInThisProcedure;
    protected Code observerType;
    protected List<ReferencedSOP> referencedComposites;
    protected List<SRReferencedImage> referencedImages;
    protected List<ReferencedWaveform> referencedWaveforms;
    protected List<SOPInstanceReference> references;
    protected List<SOPInstanceReference> identicalDocuments;
    protected Date contentDateTime;
    private Map<String, String[]> relationalReferences = null;

    public KeyObjectData() {
        this.documentTitleModifier = new ArrayList<Code>();
        this.referencedComposites = new ArrayList<ReferencedSOP>();
        this.referencedImages = new ArrayList<SRReferencedImage>();
        this.referencedWaveforms = new ArrayList<ReferencedWaveform>();
        this.references = new ArrayList<SOPInstanceReference>();
        this.identicalDocuments = new ArrayList<SOPInstanceReference>();
    }

    public KeyObjectData(KeyObjectData keyObjectData) {
        this.contentDateTime = keyObjectData.contentDateTime;
        this.description = keyObjectData.description;
        this.documentTitle = keyObjectData.documentTitle;
        this.language = keyObjectData.language;
        this.observationDateTime = keyObjectData.observationDateTime;
        this.observerName = keyObjectData.observerName;
        this.observersOrganizationName = keyObjectData.observersOrganizationName;
        this.observersRoleInOrganization = keyObjectData.observersRoleInOrganization;
        this.observersRoleInThisProcedure = keyObjectData.observersRoleInThisProcedure;
        this.observerType = keyObjectData.observerType;
        this.documentTitleModifier = new ArrayList<Code>();
        this.referencedComposites = new ArrayList<ReferencedSOP>();
        this.referencedImages = new ArrayList<SRReferencedImage>();
        this.referencedWaveforms = new ArrayList<ReferencedWaveform>();
        this.references = new ArrayList<SOPInstanceReference>();
        this.identicalDocuments = new ArrayList<SOPInstanceReference>();
        if (keyObjectData.documentTitleModifier != null) {
            this.documentTitleModifier.addAll(keyObjectData.documentTitleModifier);
        }
        if (keyObjectData.referencedComposites != null) {
            this.referencedComposites.addAll(keyObjectData.referencedComposites);
        }
        if (keyObjectData.referencedImages != null) {
            this.referencedImages.addAll(keyObjectData.referencedImages);
        }
        if (keyObjectData.referencedWaveforms != null) {
            this.referencedWaveforms.addAll(keyObjectData.referencedWaveforms);
        }
        if (keyObjectData.references != null) {
            this.references.addAll(keyObjectData.references);
        }
        if (keyObjectData.identicalDocuments != null) {
            this.identicalDocuments.addAll(keyObjectData.identicalDocuments);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Code getDocumentTitle() {
        return this.documentTitle;
    }

    public void setDocumentTitle(Code code) {
        this.documentTitle = code;
    }

    public List<Code> documentTitleModifier() {
        return this.documentTitleModifier;
    }

    public Date getObservationDateTime() {
        return this.observationDateTime;
    }

    public void setObservationDateTime(Date date) {
        this.observationDateTime = date;
    }

    public Code getLanguage() {
        return this.language;
    }

    public void setLanguage(Code code) {
        this.language = code;
    }

    public String getPersonObserverName() {
        return this.observerName;
    }

    public void setPersonObserverName(String string) {
        this.observerName = string;
    }

    public String getPersonObserversOrganizationName() {
        return this.observersOrganizationName;
    }

    public void setPersonObserversOrganizationName(String string) {
        this.observersOrganizationName = string;
    }

    public Code getPersonObserversRoleInOrganization() {
        return this.observersRoleInOrganization;
    }

    public void setPersonObserversRoleInOrganization(Code code) {
        this.observersRoleInOrganization = code;
    }

    public Code getPersonObserversRoleInThisProcedure() {
        return this.observersRoleInThisProcedure;
    }

    public void setPersonObserversRoleInThisProcedure(Code code) {
        this.observersRoleInThisProcedure = code;
    }

    public Code getObserverType() {
        return this.observerType;
    }

    public void setObserverType(Code code) {
        this.observerType = code;
    }

    public List<ReferencedSOP> referencedComposites() {
        return this.referencedComposites;
    }

    public synchronized Map<String, String[]> getRelationalImageReferences() {
        if (this.relationalReferences == null) {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            for (SOPInstanceReference sOPInstanceReference : this.references) {
                for (ReferencedSeries referencedSeries : sOPInstanceReference.referencedSeries()) {
                    String[] stringArray = new String[]{referencedSeries.getSeriesInstanceUID(), sOPInstanceReference.getStudyInstanceUID()};
                    for (ReferencedSOP referencedSOP : referencedSeries.referencedSOP()) {
                        hashMap.put(referencedSOP.getSOPInstanceUID(), stringArray);
                    }
                }
            }
            this.relationalReferences = hashMap;
        }
        return this.relationalReferences;
    }

    public List<SRReferencedImage> referencedImages() {
        return this.referencedImages;
    }

    public List<ReferencedWaveform> referencedWaveforms() {
        return this.referencedWaveforms;
    }

    public void setContentDateTime(Date date) {
        this.contentDateTime = date;
    }

    public List<SOPInstanceReference> identicalDocuments() {
        return this.identicalDocuments;
    }

    public KeyObjectSelectionDocumentInformationObject toInformationObject() {
        KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject = KeyObjectSelectionDocumentInformationObject.createInstance(null);
        this.build(keyObjectSelectionDocumentInformationObject);
        return keyObjectSelectionDocumentInformationObject;
    }

    public static KeyObjectData create(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject) {
        KeyObjectData keyObjectData = new KeyObjectData();
        keyObjectData.parse(keyObjectSelectionDocumentInformationObject);
        return keyObjectData;
    }

    protected void parse(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject) {
        DocumentContent documentContent = keyObjectSelectionDocumentInformationObject.getSRDocumentContent().getDocumentContent();
        DocumentRelationship documentRelationship = keyObjectSelectionDocumentInformationObject.getSRDocumentContent().getDocumentRelationship();
        if (documentContent == null || documentRelationship == null) {
            return;
        }
        this.documentTitle = documentContent.getConceptName();
        this.observationDateTime = documentRelationship.getObservationDateTime();
        for (Content content : documentRelationship.content()) {
            DocumentContent documentContent2 = content.getDocumentContent();
            switch (documentContent2.getValueType()) {
                case Code: {
                    DocumentContent.CodeContent codeContent = (DocumentContent.CodeContent)documentContent2;
                    if (Code.DocumentTitleModifier.equals((Object)codeContent.getConceptName())) {
                        this.documentTitleModifier.add(codeContent.getConcept());
                    }
                    if (Code.LanguageOfContentItemsAndDescendants.equals((Object)codeContent.getConceptName())) {
                        this.language = codeContent.getConcept();
                    }
                    if (Code.ObserverType.equals((Object)codeContent.getConceptName())) {
                        this.observerType = codeContent.getConcept();
                    }
                    if (Code.PersonObserverRoleInOrganization.equals((Object)codeContent.getConceptName())) {
                        this.observersRoleInOrganization = codeContent.getConcept();
                    }
                    if (!Code.PersonObserverRoleInProcedure.equals((Object)codeContent.getConceptName())) break;
                    this.observersRoleInThisProcedure = codeContent.getConcept();
                    break;
                }
                case PersonName: {
                    DocumentContent.CodeContent codeContent = (DocumentContent.PersonNameContent)documentContent2;
                    if (!Code.PersonObserverName.equals((Object)codeContent.getConceptName())) break;
                    this.observerName = codeContent.getPersonName();
                    break;
                }
                case Text: {
                    DocumentContent.CodeContent codeContent = (DocumentContent.TextContent)documentContent2;
                    if (Code.KeyObjectDescription.equals((Object)documentContent2.getConceptName())) {
                        this.description = codeContent.getTextValue();
                    }
                    if (!Code.PersonObserverOrganizationName.equals((Object)codeContent.getConceptName())) break;
                    this.observersOrganizationName = codeContent.getTextValue();
                    break;
                }
                case Image: {
                    DocumentContent.CodeContent codeContent = (DocumentContent.ImageContent)documentContent2;
                    this.referencedImages.add(codeContent.getReferencedImage());
                    break;
                }
                case Waveform: {
                    DocumentContent.CodeContent codeContent = (DocumentContent.WaveformContent)documentContent2;
                    this.referencedWaveforms.add(codeContent.getReferencedWaveform());
                    break;
                }
                case Composite: {
                    DocumentContent.CodeContent codeContent = (DocumentContent.CompositeContent)documentContent2;
                    this.referencedComposites.add(codeContent.getReferencedSOP());
                }
            }
        }
        this.references.addAll(keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().currentRequestedProcedureEvidences());
    }

    protected void build(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject) {
        DocumentContentTreeNode documentContentTreeNode = DocumentContentTreeNode.createContainer((Code)this.documentTitle, (ContinuityOfContent)ContinuityOfContent.Separate, null);
        documentContentTreeNode.setObservationDateTime(this.observationDateTime);
        for (Code code2 : this.documentTitleModifier) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createCode((Code)Code.DocumentTitleModifier, (Code)code2, (RelationshipType)RelationshipType.HasConceptModifier));
        }
        if (this.language != null) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createCode((Code)Code.LanguageOfContentItemsAndDescendants, (Code)this.language, (RelationshipType)RelationshipType.HasConceptModifier));
        }
        if (this.observerName != null) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createCode((Code)Code.ObserverType, (Code)Code.ObserverTypePerson, (RelationshipType)RelationshipType.HasObserverContext));
            documentContentTreeNode.addChild(DocumentContentTreeNode.createPersonName((Code)Code.PersonObserverName, (String)this.observerName, (RelationshipType)RelationshipType.HasObserverContext));
            if (this.observersOrganizationName != null) {
                documentContentTreeNode.addChild(DocumentContentTreeNode.createText((Code)Code.PersonObserverOrganizationName, (String)this.observersOrganizationName, (RelationshipType)RelationshipType.HasObserverContext));
            }
            if (this.observersRoleInOrganization != null) {
                documentContentTreeNode.addChild(DocumentContentTreeNode.createCode((Code)Code.PersonObserverRoleInOrganization, (Code)this.observersRoleInOrganization, (RelationshipType)RelationshipType.HasObserverContext));
            }
            if (this.observersRoleInThisProcedure != null) {
                documentContentTreeNode.addChild(DocumentContentTreeNode.createCode((Code)Code.PersonObserverRoleInOrganization, (Code)this.observersRoleInThisProcedure, (RelationshipType)RelationshipType.HasObserverContext));
            }
        }
        if (this.description != null) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createText((Code)Code.KeyObjectDescription, (String)this.description, (RelationshipType)RelationshipType.Contains));
        }
        for (SRReferencedImage sRReferencedImage : this.referencedImages) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createImage((SRReferencedImage)sRReferencedImage, (RelationshipType)RelationshipType.Contains));
        }
        for (ReferencedWaveform referencedWaveform : this.referencedWaveforms) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createWaveform((ReferencedWaveform)referencedWaveform, (RelationshipType)RelationshipType.Contains));
        }
        for (ReferencedSOP referencedSOP : this.referencedComposites) {
            documentContentTreeNode.addChild(DocumentContentTreeNode.createComposite((ReferencedSOP)referencedSOP, (RelationshipType)RelationshipType.Contains));
        }
        DocumentContentTree documentContentTree = new DocumentContentTree(documentContentTreeNode);
        documentContentTree.setContentTemplate(KeyObjectContentTemplate);
        documentContentTree.putTo(keyObjectSelectionDocumentInformationObject.getSRDocumentContent());
        keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().currentRequestedProcedureEvidences().addAll(this.references);
        keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().setContentDate(this.contentDateTime);
        keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().setContentTime(this.contentDateTime);
    }

    private ReferencedSOP addReference(List<SOPInstanceReference> list, String string, String string2, String string3, String string4) {
        ReferencedSeries referencedSeries2;
        SOPInstanceReference sOPInstanceReference3;
        SOPInstanceReference sOPInstanceReference2 = null;
        for (SOPInstanceReference sOPInstanceReference3 : list) {
            if (!sOPInstanceReference3.getStudyInstanceUID().equals(string4)) continue;
            sOPInstanceReference2 = sOPInstanceReference3;
            break;
        }
        if (sOPInstanceReference2 == null) {
            sOPInstanceReference2 = new SOPInstanceReference(string4);
            list.add(sOPInstanceReference2);
        }
        sOPInstanceReference3 = null;
        for (ReferencedSeries referencedSeries2 : sOPInstanceReference2.referencedSeries()) {
            if (!referencedSeries2.getSeriesInstanceUID().equals(string3)) continue;
            sOPInstanceReference3 = referencedSeries2;
            break;
        }
        if (sOPInstanceReference3 == null) {
            sOPInstanceReference3 = new ReferencedSeries(string3);
            sOPInstanceReference2.referencedSeries().add(sOPInstanceReference3);
        }
        referencedSeries2 = new ReferencedSOP(string, string2);
        sOPInstanceReference3.referencedSOP().add(referencedSeries2);
        return referencedSeries2;
    }

    public ReferencedSOP addCurrentEvidenceReference(String string, String string2, String string3, String string4) {
        return this.addReference(this.references, string, string2, string3, string4);
    }

    public void addIdenticalDocumentReference(String string, String string2, String string3, String string4) {
        this.addReference(this.identicalDocuments, string, string2, string3, string4);
    }
}

