/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.iod.sr;

import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.listtext.dicomobject.CompositeInformationObject;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectData;
import com.agfa.pacs.listtext.dicomobject.iod.sr.KeyObjectSelectionDocumentInformationObject;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import java.util.ArrayList;
import java.util.List;

public class KeyObject
extends KeyObjectData {
    public KeyObject(KeyObjectData keyObjectData) {
        super(keyObjectData);
    }

    public KeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject) {
        this.parse(keyObjectSelectionDocumentInformationObject);
    }

    public List<KeyObjectSelectionDocumentInformationObject> toKeyObjectSelectionDocumentInformationObjects() {
        ArrayList<KeyObjectSelectionDocumentInformationObject> arrayList = new ArrayList<KeyObjectSelectionDocumentInformationObject>();
        for (SOPInstanceReference sOPInstanceReference : this.identicalDocuments) {
            KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject = this.toKeyObjectSelectionDocumentInformationObject(sOPInstanceReference.getStudyInstanceUID());
            arrayList.add(keyObjectSelectionDocumentInformationObject);
        }
        return arrayList;
    }

    public KeyObjectSelectionDocumentInformationObject toKeyObjectSelectionDocumentInformationObject(String string) {
        KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject = KeyObjectSelectionDocumentInformationObject.createInstance();
        this.build(keyObjectSelectionDocumentInformationObject);
        for (SOPInstanceReference sOPInstanceReference : this.identicalDocuments) {
            if (string != null && sOPInstanceReference.getStudyInstanceUID().equals(string)) continue;
            keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().identicalDocuments().add(sOPInstanceReference);
        }
        return keyObjectSelectionDocumentInformationObject;
    }

    public void toKeyObjectSelectionDocumentInformationObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject) {
        String string = keyObjectSelectionDocumentInformationObject.getStudyIdentifier().getStudyInstanceUID();
        this.build(keyObjectSelectionDocumentInformationObject);
        for (SOPInstanceReference sOPInstanceReference : this.identicalDocuments) {
            if (string != null && sOPInstanceReference.getStudyInstanceUID().equals(string)) continue;
            keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().identicalDocuments().add(sOPInstanceReference);
        }
    }

    public void insertComposite(CompositeInformationObject compositeInformationObject, int[] nArray) {
        this.insertReference(compositeInformationObject.getSOPClassUID(), compositeInformationObject.getSOPInstanceUID(), compositeInformationObject.getSeriesIdentifier().getSeriesInstanceUID(), compositeInformationObject.getStudyIdentifier().getStudyInstanceUID(), nArray);
    }

    public void insertIdentical(String string, String string2, String string3, String string4, int[] nArray) {
        this.addIdenticalDocumentReference(string, string2, string3, string4);
    }

    public void insertReference(String string, String string2, String string3, String string4, int[] nArray) {
        this.addCurrentEvidenceReference(string, string2, string3, string4);
        switch (UIDUtilities.getBaseType((String)string)) {
            case Image: {
                this.referencedImages.add(new SRReferencedImage(string, string2, nArray));
                break;
            }
            case Waveform: {
                this.referencedWaveforms.add(new ReferencedWaveform(string, string2, nArray));
                break;
            }
            case Presentation: 
            case StructuredReport: 
            case KeyObject: 
            case Composite: {
                this.referencedComposites.add(new ReferencedSOP(string, string2));
            }
        }
    }

    public void insertKeyObject(KeyObjectSelectionDocumentInformationObject keyObjectSelectionDocumentInformationObject) {
        Object object2;
        for (Object object2 : keyObjectSelectionDocumentInformationObject.getKeyObjectDocument().currentRequestedProcedureEvidences()) {
            this.addReference((SOPInstanceReference)object2);
        }
        object2 = new KeyObject(keyObjectSelectionDocumentInformationObject);
        this.referencedImages.addAll(object2.referencedImages);
        this.referencedWaveforms.addAll(object2.referencedWaveforms);
        this.referencedComposites.addAll(object2.referencedComposites);
    }

    private void addReference(SOPInstanceReference sOPInstanceReference) {
        for (ReferencedSeries referencedSeries : sOPInstanceReference.referencedSeries()) {
            for (ReferencedSOP referencedSOP : referencedSeries.referencedSOP()) {
                this.addCurrentEvidenceReference(referencedSOP.getSOPClassUID(), referencedSOP.getSOPInstanceUID(), referencedSeries.getSeriesInstanceUID(), sOPInstanceReference.getStudyInstanceUID());
            }
        }
    }
}

