/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObject;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectException;
import com.agfa.pacs.listtext.dicomobject.IInformationObjectProvider;
import com.agfa.pacs.listtext.dicomobject.IModuleContainer;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public abstract class DicomInformationObjectFactory {
    private static DicomInformationObjectFactory implementation;

    protected DicomInformationObjectFactory() {
    }

    public static synchronized DicomInformationObjectFactory getInstance() {
        if (implementation == null) {
            DicomInformationObjectFactory.initialize();
        }
        return implementation;
    }

    public boolean contains(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IInformationObjectProvider getInformationObjectProvider(String string) throws DicomInformationObjectException {
        IInformationObjectProvider iInformationObjectProvider = implementation.getIInformationObjectProviderInt().get(string);
        if (iInformationObjectProvider == null) {
            throw new DicomInformationObjectException(DicomInformationObjectException.Problem.NotSupportedSOPClassUID, "Not supported Class UID: " + string);
        }
        return iInformationObjectProvider;
    }

    public DicomInformationObject createDicomInformationObject(Attributes attributes) throws DicomInformationObjectException {
        String string = attributes.getString(524310, null);
        IInformationObjectProvider iInformationObjectProvider = this.getInformationObjectProvider(string);
        DicomInformationObject dicomInformationObject = iInformationObjectProvider.createInformationObject(attributes, false);
        return dicomInformationObject;
    }

    public DicomInformationObject createDicomInformationObject(String string, Map<Level, Attributes> map) throws DicomInformationObjectException {
        IInformationObjectProvider iInformationObjectProvider = this.getInformationObjectProvider(string);
        DicomInformationObject dicomInformationObject = iInformationObjectProvider.createInformationObject(map, false);
        if (dicomInformationObject != null) {
            dicomInformationObject.getSOPCommon().setSOPClassUID(string);
        }
        return dicomInformationObject;
    }

    public DicomInformationObject createDicomInformationObject(String string, Attributes attributes) throws DicomInformationObjectException {
        IInformationObjectProvider iInformationObjectProvider = this.getInformationObjectProvider(string);
        DicomInformationObject dicomInformationObject = iInformationObjectProvider.createInformationObject(attributes, true);
        if (dicomInformationObject != null) {
            dicomInformationObject.getSOPCommon().setSOPClassUID(string);
        }
        return dicomInformationObject;
    }

    public DicomInformationObject createDicomInformationObject(String string, IModuleContainer iModuleContainer) throws DicomInformationObjectException {
        IInformationObjectProvider iInformationObjectProvider = this.getInformationObjectProvider(string);
        DicomInformationObject dicomInformationObject = iInformationObjectProvider.createInformationObject(iModuleContainer);
        if (dicomInformationObject != null) {
            dicomInformationObject.getSOPCommon().setSOPClassUID(string);
        }
        return dicomInformationObject;
    }

    protected abstract Map<String, IInformationObjectProvider> getIInformationObjectProviderInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DicomInformationObjectFactory.class.getName()));
            implementation = (DicomInformationObjectFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DicomInformationObjectFactory.class.getName(), reflectiveOperationException);
        }
    }
}

