/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import java.util.Collections;
import java.util.List;

public class XDSILoadable
implements ILoadableInfo {
    private static final IInstanceInfo staticInstance = new XDSIInstanceInfo();
    private ReferencedSOP reference;
    private IDataInfoSource source;
    private IPatientInfo patient;

    public XDSILoadable(ReferencedSOP referencedSOP, IPatientInfo iPatientInfo, IDataInfoSource iDataInfoSource) {
        this.reference = referencedSOP;
        this.source = iDataInfoSource;
        this.patient = iPatientInfo;
    }

    public boolean canBeCached() {
        return true;
    }

    public List<IObjectInfo> getAllInstances() {
        return Collections.emptyList();
    }

    public int[] getFrameSelection() {
        throw new UnsupportedOperationException();
    }

    public IInstanceInfo getInstanceInfo() {
        return staticInstance;
    }

    public IPatientInfo getPatient() {
        return this.patient;
    }

    public String getSOPClassUID() {
        return this.reference.getSOPClassUID();
    }

    public String getSOPInstanceUID() {
        return this.reference.getSOPInstanceUID();
    }

    public String getSeriesUID() {
        return this.reference.getSeries().getSeriesInstanceUID();
    }

    public IDataInfoSource getSource() {
        return this.source;
    }

    public String getStudyUID() {
        return this.reference.getSeries().getStudyRef().getStudyInstanceUID();
    }

    public ILoadableInfo.LoadableType getType() {
        return ILoadableInfo.LoadableType.Object;
    }

    public String getUID() {
        return this.reference.getSOPInstanceUID();
    }

    public boolean isFrameSelection() {
        return false;
    }

    public boolean hasInstance(String string) {
        return string.equals(this.getSOPInstanceUID());
    }

    private static class XDSIInstanceInfo
    implements IInstanceInfo {
        private static final String TYPE = "XDSI_WADO";

        private XDSIInstanceInfo() {
        }

        public String getType() {
            return TYPE;
        }

        public String getURIString() {
            return null;
        }
    }
}

