/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectProvider;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectRetriever;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractReferencedObjectProvider
implements IReferencedObjectProvider {
    private String[] supportedSourceTypes;

    public AbstractReferencedObjectProvider(String[] stringArray) {
        this.supportedSourceTypes = stringArray;
    }

    @Override
    public boolean supportsSource(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource != null) {
            return this.isSourceSupported(iDataInfoSource);
        }
        return false;
    }

    @Override
    public List<ReferringObjectType> getSupportedTypes() {
        return Arrays.asList(ReferringObjectType.values());
    }

    @Override
    public List<IObjectInfo> getReferringObjects(IDataInfo iDataInfo, List<ReferringObjectType> list) {
        if (!this.supportsSource(iDataInfo.getSource()) || !this.referencedObjectsAvailable(iDataInfo, list, true)) {
            return Collections.emptyList();
        }
        return ReferencedObjectUtilities.findReferringObjects(iDataInfo, list);
    }

    @Override
    public List<ReferencedObject> getReferencedObjects(IDataInfo iDataInfo, List<ReferringObjectType> list, boolean bl, boolean bl2) throws Exception {
        return this.getReferencedObjects(iDataInfo, DataInfoUtilities.getExpandedObjects((IDataInfo)iDataInfo), list, bl, bl2);
    }

    @Override
    public List<ReferencedObject> getReferencedObjects(IDataInfo iDataInfo, List<IObjectInfo> list, List<ReferringObjectType> list2, boolean bl, boolean bl2) throws Exception {
        ArrayList<ReferencedObject> arrayList = new ArrayList<ReferencedObject>(1);
        if (iDataInfo != null && this.supportsSource(iDataInfo.getSource())) {
            ReferencedObjectRetriever referencedObjectRetriever = new ReferencedObjectRetriever(iDataInfo, list, list2, this.supportedSourceTypes, null, bl, bl2);
            referencedObjectRetriever.run();
            arrayList.addAll(referencedObjectRetriever.getResult());
            Exception exception = referencedObjectRetriever.getLastException();
            if (exception != null) {
                throw exception;
            }
        }
        return arrayList;
    }

    private boolean isSourceSupported(IDataInfoSource iDataInfoSource) {
        if (this.supportedSourceTypes != null) {
            String string = iDataInfoSource.getIdentifier().getType();
            String[] stringArray = this.supportedSourceTypes;
            int n = this.supportedSourceTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string.equals(string2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

