/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.query;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeProviderFactory;
import com.agfa.pacs.data.shared.node.DataInfoNodeUtilities;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.util.query.DataInfoQueryManager;
import com.agfa.pacs.listtext.lta.util.query.IDataInfoQueryItem;
import com.agfa.pacs.listtext.lta.util.query.IDataInfoQueryListener;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class DataInfoQuery {
    private static final ALogger logger = ALogger.getLogger(DataInfoQuery.class);
    private List<IDataInfoQueryItem> toQuery;
    private List<IDataInfo> queryResult;
    private IDataInfoQueryListener queryListener;
    private DataInfoQueryManager searchControl = new DataInfoQueryManager();
    private SearchControlListener searchControlListener = new SearchControlListener();

    public DataInfoQuery(Collection<IDataInfoQueryItem> collection) {
        this.queryResult = new Vector<IDataInfo>();
        this.toQuery = new ArrayList<IDataInfoQueryItem>();
        if (collection != null) {
            this.toQuery.addAll(collection);
        }
    }

    public DataInfoQuery() {
        this(null);
    }

    public List<IDataInfoNode> getQueryNodes() {
        ArrayList<IDataInfoNode> arrayList = new ArrayList<IDataInfoNode>();
        if (this.toQuery != null && !this.toQuery.isEmpty()) {
            for (IDataInfoQueryItem iDataInfoQueryItem : this.toQuery) {
                IDataInfoNode iDataInfoNode = Base.getConfiguredDataInfoNodeByName(iDataInfoQueryItem.getArchiveId());
                if (iDataInfoNode == null || DataInfoNodeUtilities.containsNodeWeak(arrayList, (IDataInfoNode)iDataInfoNode)) continue;
                arrayList.add(iDataInfoNode);
            }
        }
        return arrayList;
    }

    public void stopQuery() {
        this.searchControl.stopSearches();
    }

    public void startQuery(IDataInfoQueryListener iDataInfoQueryListener) {
        this.queryListener = iDataInfoQueryListener;
        this.startQuery();
    }

    public Collection<IDataInfo> getQueryResult() {
        return this.queryResult;
    }

    public void clearQueryResult() {
        this.queryResult.clear();
    }

    public IPersistantFilter getQueryFilter() {
        return null;
    }

    public boolean isQueryRunning() {
        return this.searchControl.searchRunning();
    }

    public void setQuery(Collection<IDataInfoQueryItem> collection) {
        this.toQuery.clear();
        if (collection != null) {
            this.toQuery.addAll(collection);
        }
    }

    public void startQuery() throws IllegalArgumentException {
        this.startQuery(true);
    }

    public void startQuery(boolean bl) throws IllegalArgumentException {
        this.searchControl.reset();
        if (this.toQuery != null && !this.toQuery.isEmpty()) {
            Map<Level, Collection<IDataInfoQueryItem>> map = this.createObjectTypeMap(this.toQuery);
            for (Map.Entry<Level, Collection<IDataInfoQueryItem>> entry : map.entrySet()) {
                Collection<IDataInfoQueryItem> collection = entry.getValue();
                if (collection == null || collection.isEmpty()) continue;
                Map<String, Collection<IDataInfoQueryItem>> map2 = this.createNodeMap(collection);
                for (Map.Entry<String, Collection<IDataInfoQueryItem>> entry2 : map2.entrySet()) {
                    IDataInfoNode iDataInfoNode = this.resolveQueryNode(entry2.getKey());
                    if (iDataInfoNode == null) {
                        logger.warn("Can't search for data-info items on node: Archive is not configured! - didnt find value for key: " + entry2.getKey());
                        continue;
                    }
                    Collection<IPersistantFilter> collection2 = this.createFilters(iDataInfoNode, entry.getKey(), entry.getValue());
                    if (collection2 == null) continue;
                    for (IPersistantFilter iPersistantFilter : collection2) {
                        this.searchControl.addSearchHandler(this.createSearchHandler(iDataInfoNode), iPersistantFilter);
                    }
                }
            }
            this.searchControl.startSearches(this.searchControlListener, bl);
        } else {
            this.queryFinished(DataInfoUtilities.createRoot());
        }
    }

    public Collection<IDataInfoQueryItem> getUnresolvedQueryItems() {
        if (this.toQuery != null && !this.toQuery.isEmpty()) {
            ArrayList<IDataInfoQueryItem> arrayList = null;
            if (this.queryResult == null || this.queryResult.isEmpty()) {
                logger.warn("Query result is empty: Probably the archive(s) is/are offline!");
                arrayList = new ArrayList<IDataInfoQueryItem>();
                arrayList.addAll(this.toQuery);
            } else {
                for (IDataInfoQueryItem iDataInfoQueryItem : this.toQuery) {
                    boolean bl = false;
                    for (IDataInfo iDataInfo : this.queryResult) {
                        if (this.findInfoInTree(iDataInfo, iDataInfoQueryItem) == null) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(iDataInfoQueryItem);
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected ISearchHandler<?> createSearchHandler(IDataInfoNode iDataInfoNode) {
        SearchHandler<IDataInfoNode> searchHandler = new SearchHandler<IDataInfoNode>();
        searchHandler.addDataInfoSource(iDataInfoNode);
        return searchHandler;
    }

    protected Collection<IPersistantFilter> createFilters(IDataInfoNode iDataInfoNode, Level level, Collection<IDataInfoQueryItem> collection) {
        ArrayList<IPersistantFilter> arrayList = new ArrayList<IPersistantFilter>();
        if (Level.Patient.equals((Object)level)) {
            for (IDataInfoQueryItem iDataInfoQueryItem : collection) {
                IPersistantFilter iPersistantFilter = FilterUtilities.getPatient(iDataInfoQueryItem.getKey());
                if (iPersistantFilter == null) continue;
                arrayList.add(iPersistantFilter);
            }
        } else {
            IPersistantFilter iPersistantFilter = null;
            if (Level.Study.equals((Object)level)) {
                iPersistantFilter = FilterUtilities.getStudiesByKeys(this.getKeys(collection));
            } else if (Level.Series.equals((Object)level)) {
                iPersistantFilter = FilterUtilities.getSeriesByKeys(this.getKeys(collection));
            } else if (Level.Object.equals((Object)level)) {
                iPersistantFilter = FilterUtilities.getInstancesByKeys(this.getKeys(collection), null);
            }
            if (iPersistantFilter != null) {
                arrayList.add(iPersistantFilter);
            }
        }
        return arrayList;
    }

    private void queryStarted() {
        if (this.queryListener != null) {
            this.queryListener.queryStarted(this);
        }
    }

    private void querySuccess(IDataInfoNode iDataInfoNode) {
        if (this.queryListener != null) {
            this.queryListener.queryProgressSuccess(this, iDataInfoNode);
        }
    }

    private void queryFailure(IDataInfoNode iDataInfoNode, Throwable throwable) {
        if (this.queryListener != null) {
            this.queryListener.queryProgressFailure(this, iDataInfoNode, throwable);
        }
    }

    private void queryFinished(IRootInfo iRootInfo) {
        this.queryResult = Collections.singletonList(iRootInfo);
        if (this.queryListener != null) {
            this.queryListener.queryFinished(this, this.queryResult);
        }
    }

    private IDataInfoNode resolveQueryNode(String string) {
        if ("DICOMCACHE".equalsIgnoreCase(string)) {
            try {
                return DataInfoNodeProviderFactory.getInstance().getDataNodeProvider("DICOMCACHE").createDataNode("Dicom-Cache", new Properties());
            }
            catch (Exception exception) {
                logger.error(null, (Throwable)exception);
                return null;
            }
        }
        return Base.getConfiguredDataInfoNodeByName(string);
    }

    private Map<Level, Collection<IDataInfoQueryItem>> createObjectTypeMap(Collection<IDataInfoQueryItem> collection) {
        HashMap<Level, Collection<IDataInfoQueryItem>> hashMap = new HashMap<Level, Collection<IDataInfoQueryItem>>();
        if (collection != null) {
            for (IDataInfoQueryItem iDataInfoQueryItem : collection) {
                Collection collection2;
                Level level = iDataInfoQueryItem.getLevel();
                if (!hashMap.containsKey(level)) {
                    hashMap.put(level, new ArrayList());
                }
                if ((collection2 = (Collection)hashMap.get(level)).contains(iDataInfoQueryItem)) continue;
                collection2.add(iDataInfoQueryItem);
            }
        }
        return hashMap;
    }

    private Map<String, Collection<IDataInfoQueryItem>> createNodeMap(Collection<IDataInfoQueryItem> collection) {
        HashMap<String, Collection<IDataInfoQueryItem>> hashMap = new HashMap<String, Collection<IDataInfoQueryItem>>();
        if (collection != null) {
            for (IDataInfoQueryItem iDataInfoQueryItem : collection) {
                Collection collection2;
                String string = iDataInfoQueryItem.getArchiveId();
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, new ArrayList());
                }
                if ((collection2 = (Collection)hashMap.get(string)).contains(iDataInfoQueryItem)) continue;
                collection2.add(iDataInfoQueryItem);
            }
        }
        return hashMap;
    }

    private Collection<String> getKeys(Collection<IDataInfoQueryItem> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IDataInfoQueryItem iDataInfoQueryItem : collection) {
            arrayList.add(iDataInfoQueryItem.getKey());
        }
        return arrayList;
    }

    private IDataInfo findInfoInTree(IDataInfo iDataInfo, IDataInfoQueryItem iDataInfoQueryItem) {
        if (iDataInfo != null) {
            if (iDataInfo.getKey().equals(iDataInfoQueryItem.getKey())) {
                return iDataInfo;
            }
            if (iDataInfo.childrenAvailable()) {
                for (IDataInfo iDataInfo2 : iDataInfo.children()) {
                    IDataInfo iDataInfo3 = this.findInfoInTree(iDataInfo2, iDataInfoQueryItem);
                    if (iDataInfo3 == null) continue;
                    return iDataInfo3;
                }
            }
        }
        return null;
    }

    private class SearchControlListener
    implements DataInfoQueryManager.ISearchControlListener {
        private SearchControlListener() {
        }

        @Override
        public void searchStarted() {
            DataInfoQuery.this.queryStarted();
        }

        @Override
        public void searchSuccess(IDataInfoSource iDataInfoSource) {
            if (iDataInfoSource instanceof IDataInfoNode) {
                DataInfoQuery.this.querySuccess((IDataInfoNode)iDataInfoSource);
            }
        }

        @Override
        public void searchFailure(IDataInfoSource iDataInfoSource, Throwable throwable) {
            if (iDataInfoSource instanceof IDataInfoNode) {
                DataInfoQuery.this.queryFailure((IDataInfoNode)iDataInfoSource, throwable);
            }
        }

        @Override
        public void searchFinished(IRootInfo iRootInfo) {
            DataInfoQuery.this.queryFinished(iRootInfo);
        }
    }
}

