/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.pattern;

import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.util.pattern.FixedStringPattern;
import com.agfa.pacs.listtext.lta.util.pattern.IAttributesPattern;
import com.agfa.pacs.listtext.lta.util.pattern.LoginDataReplacer;
import com.agfa.pacs.listtext.lta.util.pattern.PersonNameAttributesPattern;
import com.agfa.pacs.listtext.lta.util.pattern.StringAttributesPattern;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class WebParameterPatterns {
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    private static final List<IAttributesPattern> PATTERNS = Collections.unmodifiableList(Arrays.asList(new StringAttributesPattern("patientid", 0x100020), new StringAttributesPattern("issuerofpatientid", 0x100021), new PersonNameAttributesPattern("patientname", 0x100010), new StringAttributesPattern("studyuid", 0x20000D), new StringAttributesPattern("studymodalities", 524385), new StringAttributesPattern("studydesc", 528432), new StringAttributesPattern("accessionnumber", 524368), new StringAttributesPattern("bodyparts", 1572885), new FixedStringPattern("username", Messages.getString("Parameter.UserName")), new FixedStringPattern("password", Messages.getString("Parameter.Password"))));
    private static final LoginDataReplacer REPLACER = new LoginDataReplacer(PATTERNS);

    public static Iterable<IAttributesPattern> getPatterns() {
        return PATTERNS;
    }

    public static String getReplacementURL(String string, Attributes attributes) {
        if (string != null && !string.isEmpty()) {
            string = REPLACER.replace(string, attributes, 0, true);
            while (string.contains("%")) {
                int n = string.indexOf(37);
                int n2 = string.indexOf(37, n + 1);
                if (n2 < 0 || n2 - n != 9) break;
                String string2 = string.substring(n + 1, n2);
                String string3 = attributes.getString(Integer.parseInt(string2, 16), "");
                string = String.valueOf(string.substring(0, n)) + string3 + string.substring(n2 + 1);
            }
            return string;
        }
        return null;
    }
}

