/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.listtext.integration.Messages;

public class DicomStudyStatus
implements Comparable<DicomStudyStatus> {
    public static final String COMPLETED = "COMPLETED";
    public static final String READ = "READ";
    public static final String READING = "READING";
    private DicomStudyStatusEnum state;
    private String value = null;

    private DicomStudyStatus(DicomStudyStatusEnum dicomStudyStatusEnum) {
        this.state = dicomStudyStatusEnum;
    }

    private DicomStudyStatus(String string) {
        if (string == null || string.equalsIgnoreCase(COMPLETED)) {
            this.state = DicomStudyStatusEnum.Unread;
        } else if (string.equalsIgnoreCase(READ)) {
            this.state = DicomStudyStatusEnum.Read;
        } else if (string.equalsIgnoreCase(READING)) {
            this.state = DicomStudyStatusEnum.Reading;
        } else {
            this.state = DicomStudyStatusEnum.Other;
            this.value = string;
        }
    }

    public DicomStudyStatusEnum getState() {
        return this.state;
    }

    public String toString() {
        if (this.state == DicomStudyStatusEnum.Other) {
            return this.value;
        }
        return Messages.getString(this.state.name());
    }

    public String getDicom() {
        if (this.state == DicomStudyStatusEnum.Other) {
            return this.value;
        }
        return this.state.getDicom();
    }

    public String getIMPAX6Code() {
        if (this.state == DicomStudyStatusEnum.Reading) {
            return "d";
        }
        if (this.state == DicomStudyStatusEnum.Read) {
            return "D";
        }
        return "N";
    }

    public static DicomStudyStatus fromIMPAX6Code2Status(String string) {
        if (string.equalsIgnoreCase("N")) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Unread);
        }
        if (string.equals("d") || string.equals("t")) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Reading);
        }
        if (string.equals("D") || string.equals("T") || string.equalsIgnoreCase("r")) {
            return new DicomStudyStatus(DicomStudyStatusEnum.Read);
        }
        return new DicomStudyStatus(string);
    }

    public static DicomStudyStatus fromString(String string) {
        return new DicomStudyStatus(string);
    }

    public static DicomStudyStatus fromDicomEnum(DicomStudyStatusEnum dicomStudyStatusEnum) {
        return new DicomStudyStatus(dicomStudyStatusEnum);
    }

    @Override
    public int compareTo(DicomStudyStatus dicomStudyStatus) {
        return this.state.compareTo(dicomStudyStatus.state);
    }

    public static enum DicomStudyStatusEnum {
        Unread,
        Reading,
        Read,
        Other;


        public String getDicom() {
            if (this == Unread) {
                return DicomStudyStatus.COMPLETED;
            }
            if (this == Read) {
                return DicomStudyStatus.READ;
            }
            if (this == Reading) {
                return DicomStudyStatus.READING;
            }
            return null;
        }

        public String toString() {
            if (this == Other) {
                return "";
            }
            return Messages.getString(this.name());
        }
    }
}

