/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICMoveSCU;
import com.agfa.pacs.data.dicom.ICMoveSCUListener;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCMoveSCU;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.WaitCancelable;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class DicomMoveUtils {
    private static final int AET_TITLE_NOT_FOUND_STATUS = 272;
    private static final int AET_TITLE_NOT_FOUND_STATUS1 = 43009;

    public static MoveResult moveInstancesSync(IDicomNode iDicomNode, String string, List<? extends IDataInfo> list, ProgressState progressState) {
        MoveListener moveListener;
        try {
            moveListener = DicomMoveUtils.moveInstancesImpl(iDicomNode, string, list, progressState);
        }
        catch (DicomException dicomException) {
            ALogger.getLogger(DicomMoveUtils.class).error("Move failed", (Throwable)dicomException);
            return MoveResult.MOVE_FAILED;
        }
        moveListener.waitUntilFinished();
        Audit.getInstance().logSendedDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), DataInfoUtilities.forAuditing(list));
        int n = moveListener.getLastError();
        if (n == 272 || n == 43009) {
            return MoveResult.MOVE_NOT_CONFIGURED;
        }
        if (n != 0) {
            return MoveResult.MOVE_FAILED;
        }
        return MoveResult.MOVE_SUCCESSFUL;
    }

    public static boolean moveInstancesSync(IDicomNode iDicomNode, String string, String string2, String string3) {
        int n;
        block6: {
            try {
                Attributes attributes;
                DicomCompositeCMoveSCU dicomCompositeCMoveSCU = null;
                dicomCompositeCMoveSCU = new DicomCompositeCMoveSCU(iDicomNode, DicomCompositeCMoveSCU.DefaultRetrieveClassUIDs);
                MoveListener moveListener = new MoveListener(null, (ICMoveSCU)dicomCompositeCMoveSCU, 1);
                dicomCompositeCMoveSCU.connect();
                if (string3 == null) {
                    attributes = new Attributes();
                    attributes.setString(0x20000D, VR.UI, string2);
                    dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Study, (ICMoveSCUListener)moveListener);
                } else {
                    attributes = new Attributes();
                    if (string2 != null) {
                        attributes.setString(0x20000D, VR.UI, string2);
                    }
                    attributes.setString(0x20000E, VR.UI, string3);
                    dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Series, (ICMoveSCUListener)moveListener);
                }
                moveListener.waitUntilFinished();
                n = moveListener.getLastError();
                if (n != 272 && n != 43009) break block6;
                return false;
            }
            catch (DicomException dicomException) {
                ALogger.getLogger(DicomMoveUtils.class).error("Move failed", (Throwable)dicomException);
                return false;
            }
        }
        return n == 0;
    }

    public static WaitCancelable moveInstances(IDicomNode iDicomNode, String string, List<IDataInfo> list, ProgressState progressState) throws DicomException {
        return DicomMoveUtils.moveInstancesImpl(iDicomNode, string, list, progressState);
    }

    private static MoveListener moveInstancesImpl(IDicomNode iDicomNode, String string, List<? extends IDataInfo> list, ProgressState progressState) throws DicomException {
        DicomCompositeCMoveSCU dicomCompositeCMoveSCU = null;
        list = DicomMoveUtils.reduceDataset(list);
        try {
            dicomCompositeCMoveSCU = new DicomCompositeCMoveSCU(iDicomNode, DicomCompositeCMoveSCU.DefaultRetrieveClassUIDs);
            MoveListener moveListener = new MoveListener(progressState, (ICMoveSCU)dicomCompositeCMoveSCU, list.size());
            progressState.setState(JobState.PROGRESSING);
            progressState.setProgressTitle("Moving from " + iDicomNode.getCalledAET() + " to " + string);
            progressState.setStateMessage("");
            dicomCompositeCMoveSCU.connect();
            for (IDataInfo iDataInfo : list) {
                if (moveListener.getLastError() != 0 || moveListener.isCanceled()) break;
                if (iDataInfo instanceof IStudyInfo) {
                    DicomMoveUtils.sendStudy(dicomCompositeCMoveSCU, string, moveListener, iDataInfo);
                }
                if (iDataInfo instanceof ISeriesInfo) {
                    DicomMoveUtils.sendSerie(dicomCompositeCMoveSCU, string, moveListener, iDataInfo);
                }
                if (!(iDataInfo instanceof IObjectInfo)) continue;
                DicomMoveUtils.sendObject(dicomCompositeCMoveSCU, string, moveListener, iDataInfo);
            }
            return moveListener;
        }
        catch (DicomException dicomException) {
            progressState.setState(JobState.FAILED);
            throw dicomException;
        }
    }

    private static List<IDataInfo> reduceDataset(List<? extends IDataInfo> list) {
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        HashMap<String, IDataInfo> hashMap2 = new HashMap<String, IDataInfo>();
        for (IDataInfo object2 : list) {
            hashMap.put(object2.getKey(), object2);
        }
        while (hashMap.size() > 0) {
            IDataInfo iDataInfo = (IDataInfo)hashMap.values().iterator().next();
            if (iDataInfo.getHierarchyLevel() == Level.Study) {
                hashMap2.put(iDataInfo.getKey(), iDataInfo);
                hashMap.remove(iDataInfo.getKey());
                continue;
            }
            IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
            if (hashMap2.containsKey(iDataInfo2.getKey()) || hashMap.containsKey(iDataInfo2.getKey())) {
                hashMap.remove(iDataInfo.getKey());
                continue;
            }
            List list2 = iDataInfo2.children();
            int n = 0;
            for (IDataInfo iDataInfo3 : list2) {
                if (!hashMap2.containsKey(iDataInfo3.getKey()) && !hashMap.containsKey(iDataInfo3.getKey())) break;
                ++n;
            }
            n = Math.max(DicomMoveUtils.getDicomChildrenCount(iDataInfo2), n);
            if (list2.size() == n) {
                hashMap2.put(iDataInfo2.getKey(), iDataInfo2);
                for (IDataInfo iDataInfo3 : list2) {
                    hashMap2.remove(iDataInfo3.getKey());
                    hashMap.remove(iDataInfo3.getKey());
                }
                continue;
            }
            hashMap.remove(iDataInfo.getKey());
            hashMap2.put(iDataInfo.getKey(), iDataInfo);
        }
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        arrayList.addAll(hashMap2.values());
        return arrayList;
    }

    private static int getDicomChildrenCount(IDataInfo iDataInfo) {
        if (iDataInfo.getHierarchyLevel() == Level.Series) {
            return iDataInfo.getInt(2101769);
        }
        if (iDataInfo.getHierarchyLevel() == Level.Study) {
            return iDataInfo.getInt(2101766);
        }
        return 0;
    }

    private static void sendObject(DicomCompositeCMoveSCU dicomCompositeCMoveSCU, String string, MoveListener moveListener, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(524312, VR.UI, iDataInfo.getString(524312));
        attributes.setString(0x20000E, VR.UI, iDataInfo.getTreeParent().getString(0x20000E));
        attributes.setString(0x20000D, VR.UI, iDataInfo.getTreeParent().getTreeParent().getString(0x20000D));
        IDataInfo iDataInfo2 = iDataInfo.getTreeParent().getTreeParent().getTreeParent();
        attributes.setString(0x100020, VR.LO, iDataInfo2.getString(0x100020));
        if (iDataInfo2.containsValue(0x100021)) {
            attributes.setString(0x100021, VR.LO, iDataInfo2.getString(0x100021));
        }
        dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Image, (ICMoveSCUListener)moveListener);
    }

    private static void sendSerie(DicomCompositeCMoveSCU dicomCompositeCMoveSCU, String string, MoveListener moveListener, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(0x20000E, VR.UI, iDataInfo.getString(0x20000E));
        attributes.setString(0x20000D, VR.UI, iDataInfo.getTreeParent().getString(0x20000D));
        IDataInfo iDataInfo2 = iDataInfo.getTreeParent().getTreeParent();
        attributes.setString(0x100020, VR.LO, iDataInfo2.getString(0x100020));
        if (iDataInfo2.containsValue(0x100021)) {
            attributes.setString(0x100021, VR.LO, iDataInfo2.getString(0x100021));
        }
        dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Series, (ICMoveSCUListener)moveListener);
    }

    private static void sendStudy(DicomCompositeCMoveSCU dicomCompositeCMoveSCU, String string, MoveListener moveListener, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(0x20000D, VR.UI, iDataInfo.getString(0x20000D));
        IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
        attributes.setString(0x100020, VR.LO, iDataInfo2.getString(0x100020));
        if (iDataInfo2.containsValue(0x100021)) {
            attributes.setString(0x100021, VR.LO, iDataInfo2.getString(0x100021));
        }
        dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Study, (ICMoveSCUListener)moveListener);
    }

    private static class MoveListener
    implements ICMoveSCUListener,
    WaitCancelable {
        private int count;
        private int allCount;
        private int allOperations;
        private CountDownLatch mutex = null;
        private int lastError = 0;
        private boolean canceled = false;
        private ProgressState ps;
        private ICMoveSCU cmove = null;

        public MoveListener(ProgressState progressState, ICMoveSCU iCMoveSCU, int n) {
            this.cmove = iCMoveSCU;
            this.mutex = new CountDownLatch(n);
            this.allOperations = n;
            this.ps = progressState;
        }

        public void cmoveFinished(int n, Integer n2, Integer n3) {
            if (n != 0 && n != 65280) {
                this.lastError = n;
                if (this.cmove != null) {
                    try {
                        this.cmove.close();
                    }
                    catch (DicomException dicomException) {}
                }
                this.count = 0;
                if (this.ps != null) {
                    this.ps.setState(JobState.FAILED);
                }
            } else {
                if (n == 0) {
                    n2 = 0;
                }
                if (n2 != null) {
                    this.count = n2;
                    if (n3 != null) {
                        this.allCount = n3 + n2;
                    }
                } else {
                    --this.count;
                }
            }
            if (this.ps != null) {
                this.ps.setProgress((float)(this.allCount - this.count) / (float)this.allCount / (float)this.mutex.getCount() + (float)((long)this.allOperations - this.mutex.getCount()) / (float)this.allOperations);
            }
            if (this.count == 0) {
                this.mutex.countDown();
            }
            if (this.count <= 0 && this.mutex.getCount() == 0L && this.ps != null) {
                this.ps.setProgress(1.0f);
                this.ps.setState(JobState.FINISHED);
            }
        }

        public int getLastError() {
            return this.lastError;
        }

        public void waitUntilFinished() {
            while (true) {
                try {
                    this.mutex.await();
                }
                catch (InterruptedException interruptedException) {
                    ALogger.getLogger(DicomMoveUtils.class).warn("Interruption", (Throwable)interruptedException);
                    continue;
                }
                break;
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isRunning() {
            return this.mutex.getCount() > 0L;
        }

        public void waitUntilFinished(int n) {
            this.waitUntilFinished();
        }
    }

    public static enum MoveResult {
        MOVE_SUCCESSFUL,
        MOVE_FAILED,
        MOVE_NOT_CONFIGURED;

    }
}

