/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.logging.ALogger;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.ArrayUtils;

public class ApplicationUtilities {
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String LOG_FILE_NAME = "agility.log";
    public static final String PERFORMANCE_FILE_NAME = "performance.csv";
    private static final ALogger log = ALogger.getLogger(ApplicationUtilities.class);

    public static byte[] captureScreen(String string) throws Exception {
        Object object;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle rectangle = null;
        GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray;
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = graphicsDeviceArray2[n2];
            Rectangle rectangle2 = ((GraphicsDevice)object).getDefaultConfiguration().getBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(rectangle2);
            } else {
                rectangle.add(rectangle2);
            }
            ++n2;
        }
        object = new Robot();
        BufferedImage bufferedImage = ((Robot)object).createScreenCapture(rectangle);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String dumpStack() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.findDeadlockedThreads();
        if (lArray != null && lArray.length > 0) {
            String object = "Following threads are in a DEADLOCK:";
            stringBuilder.append(object);
            stringBuilder.append(NEWLINE);
            log.error(object);
            List<Long> list = Arrays.asList(ArrayUtils.toObject((long[])lArray));
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                if (!list.contains(entry.getKey().getId())) continue;
                stringBuilder.append(entry.getKey());
                stringBuilder.append(NEWLINE);
                log.error(entry.getKey().toString());
            }
            stringBuilder.append(NEWLINE);
        }
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            int n;
            stringBuilder.append(entry.getKey());
            stringBuilder.append(NEWLINE);
            try {
                ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(new long[]{entry.getKey().getId()}, true, true);
                if (threadInfoArray != null && threadInfoArray.length > 0) {
                    Object object;
                    LockInfo[] lockInfoArray = threadInfoArray[0].getLockedMonitors();
                    int n2 = lockInfoArray.length;
                    n = 0;
                    while (n < n2) {
                        object = lockInfoArray[n];
                        stringBuilder.append("owns monitor: ");
                        stringBuilder.append(((LockInfo)object).getClassName());
                        stringBuilder.append(" ");
                        stringBuilder.append(((LockInfo)object).getIdentityHashCode());
                        stringBuilder.append(NEWLINE);
                        ++n;
                    }
                    lockInfoArray = threadInfoArray[0].getLockedSynchronizers();
                    n2 = lockInfoArray.length;
                    n = 0;
                    while (n < n2) {
                        object = lockInfoArray[n];
                        stringBuilder.append("owns synchronizer: ");
                        stringBuilder.append(((LockInfo)object).getClassName());
                        stringBuilder.append(" ");
                        stringBuilder.append(((LockInfo)object).getIdentityHashCode());
                        stringBuilder.append(NEWLINE);
                        ++n;
                    }
                    object = threadInfoArray[0].getLockInfo();
                    if (object != null) {
                        stringBuilder.append("waiting for: ");
                        stringBuilder.append(((LockInfo)object).getClassName());
                        stringBuilder.append(" ");
                        stringBuilder.append(((LockInfo)object).getIdentityHashCode());
                        stringBuilder.append(NEWLINE);
                    }
                }
            }
            catch (Exception exception) {
                log.warn("Dump error:", (Throwable)exception);
            }
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            n = stackTraceElementArray.length;
            int n3 = 0;
            while (n3 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                stringBuilder.append("\t");
                stringBuilder.append(stackTraceElement);
                stringBuilder.append(NEWLINE);
                ++n3;
            }
            stringBuilder.append(NEWLINE);
        }
        return stringBuilder.toString();
    }

    private static String formatMemory(long l) {
        return Long.toString(l / 0x100000L);
    }

    public static String dumpSystemProperties() {
        StringBuilder stringBuilder = new StringBuilder("All java properties\n");
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean platformManagedObject2 : list) {
            stringBuilder.append(platformManagedObject2.getName()).append(" GC Count:").append(platformManagedObject2.getCollectionCount()).append(NEWLINE);
            stringBuilder.append(platformManagedObject2.getName()).append(" GC Time:").append((float)platformManagedObject2.getCollectionTime() / 1000.0f).append(NEWLINE);
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        stringBuilder.append("Current memory:");
        stringBuilder.append(ApplicationUtilities.formatMemory(memoryUsage.getUsed())).append("MB/").append(ApplicationUtilities.formatMemory(memoryUsage.getCommitted())).append("MB");
        stringBuilder.append(NEWLINE);
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("line.separator")) continue;
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
            stringBuilder.append(NEWLINE);
        }
        return stringBuilder.toString();
    }

    public static String dumpLog(String string) {
        StringBuilder stringBuilder;
        block19: {
            File file = new File(string);
            stringBuilder = new StringBuilder(0x100000);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(NEWLINE);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.warn("Could not dump log: File not found.", (Throwable)fileNotFoundException);
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {
                    log.error("Failed closing file.", (Throwable)iOException);
                }
                break block19;
            }
            catch (IOException iOException) {
                try {
                    log.warn("Could not dump log: Error reading file.", (Throwable)iOException);
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException2) {
                        log.error("Failed closing file.", (Throwable)iOException2);
                    }
                }
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                log.error("Failed closing file.", (Throwable)iOException);
            }
        }
        return stringBuilder.toString();
    }

    public static String execTasklist() {
        StringBuilder stringBuilder;
        block15: {
            String string = "tasklist /FO CSV";
            BufferedReader bufferedReader = null;
            stringBuilder = new StringBuilder();
            try {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec(string);
                    InputStream inputStream = process.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2);
                        stringBuilder.append(NEWLINE);
                    }
                }
                catch (IOException iOException) {
                    log.error("Unknown command '".concat(string).concat("'"), (Throwable)iOException);
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        log.debug("Error on closing BufferedReader", (Throwable)iOException2);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    log.debug("Error on closing BufferedReader", (Throwable)iOException);
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                log.debug("Error on closing BufferedReader", (Throwable)iOException);
            }
        }
        return stringBuilder.toString();
    }
}

