/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCStoreSCU;
import com.agfa.pacs.data.export.AuditProcessor;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.export.BackgroundProcessingTask;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreListener;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.integration.dicomsend.DicomStoreConfigurationFactory;
import com.agfa.pacs.listtext.integration.dicomsend.IDicomStoreConfiguration;
import com.agfa.pacs.listtext.integration.dicomsend.impl.DicomSendNode;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.store.MPPSSender;
import com.agfa.pacs.listtext.lta.store.StorageHandler;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.dcm4che3.data.Attributes;

public class StoreUtils {
    private static final ALogger log = ALogger.getLogger(StoreUtils.class);
    static final String SESSION_CALLING_AET = "EESESSION";
    private static final boolean useSessionCallingAET = ConfigurationProviderFactory.getBaseConfig().getBoolean("listtext.useSpecialAETForSessions");
    private static boolean sendMPPS = ConfigurationProviderFactory.getBaseConfig().getBoolean("listtext.sendMPPS") && !ApplicationManagement.getInstance().getApplicationType().isAgility();
    private static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();

    public static StorageHandler store(ISendNode iSendNode, List<IObjectInfo> list, String string) {
        Object object;
        MPPSSender mPPSSender = null;
        ISendNode iSendNode2 = iSendNode;
        boolean bl = false;
        if (useSessionCallingAET && list.size() == 1 && ReferringObjectType.SESSION.match((IDataInfo)list.get(0))) {
            object = "Session storage";
            iSendNode2 = new DicomSendNode((String)object, (IDicomNode)new SimpleDicomNode(iSendNode.getHost(), iSendNode.getPort(), iSendNode.getCalledAET(), SESSION_CALLING_AET, iSendNode.isEnabled(NodeProperty.Secure), !iSendNode.isEnabled(NodeProperty.KeepAlive), (String)object));
            bl = true;
        }
        if (sendMPPS) {
            mPPSSender = new MPPSSender((IDicomNode)iSendNode, bl);
            mPPSSender.sendMPPSProgress(DataInfoUtilities.toAttributes(list));
        }
        object = new BackgroundProcessingTask("Retrieve->Transcode->Audit->CStore");
        object.setInfo(string);
        Properties properties = new Properties();
        properties.put("DICOM_STORE_TARGET", iSendNode2);
        properties.put("AUDIT_EXPORT_TARGET", iSendNode2.toString());
        properties.put("AUDIT_OPERATION", AuditProcessor.AuditEvent.DicomSend.name());
        IBackgroundTask iBackgroundTask = object.createTask(list, properties, null);
        JobControl jobControl = new JobControl(iBackgroundTask.getInfo(), string);
        jobControl.addTask(iBackgroundTask);
        ProgressStateModel progressStateModel = jobControl.getModel();
        Map map = DataInfoUtilities.forStudyManagment(list);
        dicomCache.registerStudyUsage(map);
        progressStateModel.storeStudyUsageRegistration(map);
        Thread thread = new Thread((Runnable)jobControl, "Store new objects");
        thread.setPriority(1);
        thread.start();
        if (sendMPPS && mPPSSender != null && mPPSSender.mppsInProgressWasSent()) {
            mPPSSender.setMppsComplete(DataInfoUtilities.getLevel(list, ISeriesInfo.class));
            if (!jobControl.addTask(mPPSSender)) {
                mPPSSender.execute();
            }
        }
        return new StorageHandler((BackgroundProcessingTask)object, iBackgroundTask, progressStateModel);
    }

    public static boolean storeObjects(IDataInfoSource iDataInfoSource, Attributes ... attributesArray) {
        return StoreUtils.storeObjects(iDataInfoSource, false, attributesArray);
    }

    public static boolean storeObjects(IDataInfoSource iDataInfoSource, boolean bl, Attributes ... attributesArray) {
        block6: {
            block7: {
                if (attributesArray == null || attributesArray.length == 0) {
                    log.warn("Nothing to store.");
                    return true;
                }
                IDicomStoreConfiguration iDicomStoreConfiguration = DicomStoreConfigurationFactory.getConfiguration();
                ISendNode iSendNode = DicomStoreConfigurationFactory.getConfiguration().getPreferedNode(iDataInfoSource);
                if (iSendNode == null) {
                    log.error("Inferring store target node failed.");
                    return false;
                }
                StoreUtils.storeObjects((IDicomNode)iSendNode, attributesArray);
                if (!bl) break block6;
                ISendNode iSendNode2 = iDicomStoreConfiguration.getPreferedNode(iDataInfoSource);
                if (iSendNode2 != null) break block7;
                log.error("Inferring commit target node failed");
                return true;
            }
            try {
                ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
                int n = 0;
                while (n < attributesArray.length) {
                    arrayList.add(attributesArray[n]);
                    ++n;
                }
            }
            catch (Exception exception) {
                log.error("Saving DICOM objects failed.", (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    public static void storeObjects(IDicomNode iDicomNode, Attributes ... attributesArray) throws DicomException {
        StoreUtils.storeObjects(iDicomNode, true, attributesArray);
    }

    public static void storeObjects(IDicomNode iDicomNode, boolean bl, Attributes ... attributesArray) throws DicomException {
        Attributes attributes = attributesArray[0];
        boolean bl2 = attributes.getString(524310).equals("1.2.840.10008.5.1.4.1.1.88.59") && ReferringObjectType.REJECTED_FOR_QUALITY_REASONS.match(attributes);
        List<Attributes> list = Arrays.asList(attributesArray);
        if (bl && !bl2) {
            Audit.getInstance().logBeginSendDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), list);
        }
        MPPSSender mPPSSender = null;
        if (sendMPPS && !bl2) {
            mPPSSender = new MPPSSender(iDicomNode);
            mPPSSender.sendMPPSProgress(list);
        }
        String string = "8";
        DicomCompositeCStoreSCU dicomCompositeCStoreSCU = null;
        String string2 = attributesArray[0].getString(524310);
        try {
            dicomCompositeCStoreSCU = new DicomCompositeCStoreSCU(iDicomNode, string2);
            dicomCompositeCStoreSCU.connect();
            Attributes[] attributesArray2 = attributesArray;
            int n = attributesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Attributes attributes2 = attributesArray2[n2];
                dicomCompositeCStoreSCU.store(attributes2);
                ++n2;
            }
            if (sendMPPS && mPPSSender != null && mPPSSender.mppsInProgressWasSent()) {
                mPPSSender.setMppsComplete(attributesArray);
                mPPSSender.execute();
            }
            string = "0";
        }
        catch (Throwable throwable) {
            if (dicomCompositeCStoreSCU != null) {
                try {
                    dicomCompositeCStoreSCU.close();
                }
                catch (DicomException dicomException) {}
            }
            if (bl && !bl2) {
                Audit.getInstance().logAuditMessage(Audit.getInstance().logSendedDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), list), string);
            }
            throw throwable;
        }
        if (dicomCompositeCStoreSCU != null) {
            try {
                dicomCompositeCStoreSCU.close();
            }
            catch (DicomException dicomException) {}
        }
        if (bl && !bl2) {
            Audit.getInstance().logAuditMessage(Audit.getInstance().logSendedDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), list), string);
        }
    }

    public static IDicomNode findSourceDicomNode(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource.getIdentifier() instanceof IDicomNode) {
            return (IDicomNode)iDataInfoSource.getIdentifier();
        }
        return null;
    }

    public static IDataInfoSource findSourceForTarget(ISendNode iSendNode) {
        return StoreUtils.findSourceForTarget(iSendNode, null);
    }

    public static IDataInfoSource findSourceForTarget(ISendNode iSendNode, IDataInfoSource iDataInfoSource) {
        String string;
        String[] stringArray = Base.getDataInfoNodes().iterator();
        while (stringArray.hasNext()) {
            string = (IDataInfoSource)stringArray.next();
            if (!StoreUtils.equalsDicomSource(iSendNode, (IDataInfoSource)string) || StoreUtils.isUnsupportedSource((IDataInfoSource)string)) continue;
            log.debug("Resolved configured search/query archive '" + string.getIdentifier().getName() + "' for send-node '" + iSendNode.getName() + "'");
            return string;
        }
        string = iSendNode.getName();
        if (string != null && (stringArray = DicomStoreConfigurationFactory.getConfiguration().resolveSourceNodes(string)) != null) {
            if (stringArray.length > 1) {
                log.debug("Cannot resolve a mapped query-node for send-node '" + string + "': Mapping is not unique!");
            } else if (stringArray.length == 1) {
                IDataInfoNode iDataInfoNode = Base.getConfiguredDataInfoNodeByName(stringArray[0]);
                if (iDataInfoNode != null) {
                    log.debug("Resolved configured search/query archive '" + iDataInfoNode.getName() + "' from query->store-nodes mapping for send-node " + string);
                    return iDataInfoNode;
                }
                log.debug("Cannot resolve configured query/search archive for mapped query-node '" + stringArray[0] + "'");
            }
        }
        if (iDataInfoSource != null && StoreUtils.equalsDicomSource(iSendNode, iDataInfoSource)) {
            log.debug("Resolved parent source '" + iDataInfoSource.getIdentifier().getName() + "' for send-node '" + iSendNode.getName() + "'");
            return iDataInfoSource;
        }
        return null;
    }

    private static boolean equalsDicomSource(ISendNode iSendNode, IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource != null && iDataInfoSource.getIdentifier() != null && iDataInfoSource.getIdentifier().getPropertiesOwner() instanceof IDicomNode) {
            IDicomNode iDicomNode = (IDicomNode)iDataInfoSource.getIdentifier().getPropertiesOwner();
            if (iSendNode.getHost().equalsIgnoreCase(iDicomNode.getHost()) && iSendNode.getCalledAET().equals(iDicomNode.getCalledAET())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnsupportedSource(IDataInfoSource iDataInfoSource) {
        return iDataInfoSource == null || iDataInfoSource.getIdentifier() == null || "DICOMPS".equals(iDataInfoSource.getIdentifier().getType()) || "DICOMCACHE".equals(iDataInfoSource.getIdentifier().getType()) || "GPWL".equals(iDataInfoSource.getIdentifier().getType()) || "IMPAXEE".equals(iDataInfoSource.getIdentifier().getType());
    }

    public static void awaitStore(List<IStoreHandler> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(list.size());
        IStoreListener iStoreListener = new IStoreListener(){

            public void storeStateChanged(JobState jobState) {
                log.info("Store listener status changed to: " + jobState);
                switch (jobState) {
                    case FINISHED: 
                    case RETIRED: 
                    case FAILED: {
                        countDownLatch.countDown();
                    }
                }
            }
        };
        for (IStoreHandler iStoreHandler : list) {
            iStoreHandler.addStoreListener(iStoreListener);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            log.error("Waiting for store handlers failed.", (Throwable)interruptedException);
        }
    }
}

