/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.listtext.dicomworklists.mwl.ModalityWorkListNServiceSCU;
import com.agfa.pacs.listtext.lta.store.MWLNode;
import com.agfa.pacs.logging.ALogger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class MPPSSender
implements IBackgroundTask {
    private static final ALogger log = ALogger.getLogger(MPPSSender.class);
    private IDicomNode destinationNode = null;
    private ModalityWorkListNServiceSCU nservice;
    private Attributes mpps;
    private String mppsUID;
    private volatile boolean canceled = false;
    private boolean mppsInProgressSend = false;
    private boolean isEESession;

    public MPPSSender(IDicomNode iDicomNode, boolean bl) {
        this.isEESession = bl;
        List<MWLNode> list = MWLNode.getConfiguredNodes();
        for (MWLNode mWLNode : list) {
            if (!mWLNode.toString().equalsIgnoreCase(iDicomNode.toString())) continue;
            this.destinationNode = mWLNode.getMPPSNode(iDicomNode);
            break;
        }
        if (this.destinationNode == null) {
            this.destinationNode = iDicomNode;
        }
    }

    public MPPSSender(IDicomNode iDicomNode) {
        this(iDicomNode, false);
    }

    public boolean mppsInProgressWasSent() {
        return this.mppsInProgressSend;
    }

    public void sendMPPSProgress(List<? extends Attributes> list) {
        this.sendMppsProgressImpl(list);
    }

    private void sendMppsProgressImpl(List<? extends Attributes> list) {
        Attributes attributes = new Attributes();
        this.fillSOPCommon(attributes);
        this.fillPerformedProcedureStepRelationship(attributes, list);
        this.fillPerformedProcedureStepInformationNCreate(attributes, list, "IN PROGRESS");
        attributes.addSelected(list.get(0), new int[]{524384});
        this.mppsUID = attributes.getString(524312);
        try {
            this.nservice = new ModalityWorkListNServiceSCU(this.destinationNode);
            this.nservice.connect();
            this.nservice.nCreate(null, "1.2.840.10008.3.1.2.3.3", this.mppsUID, attributes);
            this.mppsInProgressSend = true;
        }
        catch (DicomException dicomException) {
            log.error("MPPS Create failed", (Throwable)dicomException);
        }
    }

    public void setMppsComplete(List<ISeriesInfo> list) {
        this.mpps = new Attributes();
        this.fillSOPCommon(this.mpps);
        this.fillPerformedProcedureStepInformationNSet(this.mpps, "COMPLETED");
        this.fillImageAcqisitionResultsNSetSeries(this.mpps, list);
    }

    public void setMppsComplete(Attributes[] attributesArray) {
        this.mpps = new Attributes();
        this.fillSOPCommon(this.mpps);
        this.fillPerformedProcedureStepInformationNSet(this.mpps, "COMPLETED");
        this.fillImageAcqisitionResultsNSetImages(this.mpps, attributesArray);
    }

    private void fillSOPCommon(Attributes attributes) {
        if (this.mppsUID == null) {
            this.mppsUID = UIDUtils.createUID();
        }
        attributes.setString(524310, VR.UI, "1.2.840.10008.3.1.2.3.3");
        attributes.setString(524312, VR.UI, this.mppsUID);
        attributes.setString(524293, VR.CS, "ISO_IR 100");
        attributes.setInt(2097171, VR.IS, new int[]{1});
    }

    private void fillPerformedProcedureStepRelationship(Attributes attributes, List<? extends Attributes> list) {
        Attributes attributes2 = list.get(0);
        attributes.addSelected(attributes2, new int[]{0x100010, 0x100020, 0x100021, 0x100030, 0x100040});
        Sequence sequence = attributes.newSequence(4194928, 2);
        Attributes attributes3 = new Attributes(attributes2, new int[]{524368, 0x20000D});
        sequence.add(attributes3);
        if (!attributes3.containsValue(524368) && this.isEESession) {
            attributes3.setString(524368, VR.SH, "EESESSION");
        }
    }

    private void fillPerformedProcedureStepInformationNCreate(Attributes attributes, List<? extends Attributes> list, String string) {
        attributes.setString(4194881, VR.AE, DicomDeviceConfigurationFactory.getConfiguration().getDefaultAET());
        attributes.setString(0x400242, VR.SH, Product.getProductName());
        attributes.setDate(18016889594708549L, new Date());
        attributes.setString(4194899, VR.SH, UIDUtils.createUID());
        attributes.setString(4194898, VR.CS, string);
        attributes.setString(4194900, VR.LO, "ED Creation");
    }

    private void fillPerformedProcedureStepInformationNSet(Attributes attributes, String string) {
        attributes.setDate(18016941134316113L, new Date());
        attributes.setString(4194898, VR.CS, string);
    }

    private void fillImageAcqisitionResultsNSetSeries(Attributes attributes, List<ISeriesInfo> list) {
        Sequence sequence = attributes.newSequence(0x400340, 10);
        for (ISeriesInfo iSeriesInfo : list) {
            Attributes attributes2 = new Attributes(iSeriesInfo.getAttributes(), new int[]{528446, 1577008, 0x20000E});
            sequence.add(attributes2);
            Sequence sequence2 = attributes2.newSequence(528704, iSeriesInfo.children().size());
            Sequence sequence3 = attributes2.newSequence(0x400220, 2);
            for (IDataInfo iDataInfo : iSeriesInfo.children()) {
                if (UIDUtilities.getBaseType((String)iDataInfo.getString(524310)) == UIDType.Image) {
                    sequence2.add(new Attributes(iDataInfo.getAttributes(), new int[]{524310, 524312}));
                    continue;
                }
                sequence3.add(new Attributes(iDataInfo.getAttributes(), new int[]{524310, 524312}));
            }
            if (sequence2.isEmpty()) {
                attributes2.remove(528704);
            }
            if (!sequence3.isEmpty()) continue;
            attributes2.remove(0x400220);
        }
    }

    private void fillImageAcqisitionResultsNSetImages(Attributes attributes, Attributes[] attributesArray) {
        Sequence sequence = attributes.newSequence(0x400340, 10);
        HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>();
        Attributes[] attributesArray2 = attributesArray;
        int n = attributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sequence sequence2;
            Attributes attributes2 = attributesArray2[n2];
            String string = attributes2.getString(0x20000E);
            if (!hashMap.containsKey(string)) {
                sequence2 = new Attributes(attributes2, new int[]{528446, 1577008, 0x20000E});
                sequence.add((Attributes)sequence2);
                sequence2.newSequence(528704, 16);
                sequence2.newSequence(0x400220, 2);
                hashMap.put(string, sequence2);
            }
            if (UIDUtilities.getBaseType((String)attributes2.getString(524310)) == UIDType.Image) {
                sequence2 = ((Attributes)hashMap.get(string)).getSequence(528704);
                sequence2.add(new Attributes(attributes2, new int[]{524310, 524312}));
            } else {
                sequence2 = ((Attributes)hashMap.get(string)).getSequence(0x400220);
                sequence2.add(new Attributes(attributes2, new int[]{524310, 524312}));
            }
            ++n2;
        }
    }

    public String getUID() {
        return this.mppsUID;
    }

    public String getInfo() {
        return "Send MPPS";
    }

    public boolean execute() {
        if (this.canceled) {
            return false;
        }
        try {
            try {
                this.nservice.nSet(null, "1.2.840.10008.3.1.2.3.3", this.mppsUID, this.mpps);
            }
            catch (DicomException dicomException) {
                log.error("Could not complete MPPS", (Throwable)dicomException);
                try {
                    this.nservice.close();
                }
                catch (DicomException dicomException2) {}
                this.nservice = null;
                this.mpps = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                this.nservice.close();
            }
            catch (DicomException dicomException) {}
            this.nservice = null;
            this.mpps = null;
            throw throwable;
        }
        try {
            this.nservice.close();
        }
        catch (DicomException dicomException) {}
        this.nservice = null;
        this.mpps = null;
        return true;
    }

    public void terminate() {
        this.canceled = true;
    }

    public void take(IBackgroundProgress iBackgroundProgress) {
    }
}

