/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.progress;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.listtext.lta.progress.IProgressManagerProvider;
import com.agfa.pacs.listtext.lta.progress.IProgressStateManager;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JDialog;

public abstract class ProgressManagerFactory {
    private static ProgressManagerFactory implementation = null;
    private IProgressStateManager manager = null;

    public static IProgressStateManager getManager() {
        if (implementation == null) {
            ProgressManagerFactory.initialize();
        }
        return ProgressManagerFactory.implementation.manager;
    }

    protected ProgressManagerFactory() {
        List<IProgressManagerProvider> list = this.getProvidersInt();
        this.manager = list.size() == 0 ? new ManagerFake() : this.getProvidersInt().get(0).createProgressManager();
    }

    protected abstract List<IProgressManagerProvider> getProvidersInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)ProgressManagerFactory.class.getName()));
            implementation = (ProgressManagerFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + ProgressManagerFactory.class.getName(), reflectiveOperationException);
        }
    }

    private static class ManagerFake
    implements IProgressStateManager {
        private ManagerFake() {
        }

        @Override
        public void addProgressState(ProgressStateModel progressStateModel) {
        }

        @Override
        public ProgressStateModel createProgressState() {
            return new ProgressStateModel();
        }

        @Override
        public ProgressStateModel createAndAddProgress() {
            return new ProgressStateModel();
        }

        @Override
        public JDialog showNonModalDialog(Component component, boolean bl) {
            return null;
        }

        @Override
        public boolean hasRunningJobs() {
            return false;
        }
    }
}

