/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dirwatcher;

import com.agfa.pacs.base.dirwatcher.IDirectoryWatcher;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcherListener;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.listtext.integration.dirwatcher.AbstractDirectoryWatcher;
import com.agfa.pacs.listtext.integration.dirwatcher.SimpleDirectoryScanner;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;

public class SimpleDirectoryWatcher
extends AbstractDirectoryWatcher<SimpleDirectoryScanner> {
    private static final ALogger log = ALogger.getLogger(SimpleDirectoryWatcher.class);
    private CheckThread thread = null;

    @Override
    protected SimpleDirectoryScanner createDirectoryScanner(String string, IDirectoryWatcher.WatcherAction watcherAction, IDirectoryWatcherListener iDirectoryWatcherListener, ISendNode iSendNode) {
        return new SimpleDirectoryScanner(string, iDirectoryWatcherListener, watcherAction, iSendNode, true);
    }

    @Override
    protected void notifyDirectoryScannerAdded(SimpleDirectoryScanner simpleDirectoryScanner) {
        if (this.thread == null) {
            this.thread = new CheckThread();
            this.thread.start();
            log.info("Directory watcher thread was started");
        }
    }

    @Override
    protected void notifyDirectoryScannerRemoved(SimpleDirectoryScanner simpleDirectoryScanner) {
        if (this.map.isEmpty()) {
            if (this.thread != null) {
                this.thread.cancel();
            }
            this.thread = null;
            log.info("Directory watcher thread was stopped");
        }
    }

    private class CheckThread
    extends Thread {
        private boolean isCanceling = false;

        public CheckThread() {
            this.setPriority(1);
            this.setDaemon(true);
            this.setName("DirectoryChecker");
        }

        public void cancel() {
            this.isCanceling = true;
        }

        @Override
        public void run() {
            block2: while (!this.isCanceling) {
                try {
                    Thread.sleep(3500L);
                }
                catch (InterruptedException interruptedException) {
                    if (this.isCanceling) break;
                }
                ArrayList arrayList = new ArrayList(SimpleDirectoryWatcher.this.map.values());
                for (SimpleDirectoryScanner simpleDirectoryScanner : arrayList) {
                    if (this.isCanceling) continue block2;
                    simpleDirectoryScanner.performCheck(3500L);
                }
            }
        }
    }
}

