/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dirwatcher;

import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.integration.ext.ICommandMessage;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcher;
import com.agfa.pacs.base.dirwatcher.IDirectoryWatcherListener;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.store.ISendNode;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.StoreProviderFactory;
import com.agfa.pacs.listtext.base.AddDataInfoToList;
import com.agfa.pacs.listtext.integration.dirwatcher.FileDataSource;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;

public abstract class AbstractDirectoryScanner {
    private static final ALogger log = ALogger.getLogger(AbstractDirectoryScanner.class);
    protected final File dir;
    private IDirectoryWatcherListener listener;
    private Map<String, IDataInfo> importedObjects = new Hashtable<String, IDataInfo>();
    private IDirectoryWatcher.WatcherAction action;
    private ISendNode sendNode;

    public AbstractDirectoryScanner(String string, IDirectoryWatcherListener iDirectoryWatcherListener, IDirectoryWatcher.WatcherAction watcherAction, ISendNode iSendNode) {
        this.dir = new File(string);
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            log.warn("couldnt create directory");
        }
        this.action = watcherAction;
        this.sendNode = iSendNode;
        this.listener = iDirectoryWatcherListener;
    }

    protected void handleNewFiles(List<File> list) {
        block6: {
            Object object2;
            ArrayList<IObjectInfo> arrayList;
            block7: {
                DicomInputStream dicomInputStream;
                arrayList = new ArrayList<IObjectInfo>();
                for (Object object2 : list) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream((File)object2);
                        dicomInputStream = new DicomInputStream((InputStream)new BufferedInputStream(fileInputStream, 65536));
                        Attributes attributes = dicomInputStream.readDataset(-1, 2145386512);
                        dicomInputStream.close();
                        fileInputStream.close();
                        boolean bl = this.listener.newFileFound(object2, attributes);
                        if (!bl) continue;
                        this.listener.performTagCoercion(attributes);
                        arrayList.addAll(this.performAction(this.action, (File)object2, attributes, this.sendNode));
                    }
                    catch (Exception exception) {
                        log.error("Error handling new file", (Throwable)exception);
                    }
                }
                if (arrayList.isEmpty()) break block6;
                if (this.action != IDirectoryWatcher.WatcherAction.Open) break block7;
                object2 = new AddDataInfoToList(arrayList, IDesktopIntegrationListener.AddOption.AddTo);
                IntegrationFrameworkFactory.getInstance().queueCommand((ICommandMessage)object2);
                for (IObjectInfo iObjectInfo : arrayList) {
                    dicomInputStream = UIDUtilities.getBaseType((String)iObjectInfo.getSOPClassUID());
                    if (dicomInputStream != UIDType.StructuredReport) continue;
                    StoreProviderFactory.getInstance().getStoreProvider().store(arrayList, this.sendNode, null);
                }
                break block6;
            }
            if (this.action != IDirectoryWatcher.WatcherAction.SaveOpen) break block6;
            object2 = new AddDataInfoToList(arrayList, IDesktopIntegrationListener.AddOption.AddTo);
            IntegrationFrameworkFactory.getInstance().queueCommand((ICommandMessage)object2);
            try {
                IObjectInfo iObjectInfo;
                iObjectInfo = StoreProviderFactory.getInstance().getStoreProvider().store(arrayList, this.sendNode, null);
                iObjectInfo.waitUntilFinished();
            }
            catch (Exception exception) {
                log.error("Storing error", (Throwable)exception);
            }
        }
    }

    private List<IObjectInfo> performAction(IDirectoryWatcher.WatcherAction watcherAction, File file, Attributes attributes, ISendNode iSendNode) {
        try {
            UIDType uIDType = UIDUtilities.getBaseType((String)attributes.getString(524310));
            if (uIDType != UIDType.Image) {
                watcherAction = IDirectoryWatcher.WatcherAction.Save;
            }
            switch (watcherAction) {
                case Save: {
                    IObjectInfo iObjectInfo = FileDataSource.getDataInfo(file, attributes, this.importedObjects, false);
                    List list = DataInfoUtilities.getLevel((IDataInfo)iObjectInfo, IObjectInfo.class);
                    IStoreHandler iStoreHandler = StoreProviderFactory.getInstance().getStoreProvider().store((Collection)list, iSendNode, null);
                    if (iStoreHandler == null) break;
                    iStoreHandler.waitUntilFinished();
                    if (!file.delete()) {
                        log.warn("problem deleting file");
                    }
                    return Collections.emptyList();
                }
                case Open: 
                case SaveOpen: {
                    File file2 = File.createTempFile("watch", "");
                    StreamUtil.copyFile((File)file, (File)file2);
                    if (!file.delete()) {
                        log.warn("problem deleting file");
                    }
                    file2.deleteOnExit();
                    IObjectInfo iObjectInfo = FileDataSource.getDataInfo(file2, attributes, this.importedObjects, watcherAction == IDirectoryWatcher.WatcherAction.Open);
                    List list = DataInfoUtilities.getLevel((IDataInfo)iObjectInfo, IObjectInfo.class);
                    return list;
                }
            }
        }
        catch (Exception exception) {
            log.error("Could not perform default action", (Throwable)exception);
        }
        return Collections.emptyList();
    }

    protected boolean isDicom(BufferedInputStream bufferedInputStream) throws Exception {
        bufferedInputStream.mark(0);
        byte[] byArray = new byte[132];
        if (bufferedInputStream.read(byArray) < 4) {
            return false;
        }
        if ("DICM".equals(new String(byArray, 0, 4))) {
            return true;
        }
        return "DICM".equals(new String(byArray, 128, 4));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Directory scanner on '");
        stringBuilder.append(this.dir.getAbsolutePath());
        stringBuilder.append("' performing ");
        stringBuilder.append(this.action);
        return stringBuilder.toString();
    }
}

