/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dicomsend.impl;

import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.store.ISendNode;
import java.text.Collator;

public class DicomSendNode
implements ISendNode {
    private String name;
    private String host;
    private String calledAET;
    private int port;
    private String commitAET = null;
    private Integer commitPort = null;
    private String callingAET;
    private boolean isSecure;
    private boolean closeImmediately;
    public boolean useCMove = false;
    private boolean allowDirectImport = true;

    public DicomSendNode(String string, IDicomNode iDicomNode) {
        this.name = string;
        this.host = iDicomNode.getHost();
        this.port = iDicomNode.getPort();
        this.calledAET = iDicomNode.getCalledAET();
        this.callingAET = iDicomNode.getCallingAET();
        this.isSecure = iDicomNode.isEnabled(NodeProperty.Secure);
    }

    public DicomSendNode(String string, String string2, String string3, String string4, int n, String string5, Integer n2, boolean bl, boolean bl2) {
        this.name = string;
        this.host = string2;
        this.calledAET = string3;
        this.port = n;
        this.commitAET = string5;
        if (string5 != null && string5.length() == 0) {
            this.commitAET = null;
        }
        this.commitPort = n2;
        this.callingAET = string4;
        this.isSecure = bl;
        this.closeImmediately = bl2;
        if (this.callingAET != null) {
            DicomDeviceConfigurationFactory.getConfiguration().registerAssociationAcceptorAE(string4);
        }
    }

    public DicomSendNode clone(String string) {
        DicomSendNode dicomSendNode = new DicomSendNode(string, this.host, this.calledAET, this.callingAET, this.port, this.commitAET, this.commitPort, this.isSecure, this.closeImmediately);
        dicomSendNode.setUseCMove(this.useCMove);
        dicomSendNode.allowDirectImport = this.allowDirectImport;
        return dicomSendNode;
    }

    public IDicomNode getCommitmentNode() {
        String string = this.commitAET == null ? this.calledAET : this.commitAET;
        int n = this.commitPort == null ? this.port : this.commitPort;
        return new SimpleDicomNode(this.host, n, string, null, this.isSecure, true);
    }

    public String toString() {
        return this.name;
    }

    public boolean IsDirectImportAllowed() {
        return this.allowDirectImport;
    }

    public void setAllowDirectImport(boolean bl) {
        this.allowDirectImport = bl;
    }

    public boolean useCMove() {
        return this.useCMove;
    }

    public void setUseCMove(boolean bl) {
        this.useCMove = bl;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public String getCallingAET() {
        return this.callingAET;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof ISendNode) {
            ISendNode iSendNode = (ISendNode)object;
            if (!this.name.equals(iSendNode.getName())) {
                return false;
            }
            if (!this.calledAET.equals(iSendNode.getCalledAET())) {
                return false;
            }
            if (this.port != iSendNode.getPort()) {
                return false;
            }
            return this.host.equals(iSendNode.getHost());
        }
        return false;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        n ^= this.calledAET.hashCode();
        n ^= this.host.hashCode();
        return n ^= this.port;
    }

    public int compareTo(ISendNode iSendNode) {
        return Collator.getInstance().compare(this.name, iSendNode.getName());
    }

    public boolean isEnabled(NodeProperty nodeProperty) {
        if (nodeProperty == NodeProperty.Secure) {
            return this.isSecure;
        }
        if (nodeProperty == NodeProperty.KeepAlive) {
            return !this.closeImmediately;
        }
        return false;
    }
}

