/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.base;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImpaxEEProxySelector
extends ProxySelector {
    private static final ALogger log = ALogger.getLogger(ImpaxEEProxySelector.class);
    private String proxyAddress;
    private int proxyPort;
    private List<Proxy> configuredProxy;
    private List<Proxy> noProxyList = Collections.singletonList(Proxy.NO_PROXY);
    private Set<String> relayHosts = new HashSet<String>(5);
    private Set<String> directConnectHosts = new HashSet<String>(5);
    private boolean useProxyForDefaultConnections = true;

    private ImpaxEEProxySelector() {
        this.readConfiguration();
        this.checkAndInstallCustomSelector();
    }

    public static ImpaxEEProxySelector getInstance() {
        return LazyHolder.instance;
    }

    public synchronized void addRelayAddress(String string) {
        try {
            this.relayHosts.add(new URI(string).getHost());
        }
        catch (URISyntaxException uRISyntaxException) {
            log.warn("Could not parse uri", (Throwable)uRISyntaxException);
        }
    }

    public synchronized void addRelayAddress(URL uRL) {
        this.relayHosts.add(uRL.getHost());
    }

    public synchronized void addDirectHostAddress(URL uRL) {
        this.directConnectHosts.add(uRL.getHost());
    }

    public synchronized void addDirectHostAddress(String string) {
        this.directConnectHosts.add(string);
    }

    private void checkAndInstallCustomSelector() {
        if (this.configuredProxy != null) {
            ProxySelector.setDefault(this);
        }
    }

    @Override
    public List<Proxy> select(URI uRI) {
        if (this.relayHosts.contains(uRI.getHost())) {
            log.trace("Using proxy for connection to {},", (Object)uRI);
            return this.configuredProxy;
        }
        if (this.directConnectHosts.contains(uRI.getHost())) {
            log.trace("Using no proxy for connection to {},", (Object)uRI);
            return this.noProxyList;
        }
        if (uRI.getPort() == -1 && this.useProxyForDefaultConnections) {
            return this.configuredProxy;
        }
        return this.noProxyList;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        log.error("Connection to proxy " + this.proxyAddress + ":" + this.proxyPort + " could not be established");
    }

    private void readConfiguration() {
        String string;
        String[] stringArray;
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        IConfigurationProvider iConfigurationProvider2 = iConfigurationProvider.getNode("listtext.proxy");
        this.useProxyForDefaultConnections = iConfigurationProvider2.getBoolean("useProxyForDefaultConnections");
        this.proxyAddress = iConfigurationProvider2.getString("proxy");
        this.proxyPort = iConfigurationProvider2.getType("proxy_port").equals("Long") ? (int)iConfigurationProvider2.getLong("proxy_port") : -1;
        String[] stringArray2 = stringArray = iConfigurationProvider2.getString("whitelist").split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray2[n2];
            if (!string.isEmpty()) {
                this.relayHosts.add(string);
            }
            ++n2;
        }
        string = iConfigurationProvider2.getString("proxy_user");
        String string2 = iConfigurationProvider2.getString("proxy_password");
        if (string.length() > 0 && string2.length() > 0) {
            System.setProperty("http.proxyUser", string);
            System.setProperty("http.proxyPassword", string2);
            System.setProperty("https.proxyUser", string);
            System.setProperty("https.proxyPassword", string2);
        }
        if (this.proxyAddress.length() > 0 && this.proxyPort >= 0) {
            try {
                this.configuredProxy = Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(InetAddress.getByName(this.proxyAddress), this.proxyPort)));
                log.info("Configured Internet proxy:" + this.proxyAddress + ":" + this.proxyPort);
            }
            catch (UnknownHostException unknownHostException) {
                log.error("Configured proxy address " + this.proxyAddress + " could not be resolved");
                this.configuredProxy = null;
            }
        } else {
            this.configuredProxy = null;
        }
    }

    /* synthetic */ ImpaxEEProxySelector(ImpaxEEProxySelector impaxEEProxySelector) {
        this();
    }

    private static class LazyHolder {
        private static final ImpaxEEProxySelector instance = new ImpaxEEProxySelector(null);

        private LazyHolder() {
        }
    }
}

