/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.ObjectID;
import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.ICommandMessage;
import com.agfa.integration.ext.IStatus;
import com.agfa.integration.impl.IntegrationFramework;
import com.agfa.integration.impl.Status;
import com.agfa.integration.messages.AddToList;
import com.agfa.integration.messages.ClearDisplay;
import com.agfa.integration.messages.ClearList;
import com.agfa.integration.messages.DictationChanged;
import com.agfa.integration.messages.EnablePart;
import com.agfa.integration.messages.FindStudy;
import com.agfa.integration.messages.Hide;
import com.agfa.integration.messages.PerformDictation;
import com.agfa.integration.messages.PerformLogin;
import com.agfa.integration.messages.PerformLogout;
import com.agfa.integration.messages.RemoveFromList;
import com.agfa.integration.messages.RequestFocus;
import com.agfa.integration.messages.Restore;
import com.agfa.integration.messages.SetStatus;
import com.agfa.integration.messages.SetWindowState;
import com.agfa.integration.messages.ShowMessage;
import com.agfa.integration.messages.ShowStudy;

public class ScriptProxy
implements IDesktopIntegrationListener {
    private IntegrationFramework framework;
    private String name = "SCRIPT";

    public ScriptProxy(IntegrationFramework integrationFramework) {
        this.framework = integrationFramework;
    }

    public String getName() {
        return this.name;
    }

    private void sendMethod(ICommandMessage iCommandMessage) {
        this.framework.queueMessage(iCommandMessage);
    }

    private IStatus.ErrorCode sendFunction(ICommandMessage iCommandMessage) {
        ExtendedFuture<IStatus> extendedFuture = this.framework.queueMessage(iCommandMessage);
        try {
            return ((IStatus)extendedFuture.get()).getErrorCode();
        }
        catch (Exception exception) {
            return IStatus.ErrorCode.UnspecifiedError;
        }
    }

    private String sendFunctionInfo(ICommandMessage iCommandMessage) {
        ExtendedFuture<IStatus> extendedFuture = this.framework.queueMessage(iCommandMessage);
        try {
            return ((IStatus)extendedFuture.get()).getAdditionalInformation();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IStatus sendFunctionStatus(ICommandMessage iCommandMessage) {
        ExtendedFuture<IStatus> extendedFuture = this.framework.queueMessage(iCommandMessage);
        try {
            return (IStatus)extendedFuture.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IStatus addToList(ObjectID objectID, String string, String string2) {
        return this.addToList(new ObjectID[]{objectID}, IDesktopIntegrationListener.AddOption.valueOf(string), false, string2);
    }

    @Override
    public IStatus addToList(ObjectID[] objectIDArray, IDesktopIntegrationListener.AddOption addOption, boolean bl, String string) {
        return this.sendFunctionStatus(new AddToList(objectIDArray, addOption, bl, string));
    }

    public IStatus.ErrorCode addToList(ObjectID[] objectIDArray, IDesktopIntegrationListener.AddOption addOption, boolean bl) {
        return this.sendFunction(new AddToList(objectIDArray, addOption, bl));
    }

    public IStatus.ErrorCode addToList(ObjectID[] objectIDArray, String string, boolean bl) {
        return this.sendFunction(new AddToList(objectIDArray, IDesktopIntegrationListener.AddOption.valueOf(string), bl));
    }

    public IStatus.ErrorCode addToList(ObjectID objectID, String string) {
        return this.sendFunction(new AddToList(objectID, IDesktopIntegrationListener.AddOption.valueOf(string)));
    }

    @Override
    public IStatus.ErrorCode clearDisplay() {
        return this.sendFunction(new ClearDisplay());
    }

    @Override
    public IStatus.ErrorCode clearList() {
        return this.sendFunction(new ClearList());
    }

    @Override
    public IStatus.ErrorCode enablePart(String string) {
        return this.sendFunction(new EnablePart(string));
    }

    public void exit() {
    }

    @Override
    public void hide() {
        this.sendMethod(new Hide());
    }

    @Override
    public void performLogin(String string, String string2) {
        this.sendMethod(new PerformLogin(string, string2));
    }

    @Override
    public void performLogout(boolean bl) {
        this.sendMethod(new PerformLogout(bl));
    }

    @Override
    public String findStudy(ObjectID objectID) {
        return this.sendFunctionInfo(new FindStudy(objectID));
    }

    public ObjectID createObject() {
        return new ObjectID();
    }

    public ObjectID createObjectForInstanceUID(String string) {
        return ObjectID.forSingleInstance(new String[]{string});
    }

    public ObjectID createObjectForStudyUID(String string) {
        return ObjectID.forStudyUID(string);
    }

    public ObjectID[] findStudyScript(ObjectID objectID) {
        String string = this.sendFunctionInfo(new FindStudy(objectID));
        return Status.parseStringResult(string);
    }

    @Override
    public IStatus.ErrorCode removeFromList(ObjectID[] objectIDArray) {
        return this.sendFunction(new RemoveFromList(objectIDArray));
    }

    @Override
    public void requestFocus() {
        this.sendMethod(new RequestFocus());
    }

    @Override
    public void restore() {
        this.sendMethod(new Restore());
    }

    @Override
    public IStatus.ErrorCode setStatus(ObjectID objectID, String string) {
        return this.sendFunction(new SetStatus(objectID, string));
    }

    @Override
    public void setWindowState(IDesktopIntegrationListener.WindowState windowState, Integer n) {
        this.sendMethod(new SetWindowState(windowState, n));
    }

    public Object showMessage(String string, String string2) {
        return this.showMessage(string, string2, null);
    }

    public Object showMessage(String string, String string2, String[] stringArray) {
        return this.showMessage(string, IDesktopIntegrationListener.MessageType.valueOf(string2), stringArray);
    }

    @Override
    public Object showMessage(String string, IDesktopIntegrationListener.MessageType messageType, String[] stringArray) {
        ExtendedFuture<IStatus> extendedFuture = this.framework.queueMessage(new ShowMessage(string, messageType, stringArray));
        try {
            if (messageType == IDesktopIntegrationListener.MessageType.Info || messageType == IDesktopIntegrationListener.MessageType.Error) {
                return ((IStatus)extendedFuture.get()).getErrorCode();
            }
            IStatus iStatus = (IStatus)extendedFuture.get();
            if (iStatus.getErrorCode() == IStatus.ErrorCode.OK) {
                return iStatus.getAdditionalInformation();
            }
            return IStatus.ErrorCode.Canceled;
        }
        catch (Exception exception) {
            return IStatus.ErrorCode.UnspecifiedError;
        }
    }

    @Override
    public IStatus.ErrorCode showStudy(ObjectID objectID, String string) {
        return this.sendFunction(new ShowStudy(objectID, string));
    }

    @Override
    public ObjectID[] getDisplayedStudies() {
        return this.framework.getDisplayedStudies();
    }

    @Override
    public ObjectID[] getSelectedStudies() {
        return this.framework.getSelectedStudies();
    }

    @Override
    public ObjectID[] getStudiesInList() {
        return this.framework.getStudiesInList();
    }

    public boolean isHidden() {
        return this.framework.isHidden();
    }

    public boolean isLoggedIn() {
        return this.framework.isLoggedIn();
    }

    @Override
    public void dictationChanged(ObjectID objectID, IDesktopIntegrationListener.DictationState dictationState) {
        this.sendMethod(new DictationChanged(objectID, dictationState));
    }

    @Override
    public IStatus.ErrorCode performDictation(ObjectID objectID, String string) {
        return this.sendFunction(new PerformDictation(objectID, string));
    }
}

