/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.menu.ICheckBoxMenuItem;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.menu.IMenuEntryGroup;
import com.agfa.pacs.impaxee.menu.IMenuItem;
import com.agfa.pacs.impaxee.menu.IMenuSeparator;
import com.agfa.pacs.impaxee.menu.IStandardMenuItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class LegacyMenuConverter {
    public static List<PAction> generateActions(List<IMenuEntry> list) {
        ArrayList<PAction> arrayList = new ArrayList<PAction>(list.size());
        for (IMenuEntry iMenuEntry : list) {
            if (iMenuEntry instanceof IMenuSeparator) {
                arrayList.add(new SeparatorPAction());
                continue;
            }
            if (iMenuEntry instanceof IMenuEntryGroup) {
                List<IMenuEntry> list2 = ((IMenuEntryGroup)iMenuEntry).getMenuEntries();
                if (list2 == null || list2.size() <= 0) continue;
                arrayList.add(new GroupLegacyPAction((IMenuEntryGroup)iMenuEntry));
                continue;
            }
            if (iMenuEntry instanceof IStandardMenuItem) {
                arrayList.add(new StandardLegacyPAction((IStandardMenuItem)iMenuEntry));
                continue;
            }
            if (!(iMenuEntry instanceof ICheckBoxMenuItem)) continue;
            arrayList.add(new CheckboxLegacyPAction((ICheckBoxMenuItem)iMenuEntry));
        }
        return arrayList;
    }

    private static abstract class AbstractLegacyPAction<U extends IMenuItem>
    extends AnonymousPAction {
        protected U entry;

        public AbstractLegacyPAction(U u) {
            this.entry = u;
        }

        @Override
        public String getCaption() {
            return this.entry.getDisplayName()[0];
        }

        @Override
        protected boolean isEnabledImpl() {
            return this.entry.isEnabled();
        }
    }

    private static class CheckboxLegacyPAction
    extends AbstractLegacyPAction<ICheckBoxMenuItem> {
        public CheckboxLegacyPAction(ICheckBoxMenuItem iCheckBoxMenuItem) {
            super(iCheckBoxMenuItem);
        }

        @Override
        public boolean perform(Component component) {
            ((ICheckBoxMenuItem)this.entry).menuItemSelected(!((ICheckBoxMenuItem)this.entry).isChecked());
            return true;
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public boolean isSelected() {
            return ((ICheckBoxMenuItem)this.entry).isChecked();
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }
    }

    private static class GroupLegacyPAction
    extends AbstractLegacyPAction<IMenuEntryGroup> {
        private PAction[] subActions = null;

        public GroupLegacyPAction(IMenuEntryGroup iMenuEntryGroup) {
            super(iMenuEntryGroup);
        }

        @Override
        public PAction.ActionType getActionType() {
            return PAction.ActionType.Submenu;
        }

        @Override
        public PAction[] getSubactions() {
            if (this.subActions == null) {
                this.subActions = LegacyMenuConverter.generateActions(((IMenuEntryGroup)this.entry).getMenuEntries()).toArray(new PAction[0]);
            }
            return this.subActions;
        }

        @Override
        public boolean perform(Component component) {
            throw new UnsupportedOperationException();
        }
    }

    private static class StandardLegacyPAction
    extends AbstractLegacyPAction<IStandardMenuItem> {
        public StandardLegacyPAction(IStandardMenuItem iStandardMenuItem) {
            super(iStandardMenuItem);
        }

        @Override
        public boolean perform(Component component) {
            ((IStandardMenuItem)this.entry).menuItemSelected();
            return true;
        }
    }
}

