/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.tiani.jvision.util.StorageLicense;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.menu.XDSFlagGroupAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class FlaggingActionProvider
implements PActionProvider {
    private static final String SINGLE_IMAGE_PREFIX = "FLAG_IMAGE_";
    private static final String FLAG_PREFIX = "FLAG_";

    public static String getIDForImageFlagging(KeyImageType keyImageType) {
        return SINGLE_IMAGE_PREFIX + keyImageType.name();
    }

    public static String getIDForFlagging(KeyImageType keyImageType, Type type) {
        return FLAG_PREFIX + (Object)((Object)keyImageType) + "_" + type.name();
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        KeyImageType[] keyImageTypeArray = KeyImageType.values();
        int n = keyImageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyImageType keyImageType = keyImageTypeArray[n2];
            arrayList.add(new SelectableFlaggingAction(keyImageType));
            arrayList.add(new FlaggingAction(keyImageType, Type.Mark_Selected));
            arrayList.add(new FlaggingAction(keyImageType, Type.Unmark_Selected));
            arrayList.add(new FlaggingAction(keyImageType, Type.Mark_All));
            arrayList.add(new FlaggingAction(keyImageType, Type.Unmark_All));
            ++n2;
        }
        return arrayList;
    }

    private static class FlaggingAction
    extends AbstractPAction {
        private KeyImageType code;
        private Type type;

        public FlaggingAction(KeyImageType keyImageType, Type type) {
            this.code = keyImageType;
            this.type = type;
        }

        @Override
        public String getCaption() {
            String string = this.type.isMark() ? Messages.getString("ImagesFlagsHandler.Set") : Messages.getString("ImagesFlagsHandler.Clear");
            string = String.valueOf(string) + " " + (this.type.onlySelected() ? PDataScope.SelectedImages.getName() : PDataScope.CurrentDisplay.getName());
            return string;
        }

        @Override
        public String getName() {
            if (this.type.isMark()) {
                if (this.type.onlySelected()) {
                    return Messages.getString("ImagesFlagsHandler.Set." + this.code.name() + "." + (Object)((Object)PDataScope.SelectedImages) + ".Name");
                }
                return Messages.getString("ImagesFlagsHandler.Set." + this.code.name() + "." + (Object)((Object)PDataScope.CurrentDisplay) + ".Name");
            }
            if (this.type.onlySelected()) {
                return Messages.getString("ImagesFlagsHandler.Clear." + this.code.name() + "." + (Object)((Object)PDataScope.SelectedImages) + ".Name");
            }
            return Messages.getString("ImagesFlagsHandler.Clear." + this.code.name() + "." + (Object)((Object)PDataScope.CurrentDisplay) + ".Name");
        }

        @Override
        public String getGroupName() {
            return WORKFLOW_HANDLING_GROUP;
        }

        @Override
        public boolean isAvailable() {
            return StorageLicense.canStoreKO();
        }

        @Override
        protected boolean isEnabledImpl() {
            if (this.code == KeyImageType.ForXDS && !XDSFlagGroupAction.flagForXDSAvailableForCurrentImage()) {
                return false;
            }
            List<VisData> list = AbstractPDataAction.getVisDatas(this.type.onlySelected() ? PDataScope.SelectedImages : PDataScope.CurrentDisplay);
            if (list.get(0).getSequenceData().isLoadedFromThinSliceArchive()) {
                return false;
            }
            for (VisData visData : list) {
                if (!(this.type.mark ? !KeyImageManager.getInstance().isMarked(visData.getFrameData(), this.code) : KeyImageManager.getInstance().isMarked(visData.getFrameData(), this.code) && KeyImageManager.getInstance().isModifiable(visData.getFrameData(), this.code))) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getID() {
            return FlaggingActionProvider.getIDForFlagging(this.code, this.type);
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisData> list = AbstractPDataAction.getVisDatas(this.type.onlySelected() ? PDataScope.SelectedImages : PDataScope.CurrentDisplay);
            for (VisData visData : list) {
                if (this.type.mark) {
                    visData.markAsKeyImage(this.code);
                    continue;
                }
                visData.unmarkAsKeyImage(this.code);
            }
            if (list.size() > 0) {
                list.get(0).getParent().getVisDisplay().repaint();
            }
            return true;
        }
    }

    private static class SelectableFlaggingAction
    extends SelectablePAction {
        private KeyImageType type;

        public SelectableFlaggingAction(KeyImageType keyImageType) {
            this.type = keyImageType;
        }

        @Override
        public boolean isAvailable() {
            return StorageLicense.canStoreKO();
        }

        @Override
        protected boolean isEnabledImpl() {
            if (this.type == KeyImageType.ForXDS && !XDSFlagGroupAction.flagForXDSAvailableForCurrentImage()) {
                return false;
            }
            VisData visData = AbstractPDataAction.getCurrentImage();
            if (visData.getSequenceData().isLoadedFromThinSliceArchive()) {
                return false;
            }
            return KeyImageManager.getInstance().isModifiable(visData.getFrameData(), this.type);
        }

        @Override
        public boolean isSelected() {
            VisData visData = AbstractPDataAction.getCurrentImage();
            if (visData == null) {
                return false;
            }
            return visData.isMarkedAsKeyImage(this.type);
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getCaption() {
            return Messages.getString("VisPopup.Image");
        }

        @Override
        public String getName() {
            if (KeyImageType.ForConference.equals((Object)this.type)) {
                return Messages.getString("ImagesFlagsHandler.ForConference.Image.Name");
            }
            if (KeyImageType.ForPrinting.equals((Object)this.type)) {
                return Messages.getString("ImagesFlagsHandler.ForPrinting.Image.Name");
            }
            if (KeyImageType.OfInterest.equals((Object)this.type)) {
                return Messages.getString("ImagesFlagsHandler.OfInterest.Image.Name");
            }
            if (KeyImageType.ForXDS.equals((Object)this.type)) {
                return Messages.getString("ImagesFlagsHandler.ForXDS.Image.Name");
            }
            return null;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (KeyImageType.OfInterest.equals((Object)this.type)) {
                return new KeyShortcut(68);
            }
            if (KeyImageType.ForPrinting.equals((Object)this.type)) {
                return new KeyShortcut(80);
            }
            if (KeyImageType.ForConference.equals((Object)this.type)) {
                return new KeyShortcut(77);
            }
            return null;
        }

        @Override
        public String getGroupName() {
            return WORKFLOW_HANDLING_GROUP;
        }

        @Override
        public String getID() {
            return FlaggingActionProvider.getIDForImageFlagging(this.type);
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisData visData = AbstractPDataAction.getCurrentImage();
            if (visData.isMarkedAsKeyImage(this.type)) {
                visData.unmarkAsKeyImage(this.type);
            } else {
                visData.markAsKeyImage(this.type);
            }
            visData.getVisual().repaint();
            return true;
        }
    }

    public static enum Type {
        Mark_Selected(true, true),
        Unmark_Selected(false, true),
        Mark_All(true, false),
        Unmark_All(false, false);

        private boolean mark;
        private boolean selectedOnly;

        private Type(boolean bl, boolean bl2) {
            this.mark = bl;
            this.selectedOnly = bl2;
        }

        public boolean isMark() {
            return this.mark;
        }

        public boolean onlySelected() {
            return this.selectedOnly;
        }
    }
}

