/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.menu;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.data.fetcher.IPerform;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.sessions.gui.WorklistChooser;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddToWorklistActionProvider
implements PActionProvider {
    private static final String ID_PREFIX = "ADD_WORKLIST_";
    public static final String ADD_TO_LAST = "ADD_TO_LAST_USED_WORKLIST";
    public static final String WORKLIST_GROUP = PAction.WORKFLOW_HANDLING_GROUP;
    public static final String WORKLIST_GROUP_ID = "Einer Arbeitsliste hinzuf\u00fcgen";
    private static ALogger log = ALogger.getLogger(AddToWorklistActionProvider.class);
    private Collection<IWorklistContext> lastWorklistCtxs = null;

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            arrayList.add(new AddToWorklistAction(type));
            ++n2;
        }
        arrayList.add(new AddToWorklistGroupAction(arrayList));
        arrayList.add(new AddStudyToLastUsedWorklistAction());
        return arrayList;
    }

    private boolean isAvailableImpl() {
        IDataAction iDataAction = DataActionFactory.getInstance().getActionForCode("ADD_TO_WORKLIST");
        if (iDataAction == null) {
            return false;
        }
        return iDataAction.isAllowed();
    }

    private Collection<? extends IDataObject> findDataObjects(Type type) {
        VisData visData = VisData.getLastModified();
        ArrayList<IDataObject> arrayList = new ArrayList<IDataObject>();
        if (Type.ADD_STUDY.equals((Object)type)) {
            arrayList.add(visData.getFrameData().getParent().getParent());
        } else if (Type.ADD_SEQUENCE.equals((Object)type)) {
            arrayList.add(visData.getFrameData().getParent());
        } else if (Type.ADD_SEQUENCE_SELECTED_IMAGES.equals((Object)type)) {
            List<VisData> list = AbstractPDataAction.getVisDatas(PDataScope.SelectedImages);
            if (list != null) {
                for (VisData visData2 : list) {
                    arrayList.add(visData2.getFrameData());
                }
            }
        } else if (Type.ADD_IMAGE.equals((Object)type)) {
            arrayList.add(visData.getView().getFrameData());
        } else if (Type.ADD_ALL_FLAGGED_IMAGES.equals((Object)type)) {
            this.addSelectedOrFlagged(arrayList, visData, type);
        }
        return arrayList;
    }

    private void addSelectedOrFlagged(Collection<IDataObject> collection, VisData visData, Type type) {
        String string = visData.getFrameData().getParent().getParent().getStudyInstanceUID();
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            List<VisData> list = null;
            if (Type.ADD_ALL_FLAGGED_IMAGES.equals((Object)type)) {
                list = visDisplay2.getVis();
            }
            if (list == null) continue;
            for (VisData visData2 : list) {
                if (!string.equals(visData2.getStudyData().getStudyInstanceUID())) continue;
                IFrameObjectData iFrameObjectData = visData2.getFrameData();
                if (Type.ADD_ALL_FLAGGED_IMAGES.equals((Object)type) && !KeyImageManager.getInstance().isMarked(iFrameObjectData, KeyImageType.ForConference)) continue;
                collection.add(iFrameObjectData);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean performImpl(Type type, Collection<IWorklistContext> collection) {
        Object object;
        Collection<IWorklistContext> collection2;
        IStore iStore = DataManager.getInstance().getDataStore();
        String string = "OK_OPTION";
        if (collection != null && collection.isEmpty()) {
            collection = null;
        }
        if (collection == null) {
            collection2 = new ArrayList<IWorklistContext>(iStore.getAvailableWorklistContexts());
            object = new WorklistChooser(JVision2.getMainFrame(), (List<IWorklistContext>)collection2, null);
            string = ((WorklistChooser)((Object)object)).getDialogResult();
            collection = ((WorklistChooser)((Object)object)).getSelectedWorklistContexts();
        }
        if ("OK_OPTION" != string) return true;
        collection2 = collection;
        this.lastWorklistCtxs = collection2;
        object = DataManager.getInstance().getDataPerform("ADD_TO_WORKLIST");
        if (object == null) {
            log.warn("Performing action ADD_TO_WORKLIST failed: No IPerform implementation found!");
            return false;
        }
        Collection<? extends IDataObject> collection3 = this.findDataObjects(type);
        if (collection3 != null && !collection3.isEmpty()) {
            EventUtil.invokeNotOnEDT((Runnable)new Runnable((IPerform)object, collection2, collection3){
                private final /* synthetic */ IPerform val$perform;
                private final /* synthetic */ Collection val$selWrkCtxs;
                private final /* synthetic */ Collection val$dataObjects;
                {
                    this.val$perform = iPerform;
                    this.val$selWrkCtxs = collection;
                    this.val$dataObjects = collection2;
                }

                @Override
                public void run() {
                    this.val$perform.perform(new IPerform.DefaultPerformContext(JVision2.getMainFrame(), this.val$selWrkCtxs), this.val$dataObjects);
                }
            });
            return true;
        }
        log.warn("Perform action ADD_TO_WORKLIST failed: No data-objects found!");
        return false;
    }

    private class AddStudyToLastUsedWorklistAction
    extends AbstractPAction {
        private AddStudyToLastUsedWorklistAction() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_ADD_TO_LAST_USED_WORKLIST");
        }

        @Override
        public String getName() {
            return Messages.getString("ACTION_ADD_TO_LAST_USED_WORKLIST_NAME");
        }

        @Override
        public String getGroupName() {
            return WORKLIST_GROUP;
        }

        @Override
        public String getID() {
            return AddToWorklistActionProvider.ADD_TO_LAST;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(65, 8);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_ADD_TO_LAST_USED_WORKLIST_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            return AddToWorklistActionProvider.this.performImpl(Type.ADD_STUDY, AddToWorklistActionProvider.this.lastWorklistCtxs);
        }
    }

    private class AddToWorklistAction
    extends AbstractPAction {
        private Type type;

        public AddToWorklistAction(Type type) {
            this.type = type;
        }

        @Override
        public boolean isAvailable() {
            return AddToWorklistActionProvider.this.isAvailableImpl();
        }

        @Override
        protected boolean isEnabledImpl() {
            if (Type.ADD_ALL_FLAGGED_IMAGES.equals((Object)this.type)) {
                IStudyData iStudyData = VisData.getLastModified().getFrameData().getParent().getParent();
                KeyImageType[] keyImageTypeArray = KeyImageManager.getInstance().getModifiedTypesOfStudy(iStudyData);
                return keyImageTypeArray != null && keyImageTypeArray.length > 0;
            }
            return true;
        }

        @Override
        public String getCaption() {
            if (Type.ADD_SEQUENCE_SELECTED_IMAGES == this.type) {
                return Messages.getString("ACTION_ADD_SEQUENCE_SELECTED_IMAGES_TO_WORKLIST");
            }
            if (Type.ADD_ALL_FLAGGED_IMAGES == this.type) {
                return Messages.getString("ACTION_ADD_FLAGGED_IMAGES_TO_WORKLIST");
            }
            if (Type.ADD_STUDY == this.type) {
                return Messages.getString("ACTION_ADD_TO_WORKLIST");
            }
            if (Type.ADD_SEQUENCE == this.type) {
                return Messages.getString("ACTION_ADD_SERIES_TO_WORKLIST");
            }
            if (Type.ADD_IMAGE == this.type) {
                return Messages.getString("ACTION_ADD_IMAGE_TO_WORKLIST");
            }
            return "";
        }

        @Override
        public String getName() {
            if (Type.ADD_SEQUENCE_SELECTED_IMAGES == this.type) {
                return Messages.getString("ACTION_ADD_SEQUENCE_SELECTED_IMAGES_TO_WORKLIST_NAME");
            }
            if (Type.ADD_ALL_FLAGGED_IMAGES == this.type) {
                return Messages.getString("ACTION_ADD_FLAGGED_IMAGES_TO_WORKLIST_NAME");
            }
            if (Type.ADD_STUDY == this.type) {
                return Messages.getString("ACTION_ADD_TO_WORKLIST_NAME");
            }
            if (Type.ADD_SEQUENCE == this.type) {
                return Messages.getString("ACTION_ADD_SERIES_TO_WORKLIST_NAME");
            }
            if (Type.ADD_IMAGE == this.type) {
                return Messages.getString("ACTION_ADD_IMAGE_TO_WORKLIST_NAME");
            }
            return "";
        }

        @Override
        public String getGroupName() {
            return WORKLIST_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (this.type == Type.ADD_STUDY) {
                return new KeyShortcut(65);
            }
            return null;
        }

        @Override
        public String getID() {
            return AddToWorklistActionProvider.ID_PREFIX + this.type.name();
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            return AddToWorklistActionProvider.this.performImpl(this.type, null);
        }
    }

    private static class AddToWorklistGroupAction
    extends CompoundAbstractPAction {
        public AddToWorklistGroupAction(List<PAction> list) {
            this.init(list);
        }

        @Override
        public boolean isUpdatingListeners() {
            return false;
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTIONGROUP_WORKLIST");
        }

        @Override
        public String getName() {
            return Messages.getString("ACTIONGROUP_WORKLIST");
        }

        @Override
        public String getGroupName() {
            return WORKLIST_GROUP;
        }

        @Override
        public String getID() {
            return AddToWorklistActionProvider.WORKLIST_GROUP_ID;
        }
    }

    public static enum Type {
        ADD_STUDY,
        ADD_SEQUENCE,
        ADD_SEQUENCE_SELECTED_IMAGES,
        ADD_IMAGE,
        ADD_ALL_FLAGGED_IMAGES;

    }
}

