/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.layout;

import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.Pattern;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.StateLyt;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Pair;

public class StateLytScreen
extends StateLyt
implements IStateLytScreen {
    private static final ALogger LOGGER = ALogger.getLogger(StateLytScreen.class);
    private final Map<Point, Dimension> mergedCells;

    public StateLytScreen(IStateLytScreen iStateLytScreen) {
        this(iStateLytScreen.getCols(), iStateLytScreen.getRows(), iStateLytScreen.getMergedCells());
    }

    public StateLytScreen(int n, int n2) {
        this(n, n2, null);
    }

    public StateLytScreen(int n, int n2, Map<Point, Dimension> map) {
        super(n, n2);
        this.mergedCells = map;
    }

    @Override
    public Map<Point, Dimension> getMergedCells() {
        return this.mergedCells;
    }

    public String getType() {
        return StateLytScreen.getType(this);
    }

    public static int getRequiredDisplayCount(MainLayoutType mainLayoutType, String string) {
        return StateLytScreen.getRequiredDisplayCount(StateLytScreen.parse(mainLayoutType, string, null));
    }

    public static int getRequiredDisplayCount(IStateLytScreen iStateLytScreen) {
        if (iStateLytScreen == null) {
            return 0;
        }
        int n = iStateLytScreen.getCols() * iStateLytScreen.getRows();
        Map<Point, Dimension> map = iStateLytScreen.getMergedCells();
        if (map != null) {
            for (Dimension dimension : map.values()) {
                n -= dimension.width * dimension.height - 1;
            }
        }
        return n;
    }

    public static IStateLytScreen parse(MainLayoutType mainLayoutType, String string, String string2) {
        StateLytScreen stateLytScreen;
        String[] stringArray = Pattern.UNDERSCORE.split(string);
        Dimension dimension = ImpaxEEUtils.horizontalXVertical2Dimension(stringArray[0]);
        if (dimension != null) {
            HashMap<Point, Dimension> hashMap = null;
            if (mainLayoutType != MainLayoutType.variable && string2 != null) {
                Dimension dimension2 = ImpaxEEUtils.horizontalXVertical2Dimension(string2);
                if (dimension2 != null) {
                    dimension.width = Math.max(dimension.width, dimension2.width);
                    dimension.height = Math.max(dimension.height, dimension2.height);
                }
            } else if (mainLayoutType == MainLayoutType.variable && stringArray.length > 1) {
                hashMap = new HashMap<Point, Dimension>();
                String[] stringArray2 = Pattern.PIPE.split(stringArray[1]);
                int n = stringArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3 = stringArray2[n2];
                    Pair<Point, Dimension> pair = StateLytScreen.parseMergedCellInfo(string3);
                    if (pair != null) {
                        hashMap.put((Point)pair.left, (Dimension)pair.right);
                    }
                    ++n2;
                }
            }
            stateLytScreen = new StateLytScreen(dimension.width, dimension.height, hashMap);
        } else {
            stateLytScreen = null;
        }
        if (stateLytScreen == null) {
            LOGGER.warn("Unsupported {} screen layout type: {}", (Object)mainLayoutType, (Object)string);
        }
        return stateLytScreen;
    }

    private static Pair<Point, Dimension> parseMergedCellInfo(String string) {
        String[] stringArray = Pattern.SEMI_COLON.split(string);
        if (stringArray.length != 4) {
            LOGGER.warn("Unsupported cell merge information: {}", (Object)string);
            return null;
        }
        Point point = new Point();
        try {
            point.x = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            LOGGER.warn(String.valueOf(stringArray[0]) + " is not a valid cell column number");
            return null;
        }
        try {
            point.y = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            LOGGER.warn(String.valueOf(stringArray[1]) + " is not a valid cell row number");
            return null;
        }
        Dimension dimension = new Dimension();
        try {
            dimension.width = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            LOGGER.warn(String.valueOf(stringArray[2]) + " is not a valid cell width");
            return null;
        }
        try {
            dimension.height = Integer.parseInt(stringArray[3]);
        }
        catch (Exception exception) {
            LOGGER.warn(String.valueOf(stringArray[3]) + " is not a valid cell height");
            return null;
        }
        return Pair.of((Object)point, (Object)dimension);
    }

    static boolean isEquivalent(IStateLytScreen iStateLytScreen, IStateLytScreen iStateLytScreen2) {
        return iStateLytScreen.getCols() == iStateLytScreen2.getCols() && iStateLytScreen.getRows() == iStateLytScreen2.getRows() && CompareUtils.equals(iStateLytScreen.getMergedCells(), iStateLytScreen2.getMergedCells());
    }

    static boolean hasMergedCells(IStateLytScreen iStateLytScreen) {
        Map<Point, Dimension> map = iStateLytScreen.getMergedCells();
        return map != null && !map.isEmpty();
    }

    public static String getType(IStateLytScreen iStateLytScreen) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iStateLytScreen.getCols());
        stringBuilder.append('x');
        stringBuilder.append(iStateLytScreen.getRows());
        if (StateLytScreen.hasMergedCells(iStateLytScreen)) {
            stringBuilder.append('_');
            boolean bl = false;
            for (Map.Entry<Point, Dimension> entry : iStateLytScreen.getMergedCells().entrySet()) {
                if (bl) {
                    stringBuilder.append('|');
                }
                Point point = entry.getKey();
                Dimension dimension = entry.getValue();
                stringBuilder.append(point.x);
                stringBuilder.append(';');
                stringBuilder.append(point.y);
                stringBuilder.append(';');
                stringBuilder.append(dimension.width);
                stringBuilder.append(';');
                stringBuilder.append(dimension.height);
                bl = true;
            }
        }
        return stringBuilder.toString();
    }
}

