/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.layout;

import com.agfa.pacs.impaxee.hanging.model.enums.VariableLayout;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolBar;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayScrollBar;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.Lyt;
import com.tiani.jvision.vis.layout.StateLytScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public abstract class LytScreen
extends Lyt<StateLytScreen>
implements IStateLytScreen {
    private Map<Point, Dimension> mergedCells;

    public boolean isEquivalent(int n, int n2, Map<Point, Dimension> map) {
        return this.isEquivalent(new StateLytScreen(n, n2, map));
    }

    public boolean isEquivalent(IStateLytScreen iStateLytScreen) {
        return StateLytScreen.isEquivalent(this, iStateLytScreen);
    }

    public String getType() {
        return StateLytScreen.getType(this);
    }

    public String getDescription() {
        VariableLayout[] variableLayoutArray = VariableLayout.values();
        int n = variableLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLayout variableLayout = variableLayoutArray[n2];
            if (this.isEquivalent(variableLayout)) {
                return variableLayout.getDescription();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Map<Point, Dimension> getMergedCells() {
        if (this.mergedCells == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.mergedCells);
    }

    public void setMergedCells(Map<Point, Dimension> map) {
        this.mergedCells = map;
    }

    public boolean hasMergedCells() {
        return this.mergedCells != null && !this.mergedCells.isEmpty();
    }

    public int getDisplayCount(Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof VisDisplay2) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public VisDisplay2[] getDisplays(Container container) {
        Component[] componentArray = container.getComponents();
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>(componentArray.length);
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof VisDisplay2) {
                arrayList.add((VisDisplay2)componentArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new VisDisplay2[arrayList.size()]);
    }

    public boolean allowsOneMoreDisplay(Container container) {
        if (container == null) {
            return false;
        }
        return this.getDisplayCount(container) < this.getRequiredDisplayCount();
    }

    public int getMissingDisplayCount(Container container) {
        if (container == null) {
            return 0;
        }
        return this.getRequiredDisplayCount() - this.getDisplayCount(container);
    }

    protected int getRequiredDisplayCount() {
        return StateLytScreen.getRequiredDisplayCount(this);
    }

    public int getRowOfDisplay(VisDisplay2 visDisplay2) {
        VisDisplay2[] visDisplay2Array = this.getDisplays(visDisplay2.getScreen());
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n < visDisplay2Array.length && n3 < this.cols) {
                if (visDisplay2Array[n] == visDisplay2) {
                    return n2;
                }
                ++n3;
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    public int getColumnOfDisplay(VisDisplay2 visDisplay2) {
        VisDisplay2[] visDisplay2Array = this.getDisplays(visDisplay2.getScreen());
        int n = 0;
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n < visDisplay2Array.length && n3 < this.cols) {
                if (visDisplay2Array[n] == visDisplay2) {
                    return n3;
                }
                ++n3;
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    protected boolean canToolbarBeHidden() {
        return VisDisplayToolBar.isHideToolbar();
    }

    protected int getToolbarAlignment() {
        return VisDisplayToolBar.getConfiguredAlignment();
    }

    protected int getVerticalToolbarWidth(int n, Container container) {
        if (n == 0 || n == 1) {
            return this.getVisDisplayToolbarThickness(container);
        }
        return 0;
    }

    protected int getHorizontalToolbarHeight(int n, Container container) {
        if (n == 2 || n == 3) {
            return this.getVisDisplayToolbarThickness(container);
        }
        return 0;
    }

    protected boolean canScrollbarBeHidden() {
        return VisDisplayScrollBar.isHideScrollbar();
    }

    protected int getScrollbarAlignment() {
        return VisDisplayScrollBar.getConfiguredAlignment();
    }

    protected int getVerticalScrollbarWidth(int n) {
        if (n == 0 || n == 1) {
            return 18;
        }
        return 0;
    }

    protected int getHorizontalScrollbarHeight(int n) {
        if (n == 2 || n == 3) {
            return 18;
        }
        return 0;
    }

    protected void setScrollbarOrientation(VisDisplay2 visDisplay2, int n) {
        if (n != -1) {
            visDisplay2.getScrollBar().setOrientation(n == 0 || n == 1 ? 1 : 0);
        }
    }

    void tileLayout(Container container) {
        if (container == null) {
            return;
        }
        VisDisplay2[] visDisplay2Array = this.getDisplays(container);
        if (visDisplay2Array.length == 0) {
            return;
        }
        int n = container.getBounds().width;
        int n2 = container.getBounds().height;
        int n3 = this.getToolbarAlignment();
        int n4 = this.getScrollbarAlignment();
        n4 = VisDisplayScrollBar.adjustScrollBarAlignment(n4, n3);
        int n5 = this.canScrollbarBeHidden() ? 0 : this.getVerticalScrollbarWidth(n4);
        int n6 = this.canScrollbarBeHidden() ? 0 : this.getHorizontalScrollbarHeight(n4);
        int n7 = this.canToolbarBeHidden() ? 0 : this.getVerticalToolbarWidth(n3, container);
        int n8 = this.canToolbarBeHidden() ? 0 : this.getHorizontalToolbarHeight(n3, container);
        int n9 = 0;
        int n10 = 0;
        int n11 = n9 / 2;
        int n12 = n10 / 2;
        int n13 = n - n5 * this.cols - n7 * this.cols - n9;
        int n14 = n2 - n6 * this.rows - n8 * this.rows - n10;
        int n15 = n13 / this.cols;
        int n16 = n14 / this.rows;
        int n17 = 0;
        int n18 = n15 + n5 + n7;
        HashSet<Point> hashSet = new HashSet<Point>();
        int n19 = 0;
        while (n19 < this.rows) {
            int n20 = n11;
            int n21 = 0;
            while (n17 < visDisplay2Array.length && n21 < this.cols) {
                int n22 = n12;
                Point point = new Point(n21, n19);
                if (hashSet.contains(point)) {
                    n20 = n11 + (n21 + 1) * n18;
                } else {
                    int n23;
                    int n24 = n15;
                    int n25 = n16;
                    Dimension dimension = this.getDisplayExtent(point);
                    if (dimension != null && (dimension.width != 1 || dimension.height != 1)) {
                        int n26 = n21;
                        while (n26 < n21 + dimension.width) {
                            int n27 = n19;
                            while (n27 < n19 + dimension.height) {
                                hashSet.add(new Point(n26, n27));
                                ++n27;
                            }
                            ++n26;
                        }
                        n24 *= dimension.width;
                        n24 += (dimension.width - 1) * (n5 + n7);
                        n25 *= dimension.height;
                        n25 += (dimension.height - 1) * (n6 + n8);
                    }
                    VisDisplay2 visDisplay2 = visDisplay2Array[n17];
                    ++n17;
                    VisDisplayToolBar visDisplayToolBar = visDisplay2.getToolBar();
                    int n28 = this.canToolbarBeHidden() && visDisplayToolBar.isHidden() ? 0 : this.getVerticalToolbarWidth(n3, container);
                    int n29 = this.canToolbarBeHidden() && visDisplayToolBar.isHidden() ? 0 : this.getHorizontalToolbarHeight(n3, container);
                    switch (n3) {
                        case 0: {
                            visDisplayToolBar.setBounds(n20, n12, n28, n25 + n6);
                            n20 += n7;
                            break;
                        }
                        case 2: {
                            visDisplayToolBar.setBounds(n20, n12, n24 + n5, n29);
                            n22 += n8;
                            break;
                        }
                        case 1: {
                            int n30 = n20 + n24 + (!this.canScrollbarBeHidden() ? n5 : 0) - (this.canToolbarBeHidden() ? n28 : 0);
                            visDisplayToolBar.setBounds(n30, n12, n28, n25 + n6);
                            break;
                        }
                        case 3: {
                            n23 = n12 + n25 + (!this.canScrollbarBeHidden() ? n6 : 0) - (this.canToolbarBeHidden() ? n29 : 0);
                            visDisplayToolBar.setBounds(n20, n23, n24 + n5, n29);
                        }
                    }
                    this.setScrollbarOrientation(visDisplay2, n4);
                    VisDisplayScrollBar visDisplayScrollBar = visDisplay2.getScrollBar();
                    n23 = this.canScrollbarBeHidden() && !visDisplayScrollBar.isVisible() ? 0 : this.getVerticalScrollbarWidth(n4);
                    int n31 = this.canScrollbarBeHidden() && !visDisplayScrollBar.isVisible() ? 0 : this.getHorizontalScrollbarHeight(n4);
                    switch (n4) {
                        case 0: {
                            visDisplayScrollBar.setBounds(n20, n22, n23, n25);
                            n20 += n5;
                            break;
                        }
                        case 2: {
                            visDisplayScrollBar.setBounds(n20, n22, n24, n31);
                            n22 += n6;
                            break;
                        }
                        case 1: {
                            int n32 = n20 + n24 - (this.canScrollbarBeHidden() ? n23 : 0);
                            visDisplayScrollBar.setBounds(n32, n22, n23, n25);
                            break;
                        }
                        case 3: {
                            int n33 = n22 + n25 - (this.canScrollbarBeHidden() ? n31 : 0);
                            visDisplayScrollBar.setBounds(n20, n33, n24, n31);
                        }
                    }
                    visDisplay2.setBounds(n20, n22, n24, n25);
                    n20 = n11 + (n21 + 1) * n18;
                }
                ++n21;
            }
            n12 += n16;
            n12 += n6;
            n12 += n8;
            ++n19;
        }
    }

    private Dimension getDisplayExtent(Point point) {
        if (this.mergedCells == null) {
            return null;
        }
        return this.mergedCells.get(point);
    }
}

