/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis.dnd;

import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.dnd.IVisDisplayDropHandler;
import com.tiani.jvision.vis.dnd.VisDisplayDropHandlerFactory;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;

public class VisDisplayDropTargetListener
implements DropTargetListener {
    private static final ALogger log = ALogger.getLogger(VisDisplayDropTargetListener.class);
    private VisDisplayDropHandlerFactory factory = VisDisplayDropHandlerFactory.getInstance();
    private VisDisplay2 visDisplay;

    public VisDisplayDropTargetListener(VisDisplay2 visDisplay2) {
        this.visDisplay = visDisplay2;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        List<IVisDisplayDropHandler> list = this.factory.getVisDisplayDropHandler();
        boolean bl = false;
        int n = 0;
        for (IVisDisplayDropHandler iVisDisplayDropHandler : list) {
            if (!iVisDisplayDropHandler.dragEnter(dropTargetDragEvent, this.visDisplay)) continue;
            bl = true;
            n = iVisDisplayDropHandler.chooseAction(dropTargetDragEvent);
            break;
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(n);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        List<IVisDisplayDropHandler> list = this.factory.getVisDisplayDropHandler();
        for (IVisDisplayDropHandler iVisDisplayDropHandler : list) {
            iVisDisplayDropHandler.dragExit(dropTargetEvent, this.visDisplay);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        List<IVisDisplayDropHandler> list = this.factory.getVisDisplayDropHandler();
        boolean bl = false;
        int n = 0;
        for (IVisDisplayDropHandler iVisDisplayDropHandler : list) {
            if (!iVisDisplayDropHandler.dragOver(dropTargetDragEvent, this.visDisplay)) continue;
            bl = true;
            n = iVisDisplayDropHandler.chooseAction(dropTargetDragEvent);
            break;
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(n);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        List<IVisDisplayDropHandler> list = this.factory.getVisDisplayDropHandler();
        for (IVisDisplayDropHandler iVisDisplayDropHandler : list) {
            if (!iVisDisplayDropHandler.drop(dropTargetDropEvent)) continue;
            try {
                int n = iVisDisplayDropHandler.handleDrop(this.visDisplay, dropTargetDropEvent);
                if (n == 0) continue;
                dropTargetDropEvent.acceptDrop(n);
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            catch (Exception exception) {
                log.error("Handling vis-display drop failed!", (Throwable)exception);
            }
        }
        dropTargetDropEvent.rejectDrop();
        dropTargetDropEvent.dropComplete(false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        List<IVisDisplayDropHandler> list = this.factory.getVisDisplayDropHandler();
        boolean bl = false;
        for (IVisDisplayDropHandler iVisDisplayDropHandler : list) {
            if (!iVisDisplayDropHandler.dropActionChanged(dropTargetDragEvent)) continue;
            bl = true;
            break;
        }
        if (bl) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }
}

