/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.VariableLayout;
import com.agfa.pacs.impaxee.hanging.runtime.ScreenLayoutRuntime;
import com.agfa.pacs.impaxee.plugin.IDisplayPlugin;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorComponent;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainToolBar2;
import com.tiani.jvision.plugin.DefaultDisplayPlugin;
import com.tiani.jvision.toptoolbar.LayoutChangeAction;
import com.tiani.jvision.toptoolbar.MainLayoutActionProvider;
import com.tiani.jvision.toptoolbar.StripeColumnsActionProvider;
import com.tiani.jvision.toptoolbar.VariableLayoutActionProvider;
import com.tiani.jvision.vis.EmptyVisDisplay2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreenToolBar2;
import com.tiani.jvision.vis.layout.IStateLytScreen;
import com.tiani.jvision.vis.layout.LytDisplay;
import com.tiani.jvision.vis.layout.LytScreen;
import com.tiani.jvision.vis.layout.LytScreenFilm;
import com.tiani.jvision.vis.layout.LytScreenStripe;
import com.tiani.jvision.vis.layout.LytScreenVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.UIManager;

public class VisScreen2
extends MultiMonitorComponent
implements PDataProvider {
    public static final Color COLOR_NOSELECT = new Color(0xD0D0D0);
    public static final Color COLOR_SELECT = UIManager.getColor("color.primary.1");
    private static int IDCounter = 0;
    private static final ALogger log = ALogger.getLogger(VisScreen2.class);
    private int ID = IDCounter++;
    private MainToolBar2 mainToolBar;
    private VisScreenToolBar2 toolBar;
    private boolean hasDetachedDisplay = false;
    private Map<String, PAction> actions = new Hashtable<String, PAction>();
    private boolean isActive = true;
    private boolean isSelected = true;
    private MainLayoutType lytMode = null;
    private LytScreen lyt = null;
    private List<VisDisplay2> displays = new Vector<VisDisplay2>();
    private List<VisDisplay2> allDisplays = new Vector<VisDisplay2>();
    private boolean isLayoutChangeAllowed;

    public VisScreen2() {
        this.setOpaque(false);
        this.setLayout(null);
        this.mainToolBar = new MainToolBar2();
        this.toolBar = new VisScreenToolBar2(this);
        this.setName("VisScreen:" + this.ID);
    }

    public void clear() {
        for (VisDisplay2 visDisplay2 : this.getAllDisplays()) {
            visDisplay2.clearByUser();
            visDisplay2.resetType();
            visDisplay2.resetFilter();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public MainToolBar2 getMainToolBar() {
        return this.mainToolBar;
    }

    public VisScreenToolBar2 getToolBar() {
        return this.toolBar;
    }

    public List<VisDisplay2> getSynchronizedDisplays() {
        ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
        for (VisDisplay2 visDisplay2 : this.displays) {
            if (visDisplay2.getData() == null || visDisplay2.getData().getVisCount() <= 0 || !visDisplay2.getData().isSynchronized()) continue;
            arrayList.add(visDisplay2);
        }
        return arrayList;
    }

    public List<VisDisplay2> getDisplays() {
        return this.displays;
    }

    public List<VisDisplay2> getAllDisplays() {
        return this.allDisplays;
    }

    public void addDisplay() {
        VisDisplay2 visDisplay2 = new VisDisplay2(this);
        this.addDisplay(visDisplay2);
    }

    public void addDisplay(VisDisplay2 visDisplay2) {
        if (!this.allDisplays.contains(visDisplay2)) {
            this.allDisplays.add(visDisplay2);
        }
        if (this.lyt.allowsOneMoreDisplay(this)) {
            if (!this.displays.contains(visDisplay2)) {
                this.displays.add(visDisplay2);
            }
            this.add(visDisplay2.getToolBar());
            this.add(visDisplay2.getScrollBar());
            this.add(visDisplay2);
            visDisplay2.setActive(true);
            visDisplay2.setVisible(true);
            visDisplay2.setEnabled(true);
        } else {
            visDisplay2.setActive(false);
            visDisplay2.setVisible(false);
            visDisplay2.setEnabled(false);
        }
    }

    public int removeDisplayAt(int n) {
        VisDisplay2 visDisplay2 = this.displays.get(n);
        int n2 = this.allDisplays.indexOf(visDisplay2);
        this.allDisplays.remove(visDisplay2);
        this.displays.remove(visDisplay2);
        this.remove(visDisplay2.getToolBar());
        this.remove(visDisplay2.getScrollBar());
        this.remove(visDisplay2);
        visDisplay2.cleanUp();
        return n2;
    }

    public EmptyVisDisplay2 detachDisplay(VisDisplay2 visDisplay2) {
        this.remove(visDisplay2.getToolBar());
        this.remove(visDisplay2.getScrollBar());
        this.remove(visDisplay2);
        int n = this.displays.indexOf(visDisplay2);
        EmptyVisDisplay2 emptyVisDisplay2 = new EmptyVisDisplay2(this);
        this.add((Component)emptyVisDisplay2.getToolBar(), n * 3);
        this.add((Component)emptyVisDisplay2.getScrollBar(), n * 3 + 1);
        this.add((Component)emptyVisDisplay2, n * 3 + 2);
        emptyVisDisplay2.setActive(true);
        emptyVisDisplay2.setVisible(true);
        emptyVisDisplay2.setEnabled(true);
        visDisplay2.setIsDetached(true);
        this.hasDetachedDisplay = true;
        this.notifyLayoutEnablingChanged();
        this.revalidate();
        return emptyVisDisplay2;
    }

    public void atachDisplay(VisDisplay2 visDisplay2, EmptyVisDisplay2 emptyVisDisplay2) {
        this.remove(emptyVisDisplay2.getToolBar());
        this.remove(emptyVisDisplay2.getScrollBar());
        this.remove(emptyVisDisplay2);
        int n = this.displays.indexOf(visDisplay2);
        this.add((Component)visDisplay2.getToolBar(), n * 3);
        this.add((Component)visDisplay2.getScrollBar(), n * 3 + 1);
        this.add((Component)visDisplay2, n * 3 + 2);
        visDisplay2.setIsDetached(false);
        this.hasDetachedDisplay = false;
        this.notifyLayoutEnablingChanged();
        this.revalidate();
    }

    private void notifyLayoutEnablingChanged() {
        this.notifyVariableLayoutEnablingChanged();
        MainLayoutActionProvider.fireEnabledChanged();
    }

    private void notifyVariableLayoutEnablingChanged() {
        VariableLayout[] variableLayoutArray = VariableLayout.values();
        int n = variableLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLayout variableLayout = variableLayoutArray[n2];
            this.getAction(VariableLayoutActionProvider.getActionIDForType(variableLayout)).fireEnabledChanged();
            ++n2;
        }
        this.getAction("VARIABLE_LAYOUT_GROUP").fireEnabledChanged();
    }

    public boolean hasDetachedDisplay() {
        return this.hasDetachedDisplay;
    }

    public void insertDisplayAt(VisDisplay2 visDisplay2, int n, int n2) {
        visDisplay2.setScreen(this);
        this.allDisplays.add(n2, visDisplay2);
        this.displays.add(n, visDisplay2);
        if (n * 3 >= this.getComponentCount()) {
            this.add(visDisplay2.getToolBar());
            this.add(visDisplay2.getScrollBar());
            this.add(visDisplay2);
        } else {
            this.add((Component)visDisplay2.getToolBar(), n * 3);
            this.add((Component)visDisplay2.getScrollBar(), n * 3 + 1);
            this.add((Component)visDisplay2, n * 3 + 2);
        }
    }

    public boolean hasData() {
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            if (!visDisplay2.hasData()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
        if (!JVision2.getMainFrame().isInitialized()) {
            return;
        }
        super.paint(graphics);
    }

    @Override
    public void paintBorder(Graphics graphics) {
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        graphics.setColor(this.isSelected ? COLOR_SELECT : COLOR_NOSELECT);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    public LytScreen getLyt() {
        return this.lyt;
    }

    public MainLayoutType getLytMode() {
        return this.lytMode;
    }

    public void setLytMode(MainLayoutType mainLayoutType, int n, int n2, boolean bl) {
        this.setLytMode(mainLayoutType, n, n2, null, bl);
    }

    public void setLytMode(MainLayoutType mainLayoutType, IStateLytScreen iStateLytScreen, boolean bl) {
        this.setLytMode(mainLayoutType, iStateLytScreen.getCols(), iStateLytScreen.getRows(), iStateLytScreen.getMergedCells(), bl);
    }

    private void setLytMode(MainLayoutType mainLayoutType, int n, int n2, Map<Point, Dimension> map, boolean bl) {
        int n3;
        boolean bl2;
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Setting screen columns=");
            stringBuilder.append(n);
            stringBuilder.append(", rows=");
            stringBuilder.append(n2);
            if (map != null) {
                stringBuilder.append(" with mergedCells=");
                stringBuilder.append(map);
            }
            stringBuilder.append(" in ");
            stringBuilder.append(this.hashCode());
            log.debug(stringBuilder.toString());
        }
        boolean bl3 = bl2 = this.lyt == null;
        if (!bl2 && mainLayoutType == this.lytMode && mainLayoutType != MainLayoutType.film && this.lyt.isEquivalent(n, n2, map)) {
            return;
        }
        if (mainLayoutType != null) {
            this.lytMode = mainLayoutType;
        } else {
            mainLayoutType = this.lytMode;
            n2 = -1;
            n = -1;
        }
        switch (this.lytMode) {
            case variable: {
                if (this.lyt == null || !(this.lyt instanceof LytScreenVariable)) {
                    this.lyt = new LytScreenVariable();
                }
                if (n2 != -1) {
                    this.lyt.setRows(n2);
                }
                if (n != -1) {
                    this.lyt.setCols(n);
                }
                this.lyt.setMergedCells(map);
                break;
            }
            case stripe: {
                if (this.lyt == null || !(this.lyt instanceof LytScreenStripe)) {
                    this.lyt = new LytScreenStripe();
                }
                if (n2 != -1) {
                    this.lyt.setRows(n2);
                    break;
                }
                this.lyt.setRows(this.lyt.getRows());
                break;
            }
            case film: {
                if (this.lyt != null && this.lyt instanceof LytScreenFilm) break;
                this.lyt = new LytScreenFilm();
                break;
            }
            default: {
                this.lytMode = mainLayoutType = MainLayoutType.variable;
                if (this.lyt != null && this.lyt instanceof LytScreenVariable) break;
                this.lyt = new LytScreenVariable();
            }
        }
        this.setLayout(this.lyt);
        VisDisplay2[] visDisplay2Array = new VisDisplay2[this.allDisplays.size()];
        int n4 = 0;
        while (n4 < visDisplay2Array.length) {
            visDisplay2Array[n4] = this.allDisplays.get(n4);
            visDisplay2Array[n4].setActive(true);
            ++n4;
        }
        n4 = n;
        int n5 = n2;
        if (mainLayoutType == MainLayoutType.stripe) {
            if (n == -1) {
                n4 = visDisplay2Array.length <= 0 ? 8 : visDisplay2Array[0].getLyt().getCols();
            }
            if (n2 == -1) {
                n5 = this.lyt.getRows();
            }
        }
        Component[] componentArray = this.getComponents();
        int n6 = 0;
        while (n6 < componentArray.length) {
            if (componentArray[n6] instanceof VisDisplay2) {
                VisDisplay2 visDisplay2 = (VisDisplay2)componentArray[n6];
                this.remove(visDisplay2.getToolBar());
                this.remove(visDisplay2.getScrollBar());
                this.remove(visDisplay2);
            }
            ++n6;
        }
        HashSet<IDisplaySet> hashSet = new HashSet<IDisplaySet>();
        for (VisDisplay2 visDisplay2 : this.displays) {
            if (visDisplay2.getData().getDisplaySet() == null) continue;
            hashSet.add(visDisplay2.getData().getDisplaySet());
        }
        this.displays.clear();
        int n7 = this.lyt.getMissingDisplayCount(this);
        boolean bl4 = false;
        int n8 = 0;
        while (n8 < visDisplay2Array.length) {
            if (this.allDisplays.get(n8).hasData() && n8 >= n7) {
                bl4 = true;
            }
            ++n8;
        }
        n8 = 0;
        int n9 = 0;
        while (n9 < visDisplay2Array.length) {
            if (visDisplay2Array[n9].isActive()) {
                ++n8;
            }
            ++n9;
        }
        n9 = -1;
        int n10 = -1;
        VisData visData = VisData.getLastModified();
        VisDisplay2 visDisplay2 = null;
        if (visData != null && visData.getParent() != null) {
            visDisplay2 = visData.getParent().getVisDisplay();
        }
        if (bl4) {
            n3 = 0;
            while (n3 < visDisplay2Array.length) {
                if (visDisplay2Array[n3] == visDisplay2) {
                    n10 = n3;
                }
                if (visDisplay2Array[n3].isActive() && !visDisplay2Array[n3].hasData()) {
                    visDisplay2Array[n3].setActive(false);
                    --n8;
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < visDisplay2Array.length) {
            if (visDisplay2Array[n3].isActive() && n9 == -1) {
                n9 = n3;
            }
            ++n3;
        }
        if (n8 > n7 && visDisplay2 != null && n10 - n9 >= n7) {
            n3 = n10 - n9 - n7 + 1;
            int n11 = n9;
            while (n11 < n9 + n3) {
                visDisplay2Array[n11].setActive(false);
                --n8;
                ++n11;
            }
        }
        n3 = 0;
        while (n3 < visDisplay2Array.length) {
            if (visDisplay2Array[n3].isActive()) {
                this.addDisplay(visDisplay2Array[n3]);
                if (--n7 < 1) break;
            }
            ++n3;
        }
        n7 = this.lyt.getMissingDisplayCount(this);
        n3 = 0;
        while (n3 < visDisplay2Array.length) {
            if (!visDisplay2Array[n3].isActive()) {
                this.addDisplay(visDisplay2Array[n3]);
                if (--n7 < 1) break;
            }
            ++n3;
        }
        n7 = this.lyt.getMissingDisplayCount(this);
        while (n7 > 0) {
            this.addDisplay();
            --n7;
        }
        if (mainLayoutType == MainLayoutType.variable) {
            n5 = -1;
            n4 = -1;
        }
        n3 = 0;
        while (n3 < this.allDisplays.size()) {
            VisDisplay2 visDisplay22 = this.allDisplays.get(n3);
            if (visDisplay22.isActive()) {
                LytDisplay lytDisplay = null;
                if (mainLayoutType == MainLayoutType.variable && !(visDisplay22.getData().getDisplayPlugin() instanceof DefaultDisplayPlugin)) {
                    IDisplayPlugin iDisplayPlugin = visDisplay22.getData().getDisplayPlugin();
                    lytDisplay = iDisplayPlugin.getSpecialLayout();
                    Dimension dimension = null;
                    if (lytDisplay == null) {
                        if (visDisplay22.getLyt() != null) {
                            lytDisplay = visDisplay22.getLyt();
                        } else {
                            lytDisplay = mainLayoutType.getNewLytDisplay();
                            dimension = iDisplayPlugin.getPreferredVisLayout();
                        }
                    }
                    if (dimension != null) {
                        n4 = dimension.width;
                        n5 = dimension.height;
                    }
                } else {
                    lytDisplay = visDisplay22.getLyt() != null && visDisplay22.getLyt().getMainLayoutType() == mainLayoutType ? visDisplay22.getLyt() : mainLayoutType.getNewLytDisplay();
                }
                visDisplay22.setLytMode(lytDisplay, n4, n5, bl, false);
            }
            ++n3;
        }
        if (mainLayoutType != MainLayoutType.variable) {
            this.toolBar.updateHRs();
            JVision2.getMainFrame().updateLytHRs();
        }
        LayoutChangeAction.notifyScreenLayoutChanged(mainLayoutType);
        for (VisDisplay2 visDisplay23 : this.displays) {
            if (visDisplay23.getData().getDisplaySet() == null) continue;
            if (hashSet.contains(visDisplay23.getData().getDisplaySet())) {
                hashSet.remove(visDisplay23.getData().getDisplaySet());
                continue;
            }
            visDisplay23.getData().getDisplaySet().incrementLoadCount();
        }
        for (IDisplaySet iDisplaySet : hashSet) {
            iDisplaySet.decrementLoadCount();
        }
        if (bl && !bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void getLytHRs(List<String> list) {
        switch (this.lytMode) {
            case variable: 
            case film: {
                break;
            }
            case stripe: {
                int n = 1;
                while (n <= 8) {
                    list.add(StripeColumnsActionProvider.getActionIDForColumnCount(n));
                    ++n;
                }
                break;
            }
        }
    }

    public void getHRs(List<String> list) {
        list.add("CLEAR_DISPLAY");
        list.add("PRINT");
    }

    public void getActiveHRs(List<String> list) {
        switch (this.lytMode) {
            case variable: 
            case film: {
                break;
            }
            case stripe: {
                LytDisplay lytDisplay = this.getDisplays().get(0).getLyt();
                list.add(StripeColumnsActionProvider.getActionIDForColumnCount(lytDisplay.getCols()));
            }
        }
    }

    public ScreenLayoutRuntime captureScreenLayout() {
        ScreenLayoutRuntime screenLayoutRuntime = new ScreenLayoutRuntime();
        screenLayoutRuntime.setHorizontalXVertical(this.lyt.getType());
        for (VisDisplay2 visDisplay2 : this.getDisplays()) {
            screenLayoutRuntime.addDisplayLayout(visDisplay2.captureDisplayLayout());
        }
        return screenLayoutRuntime;
    }

    @Override
    public List<VisData> getVisDatas() {
        ArrayList<VisData> arrayList = new ArrayList<VisData>();
        for (VisDisplay2 visDisplay2 : this.getVisDisplays()) {
            arrayList.addAll(visDisplay2.getVis());
        }
        return arrayList;
    }

    @Override
    public List<VisDisplay2> getVisDisplays() {
        return this.getDisplays();
    }

    @Override
    public VisScreen2 getVisScreen() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PAction getAction(String string) {
        PAction pAction = this.actions.get(string);
        if (pAction != null) {
            return pAction;
        }
        VisScreen2 visScreen2 = this;
        synchronized (visScreen2) {
            pAction = this.actions.get(string);
            if (pAction != null) {
                return pAction;
            }
            pAction = PActionRegistry.createDataAction(string, this);
            this.actions.put(string, pAction);
            return pAction;
        }
    }

    @Override
    public PDataProvider.ProviderType getType() {
        return PDataProvider.ProviderType.Screen;
    }

    @Override
    public boolean hasAction(String string) {
        return this.actions.containsKey(string);
    }

    public boolean isLayoutChangeAllowed() {
        return this.isLayoutChangeAllowed && !this.hasDetachedDisplay;
    }

    void setLayoutChangeAllowed(boolean bl) {
        this.isLayoutChangeAllowed = bl;
        this.notifyVariableLayoutEnablingChanged();
    }
}

