/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.vis;

import com.agfa.pacs.base.swing.util.ModifierKeys;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.mousemodeinfo.IMouseModeInfo;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.agfa.pacs.impaxee.vismenu.VisMenu;
import com.tiani.config.LayoutConfig;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorComponent;
import com.tiani.jvision.actioncontext.ActionContextManager;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.DisplaySetSelectionPanel;
import com.tiani.jvision.image.IViewMouseHandler;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.AbstractMouseModeInfo;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.VisInfoManager;
import com.tiani.jvision.mouse.MouseWrapper;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.IMouseInfoProvider;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.dnd.VisDisplayDropTargetListener;
import com.tiani.jvision.vis.dnd.VisDragGestureRecognizer;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;

public class VisMouseHandler
extends MultiMonitorComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final int ANY_MODIFIER_KEY = 11;
    private static boolean globalNavigEnabled = true;
    private static final ZoomWheelMode zoomWheelMoude = ZoomWheelMode.valueOf(Config.impaxee.jvision.MEASUREMENT.ZoomDuringMeasurement.get().toUpperCase());
    private static Component dragComp;
    private static VisMouseHandler dragShiftHandler;
    private static EventQueue eventQueue;
    private static final boolean WINDOWING_IMPAX_ES;
    private static final boolean SCROLLING_IMPAX_ES;
    private static final boolean MOUSE_SCROLL_INVERSION_IMPAX_ES;
    private static boolean densityInfo;
    private static int xTooltipOffset;
    private static int yTooltipOffset;
    private static final int MAX_TIME_BETWEEN_CLICKS;
    private static final int POPUP_DRAG_TOLERANCE;
    private static long lastMouseButtonPressedTime;
    private static boolean acceptRMBClick;
    private static double sliceSkipPerDY;
    private static int sliceStartIndex;
    private static boolean isMousePositionWithinImageShown;
    private IMouseInfoProvider mouseInfoProvider;
    private Vis2 vis;
    private DragSource dndSource;
    private VisDragGestureRecognizer dndRecognizer;
    private DropTarget dndTarget;
    private Point dragStartPt = new Point();
    private Point dragLastPt = new Point();
    private int dragRelX;
    private int dragRelY;
    private int dragAbsX;
    private int dragAbsY;
    private boolean ignoreNextDrag = false;
    private Point lastPt = new Point();
    private MouseWrapper mouseWrapper;

    static {
        eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        WINDOWING_IMPAX_ES = Config.impaxee.jvision.DISPLAY.WindowingIMPAX_ES.get();
        SCROLLING_IMPAX_ES = Config.impaxee.jvision.DISPLAY.ScrollingIMPAX_ES.get();
        MOUSE_SCROLL_INVERSION_IMPAX_ES = Config.impaxee.jvision.DISPLAY.MouseScrollInversionIMPAX_ES.get();
        densityInfo = Config.impaxee.jvision.DISPLAY.DensityValueTooltip.get();
        xTooltipOffset = LayoutConfig.getInstance().getScreenWidth() / 10;
        yTooltipOffset = LayoutConfig.getInstance().getScreenHeight() / 10;
        MAX_TIME_BETWEEN_CLICKS = (int)Config.impaxee.jvision.SEQLABEL.DoubleClickInterval.get();
        POPUP_DRAG_TOLERANCE = (int)((double)Math.max(LayoutConfig.getInstance().getScreenWidth(), LayoutConfig.getInstance().getScreenHeight()) * 0.007);
        acceptRMBClick = true;
    }

    public static void setGlobalNavigEnabled(boolean bl) {
        globalNavigEnabled = bl;
    }

    public static boolean isMousePositionWithinImageShown() {
        return isMousePositionWithinImageShown;
    }

    public static void toggleMousePositionWithinImageShown() {
        isMousePositionWithinImageShown = !isMousePositionWithinImageShown;
    }

    VisMouseHandler(Vis2 vis2) {
        this.vis = vis2;
        if (vis2.getVisDisplay().isDragAndDropEnabled()) {
            this.dndSource = new DragSource();
            this.dndRecognizer = new VisDragGestureRecognizer(vis2, this.dndSource, this, 0x40000003);
            this.dndTarget = new DropTarget(this, new VisDisplayDropTargetListener(vis2.getVisDisplay()));
        }
        this.mouseWrapper = new MouseWrapper(JVision2.getMainFrame());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setCursor(vis2.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo().getCursor(vis2));
    }

    void destruct() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    private List<Component> getComponentsAt(Point point) {
        Component component;
        Rectangle rectangle;
        ArrayList<Component> arrayList = new ArrayList<Component>(4);
        if (this.vis.getView() != null && this.vis.getView().getMouseHandler() != null && (rectangle = (component = (Component)((Object)this.vis.getView().getMouseHandler())).getBounds()).contains(point.x + rectangle.x, point.y + rectangle.y)) {
            arrayList.add(component);
        }
        Component[] componentArray = this.vis.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2;
            component = componentArray[n2];
            if (component instanceof MouseListener && component instanceof MouseMotionListener && (rectangle2 = component.getBounds()).contains(point)) {
                arrayList.add(component);
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean canPopup() {
        return this.vis.canShowMenu();
    }

    private VisMenu newPopupMenu() {
        return this.canPopup() ? new VisMenu(this.vis) : null;
    }

    private void showTraditionalPopupMenu(MouseEvent mouseEvent) {
        if (!this.vis.getVisDisplay().isPopupEnabled()) {
            return;
        }
        VisMenu visMenu = this.newPopupMenu();
        if (visMenu != null) {
            visMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void showImpaxToolboxPopup(MouseEvent mouseEvent) {
        if (!this.canPopup()) {
            return;
        }
        JVision2.getMainFrame().getPluginToolbox().showDialog();
    }

    private void onMouseDrag(MouseEvent mouseEvent) {
        if (ModifierKeys.isMMB((MouseEvent)mouseEvent) && !WINDOWING_IMPAX_ES || ModifierKeys.isRMB((MouseEvent)mouseEvent) && WINDOWING_IMPAX_ES) {
            this.performWindowing(mouseEvent, false);
        } else if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && SCROLLING_IMPAX_ES) {
            this.performScrolling();
        }
    }

    private void performScrolling() {
        if (this.vis == null || this.vis.getVisDisplay() == null || JVision2.getMainFrame() != null && Math.abs(this.dragRelY) > JVision2.getMainFrame().getSize().height / 2) {
            return;
        }
        int n = (int)Math.round((double)this.dragAbsY * sliceSkipPerDY) + sliceStartIndex;
        int n2 = this.vis.getVisDisplay().getVisNavigationEventHandler().convertToMouseWheelMovement(n);
        if (n2 != 0) {
            this.vis.getVisDisplay().handleMouseWheelMovement(n2, true);
        }
    }

    private void performWindowing(MouseEvent mouseEvent, boolean bl) {
        if (this.vis.getData() != null) {
            if (bl) {
                this.vis.removeHRs();
                this.vis.repaint();
            }
            int n = ModifierKeys.isCtrl((InputEvent)mouseEvent) ? 1 : 0;
            TEvent tEvent = new TEvent();
            tEvent.id = 62;
            this.vis.getData().getView().handleTEvent(tEvent, mouseEvent, n);
        }
    }

    private void onMousePress(MouseEvent mouseEvent) {
        IMouseModeInfo iMouseModeInfo;
        acceptRMBClick = true;
        if (ModifierKeys.isRMB((MouseEvent)mouseEvent) && !mouseEvent.isShiftDown() && WINDOWING_IMPAX_ES) {
            this.performWindowing(mouseEvent, true);
            acceptRMBClick = false;
        } else if (ModifierKeys.isMMB((MouseEvent)mouseEvent) && !WINDOWING_IMPAX_ES) {
            this.performWindowing(mouseEvent, true);
        } else if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && (iMouseModeInfo = this.getMouseModeInfo()).getSubMode() == MouseSubModes.DEFAULT && VisMouseHandler.switchFullSize(mouseEvent, this.vis)) {
            this.mouseReleased(new MouseEvent(this.vis, 502, System.currentTimeMillis(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }
    }

    public static boolean switchFullSize(MouseEvent mouseEvent, Vis2 vis2) {
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isShiftDown()) {
            if (mouseEvent.getY() < vis2.getSize().height / 2) {
                if (vis2.getVisDisplay().canDoFullSwitch()) {
                    vis2.getVisDisplay().switchFullDisplay(true);
                } else {
                    vis2.getVisDisplay().switchFullScreen(true);
                }
                return true;
            }
            if (mouseEvent.getY() >= vis2.getSize().height / 2) {
                vis2.getVisDisplay().switchFullScreen(true);
                return true;
            }
        }
        return false;
    }

    private void onMouseRelease(MouseEvent mouseEvent) {
        acceptRMBClick = true;
        if (ModifierKeys.isSpaceOr4thMButton((MouseEvent)mouseEvent) && ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
            HotRegion hotRegion;
            if (this.vis.getHRSet() != null && (hotRegion = this.vis.getHRSet().getHR("PAN")) != null) {
                hotRegion.mouseReleased(mouseEvent);
                hotRegion.mouseExited(mouseEvent);
                hotRegion.setVisible(true);
            }
        } else if (this.vis.getData() != null && (ModifierKeys.isMMB((MouseEvent)mouseEvent) && !WINDOWING_IMPAX_ES || ModifierKeys.isRMB((MouseEvent)mouseEvent) && WINDOWING_IMPAX_ES)) {
            this.performWindowing(mouseEvent, false);
        } else if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && this.getMouseModeInfo().isNavigationAllowed() && this.vis.getVisDisplay() != null && this.vis.getVisDisplay().getData().getDisplayPlugin().isNavigationAllowed()) {
            this.vis.getVisDisplay().stopNavigDrag();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastPt.x = mouseEvent.getX();
        this.lastPt.y = mouseEvent.getY();
        if (VisDisplay2.isSyncPosUpdateActive()) {
            VisDisplay2 visDisplay2 = this.vis.getVisDisplay();
            VisDisplayData visDisplayData = visDisplay2.getData();
            if (visDisplayData != null) {
                VisData visData = visDisplayData.getLastMovedOverOnSyncPosUpdate();
                visDisplayData.setLastMovedOverOnSyncPosUpdate(null);
                if (visData != null && visData.getVisual() != null) {
                    visData.getVisual().repaintBorder();
                }
                if (this.vis.getData() != null) {
                    visDisplayData.setLastMovedOverOnSyncPosUpdate(this.vis.getData());
                    this.vis.repaintBorder();
                }
            }
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (dragShiftHandler != null && VisMouseHandler.dragShiftHandler.vis.getVisDisplay() == this.vis.getVisDisplay()) {
                boolean bl;
                boolean bl2 = ModifierKeys.isLMB((MouseEvent)mouseEvent);
                boolean bl3 = bl = bl2 || ModifierKeys.isRMB((MouseEvent)mouseEvent);
                if (bl) {
                    this.vis.setSelected(bl2);
                    this.vis.makeTheLastModified();
                    this.vis.repaintBorder();
                    VisData visData = VisMouseHandler.dragShiftHandler.vis.getData();
                    VisDisplayData visDisplayData = this.vis.getVisDisplay().getData();
                    int n = visDisplayData.indexOf(visData);
                    int n2 = visDisplayData.indexOf(this.vis.getData());
                    if (n2 >= 0 && n >= 0 && n2 < visDisplayData.getVisCount() && n < visDisplayData.getVisCount()) {
                        int n3;
                        if (n2 < n) {
                            n3 = n2;
                            n2 = n;
                            n = n3;
                        }
                        n3 = n;
                        while (n3 <= n2) {
                            VisData visData2 = visDisplayData.getVis(n3);
                            visData2.setSelected(bl2);
                            ++n3;
                        }
                    }
                    VisDisplay2 visDisplay2 = this.vis.getVisDisplay();
                    int n4 = 0;
                    while (n4 < visDisplay2.getVisViewCount()) {
                        Vis2 vis2 = visDisplay2.getVisView(n4);
                        vis2.repaintBorder();
                        ++n4;
                    }
                }
            }
            return;
        }
        this.densityVisInfo(mouseEvent);
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        for (Component component : list) {
            MouseListener mouseListener = (MouseListener)((Object)component);
            MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
            mouseListener.mouseEntered(mouseEvent2);
        }
    }

    private void densityVisInfo(MouseEvent mouseEvent) {
        int[] nArray;
        View view = this.vis.getView();
        if (view != null) {
            view.broadcastPointOfInterest(mouseEvent.getX(), mouseEvent.getY());
        }
        String string = null;
        if (this.mouseInfoProvider != null) {
            string = mouseEvent.getID() == 505 ? "" : this.mouseInfoProvider.getInfoAt(mouseEvent.getX(), mouseEvent.getY());
        } else if (view != null) {
            string = view.getInfoAt(mouseEvent.getX(), mouseEvent.getY());
        }
        if (isMousePositionWithinImageShown && view != null && string != null && !string.isEmpty() && (nArray = view.getImageCoordsAtScreenPosition(mouseEvent.getX(), mouseEvent.getY())) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(" [");
            stringBuilder.append(nArray[0]);
            stringBuilder.append(',');
            stringBuilder.append(nArray[1]);
            stringBuilder.append(']');
            string = stringBuilder.toString();
        }
        VisInfoManager.setVisInfoText(string);
        if (densityInfo) {
            this.setToolTipText(string);
        } else {
            this.setToolTipText(null);
        }
    }

    public void setMouseInfoProvider(IMouseInfoProvider iMouseInfoProvider) {
        this.mouseInfoProvider = iMouseInfoProvider;
    }

    public void unsetMouseInfoProvider(IMouseInfoProvider iMouseInfoProvider) {
        if (iMouseInfoProvider == this.mouseInfoProvider) {
            this.mouseInfoProvider = null;
        }
    }

    public void enableDensityToolTipText(boolean bl) {
        densityInfo = bl;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (this.getToolTipText() == null) {
            return null;
        }
        return new Point(mouseEvent.getX() + xTooltipOffset, mouseEvent.getY() + yTooltipOffset);
    }

    @Override
    public void setToolTipText(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        super.setToolTipText(string);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (VisDisplay2.isSyncPosUpdateActive()) {
            VisDisplay2 visDisplay2 = this.vis.getVisDisplay();
            VisDisplayData visDisplayData = visDisplay2.getData();
            if (visDisplay2.getData() != null && this.vis.getData() != null && this.vis.getData() == visDisplayData.getLastMovedOverOnSyncPosUpdate()) {
                visDisplayData.setLastMovedOverOnSyncPosUpdate(null);
                this.vis.repaintBorder();
            }
            return;
        }
        if (mouseEvent.isShiftDown() && (ModifierKeys.isLMB((MouseEvent)mouseEvent) || ModifierKeys.isRMB((MouseEvent)mouseEvent))) {
            return;
        }
        this.densityVisInfo(mouseEvent);
        List<Component> list = this.getComponentsAt(this.lastPt);
        for (Component component : list) {
            MouseListener mouseListener = (MouseListener)((Object)component);
            MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
            mouseListener.mouseExited(mouseEvent2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2;
        EventListener eventListener;
        if (VisDisplay2.pjvi1754_isNavigDragActive()) {
            return;
        }
        if (this.vis.getVisDisplay() != null) {
            this.vis.getVisDisplay().getScrollBar().decreaseHidingCounter();
        }
        if (VisDisplay2.isSyncPosUpdateActive()) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            return;
        }
        this.densityVisInfo(mouseEvent);
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        VisMouseEventInfo visMouseEventInfo = this.analyzeEvent(mouseEvent, list);
        if (this.checkLocalizerHandler(mouseEvent, visMouseEventInfo)) {
            return;
        }
        List<Component> list2 = this.getComponentsAt(this.lastPt);
        for (Component component : list2) {
            if (list.contains(component)) continue;
            eventListener = (MouseListener)((Object)component);
            mouseEvent2 = this.convertMouseEvent(mouseEvent, component, 505);
            eventListener.mouseExited(mouseEvent2);
        }
        for (Component component : list) {
            if (list2.contains(component)) continue;
            eventListener = (MouseListener)((Object)component);
            mouseEvent2 = this.convertMouseEvent(mouseEvent, component, 504);
            eventListener.mouseEntered(mouseEvent2);
        }
        for (Component component : list) {
            eventListener = (MouseMotionListener)((Object)component);
            mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
            eventListener.mouseMoved(mouseEvent2);
        }
        this.lastPt.x = mouseEvent.getX();
        this.lastPt.y = mouseEvent.getY();
    }

    public void visDragged() {
        if (dragComp == this) {
            dragComp = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (ModifierKeys.isRMB((MouseEvent)mouseEvent) && mouseEvent.isControlDown()) {
            return;
        }
        if (this.ignoreNextDrag) {
            this.ignoreNextDrag = false;
            return;
        }
        this.densityVisInfo(mouseEvent);
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        VisMouseEventInfo visMouseEventInfo = this.analyzeEvent(mouseEvent, list);
        if (this.checkLocalizerHandler(mouseEvent, visMouseEventInfo)) {
            return;
        }
        this.lastPt.x = mouseEvent.getX();
        this.lastPt.y = mouseEvent.getY();
        if (VisDisplay2.isSyncPosUpdateActive()) {
            return;
        }
        if (this.isSpacePressedOrZoomPanTool(mouseEvent) && ModifierKeys.isLMB((MouseEvent)mouseEvent) && this.vis.getHRSet() != null) {
            this.vis.getHRSet().getHR("PAN").mouseDragged(mouseEvent);
            return;
        }
        if (mouseEvent.isShiftDown() && (ModifierKeys.isLMB((MouseEvent)mouseEvent) || ModifierKeys.isRMB((MouseEvent)mouseEvent))) {
            return;
        }
        Component component = dragComp;
        MouseMotionListener mouseMotionListener = (MouseMotionListener)((Object)component);
        if (mouseMotionListener == null) {
            return;
        }
        MouseEvent mouseEvent2 = null;
        this.dragRelX = mouseEvent.getX() - this.dragLastPt.x;
        this.dragRelY = mouseEvent.getY() - this.dragLastPt.y;
        if (JVision2.getMainFrame() != null && (Math.abs(this.dragRelX) > JVision2.getMainFrame().getSize().width / 2 || Math.abs(this.dragRelY) > JVision2.getMainFrame().getSize().height / 2)) {
            return;
        }
        this.dragAbsX += this.dragRelX;
        this.dragAbsY += this.dragRelY;
        this.dragLastPt.x = mouseEvent.getX();
        this.dragLastPt.y = mouseEvent.getY();
        mouseEvent.translatePoint(-mouseEvent.getX(), -mouseEvent.getY());
        mouseEvent.translatePoint(this.dragStartPt.x + this.dragAbsX, this.dragStartPt.y + this.dragAbsY);
        mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
        if (this.mouseWrapper != null && !this.vis.getVisDisplay().isDetached() && this.mouseWrapper.doWrap(this.dragLastPt)) {
            this.ignoreNextDrag = true;
        }
        if (mouseMotionListener == this.vis.getViewMouseHandler()) {
            mouseMotionListener.mouseDragged(mouseEvent2);
        } else if (mouseMotionListener != this) {
            mouseMotionListener.mouseDragged(mouseEvent2);
        } else {
            this.onMouseDrag(mouseEvent);
        }
    }

    private boolean isSpacePressedOrZoomPanTool(MouseEvent mouseEvent) {
        MouseSubModes mouseSubModes = this.getMouseModeInfo().getSubMode();
        return ModifierKeys.isSpaceOr4thMButton((MouseEvent)mouseEvent) || mouseSubModes == MouseSubModes.ZOOM_PAN;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        lastMouseButtonPressedTime = System.currentTimeMillis();
        if (!globalNavigEnabled) {
            return;
        }
        if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && this.isSpacePressedOrZoomPanTool(mouseEvent)) {
            if (VisData.getLastModified() != this.vis.getData()) {
                this.vis.makeTheLastModified();
            }
            this.vis.getHRSet().getHR("PAN").mousePressed(mouseEvent);
        }
        if (dragComp != null) {
            return;
        }
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        VisMouseEventInfo visMouseEventInfo = this.analyzeEvent(mouseEvent, list);
        if (this.checkLocalizerHandler(mouseEvent, visMouseEventInfo)) {
            return;
        }
        this.vis.requestFocus();
        if (VisDisplay2.isSyncPosUpdateActive()) {
            if (ModifierKeys.isRMB((MouseEvent)mouseEvent)) {
                VisDisplay2.setSyncPosUpdateActive(false);
                return;
            }
            VisDisplay2 visDisplay2 = this.vis.getVisDisplay();
            VisDisplayData visDisplayData = visDisplay2.getData();
            if (visDisplayData == null) return;
            VisData visData = visDisplayData.getSyncPointData();
            visDisplayData.setSyncPointData(null);
            if (visData != null && visData.getVisual() != null) {
                visData.getVisual().repaintBorder();
            }
            if (this.vis.getData() == null) return;
            visDisplayData.setSyncPointData(this.vis.getData());
            this.vis.getVisDisplay().getData().setSynchronized(true);
            this.vis.getVisDisplay().paintBorder();
            this.vis.repaintBorder();
            return;
        }
        boolean bl = VisData.getLastModified() != this.vis.getData();
        try {
            block42: {
                block43: {
                    HotRegion hotRegion;
                    if (bl) {
                        this.vis.makeTheLastModified();
                    }
                    if (bl && !VisDisplay2.pjvi1754_isNavigDragActive() && this.vis.getData() != null && Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get()) {
                        this.vis.getData().getParent().synchronizeWithOthers();
                        if (VisData.getLastModified() == null || VisData.getLastModified() != this.vis.getData()) {
                            this.vis.makeTheLastModified();
                        }
                    }
                    if (mouseEvent.isShiftDown()) {
                        dragShiftHandler = this;
                        if (this.vis.getData() != null) {
                            if (mouseEvent.getClickCount() == 2) {
                                boolean bl2 = ModifierKeys.isLMB((MouseEvent)mouseEvent);
                                for (VisData visData : this.vis.getData().getParent().getVis()) {
                                    visData.setSelected(bl2);
                                    Iterator<Component> iterator = visData.getVisual();
                                    if (iterator == null) continue;
                                    ((Vis2)((Object)iterator)).repaintBorder();
                                }
                            } else {
                                if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && !this.vis.isSelected()) {
                                    if (mouseEvent.isControlDown()) {
                                        void var7_20;
                                        void var7_19;
                                        void var7_18;
                                        VisDisplayData visDisplayData = this.vis.getData().getParent();
                                        int n = visDisplayData.indexOf(this.vis.getData());
                                        int n2 = n - 1;
                                        while (var7_18 >= 0) {
                                            if (visDisplayData.getVis((int)var7_18).isSelected()) break;
                                            --var7_18;
                                        }
                                        this.vis.setSelected(true);
                                        ++var7_19;
                                        while (var7_20 < n) {
                                            visDisplayData.getVis((int)var7_20).setSelected(true, true);
                                            ++var7_20;
                                        }
                                    } else {
                                        this.vis.setSelected(true);
                                    }
                                    this.vis.repaintBorder();
                                    return;
                                }
                                if (ModifierKeys.isRMB((MouseEvent)mouseEvent) && this.vis.isSelected()) {
                                    this.vis.setSelected(false);
                                    this.vis.repaintBorder();
                                    return;
                                }
                            }
                        }
                    }
                    if (bl) {
                        this.vis.repaintBorder();
                    }
                    dragComp = null;
                    this.dragStartPt.x = mouseEvent.getX();
                    this.dragStartPt.y = mouseEvent.getY();
                    this.dragLastPt.x = this.dragStartPt.x;
                    this.dragLastPt.y = this.dragStartPt.y;
                    this.dragRelY = 0;
                    this.dragRelX = 0;
                    this.dragAbsY = 0;
                    this.dragAbsX = 0;
                    if (SCROLLING_IMPAX_ES && ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
                        Rectangle rectangle = this.getBounds();
                        int n = this.vis.getVisDisplay().getVisNavigationEventHandler().getCurrentNavigationPosition();
                        int n3 = this.vis.getVisDisplay().getVisNavigationEventHandler().getTotalNavigationPositionCount();
                        sliceSkipPerDY = (double)n3 / rectangle.getHeight();
                        sliceStartIndex = n;
                    }
                    if (!ModifierKeys.isLMB((MouseEvent)mouseEvent) && !ModifierKeys.isMMB((MouseEvent)mouseEvent) && !ModifierKeys.isRMB((MouseEvent)mouseEvent)) break block42;
                    int n = -1;
                    int n4 = 0;
                    for (Component component : list) {
                        if (component instanceof IViewMouseHandler) {
                            n = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n != -1 && n < list.size() - 1) {
                        Component component = list.get(list.size() - 1);
                        list.set(list.size() - 1, list.get(n));
                        list.set(n, component);
                    }
                    if (!this.isSpacePressedOrZoomPanTool(mouseEvent) || !ModifierKeys.isLMB((MouseEvent)mouseEvent)) break block43;
                    if (this.vis.getHRSet() == null || (hotRegion = this.vis.getHRSet().getHR("PAN")) == null) break block42;
                    hotRegion.mouseEntered(mouseEvent);
                    hotRegion.mousePressed(mouseEvent);
                    break block42;
                }
                if (visMouseEventInfo.priorityROIPressed && this.vis.getData().getParent().getDisplayPlugin().getMouseModeInfo().areHotRegionsInside()) {
                    this.sendEventToViewMouseHandler(mouseEvent, list);
                } else if (visMouseEventInfo.hotRegionImageDirectlyPressed) {
                    this.sendEventToHotregion(mouseEvent, list);
                } else if (visMouseEventInfo.hotRegionPressed && visMouseEventInfo.roiPressed) {
                    this.sendEventToViewMouseHandler(mouseEvent, list);
                } else {
                    for (Component component : list) {
                        MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
                        MouseListener mouseListener = (MouseListener)((Object)component);
                        if (component instanceof IViewMouseHandler) {
                            IViewMouseHandler iViewMouseHandler = (IViewMouseHandler)((Object)component);
                            if (!iViewMouseHandler.wantsEvent(mouseEvent2)) continue;
                            dragComp = component;
                            mouseListener.mousePressed(mouseEvent2);
                            break;
                        }
                        if ((!ModifierKeys.isLMB((MouseEvent)mouseEvent) || mouseEvent.getClickCount() != 1) && (!ModifierKeys.isLMB((MouseEvent)mouseEvent) || mouseEvent.getClickCount() < 2 || !(component instanceof HotRegion))) continue;
                        dragComp = component;
                        mouseListener.mousePressed(mouseEvent2);
                        break;
                    }
                }
            }
            if (dragComp == null) {
                dragComp = this;
                this.onMousePress(mouseEvent);
            }
            if (this.mouseWrapper == null || this.vis.getVisDisplay().isDetached()) return;
            this.mouseWrapper.startWrap();
            return;
        }
        finally {
            if (bl && this.vis.getData() != null) {
                ActionContextManager.singleton.contextChanged(this.vis.getVisDisplay().getData());
            }
        }
    }

    private VisMouseEventInfo analyzeEvent(MouseEvent mouseEvent, List<Component> list) {
        VisMouseEventInfo visMouseEventInfo = new VisMouseEventInfo();
        if (ModifierKeys.isLMB((MouseEvent)mouseEvent)) {
            for (Component component : list) {
                Object object;
                MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
                if (component instanceof HotRegion) {
                    object = (HotRegion)component;
                    visMouseEventInfo.hotRegionPressed = true;
                    visMouseEventInfo.hotRegionImageDirectlyPressed = ((HotRegion)object).wasImageDirectlyPressed(mouseEvent2);
                }
                if (!(component instanceof IViewMouseHandler)) continue;
                object = (IViewMouseHandler)((Object)component);
                if (object.roiLocatedAt(mouseEvent2.getX(), mouseEvent2.getY())) {
                    visMouseEventInfo.roiPressed = true;
                }
                if (!object.priorityRoiLocatedAt(mouseEvent2.getX(), mouseEvent2.getY())) continue;
                visMouseEventInfo.priorityROIPressed = true;
            }
        }
        return visMouseEventInfo;
    }

    private void sendEventToHotregion(MouseEvent mouseEvent, List<Component> list) {
        for (Component component : list) {
            if (!(component instanceof HotRegion)) continue;
            MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
            MouseListener mouseListener = (MouseListener)((Object)component);
            dragComp = component;
            mouseListener.mousePressed(mouseEvent2);
            break;
        }
    }

    private void sendEventToViewMouseHandler(MouseEvent mouseEvent, List<Component> list) {
        for (Component component : list) {
            IViewMouseHandler iViewMouseHandler;
            MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
            MouseListener mouseListener = (MouseListener)((Object)component);
            if (!(component instanceof IViewMouseHandler) || !(iViewMouseHandler = (IViewMouseHandler)((Object)component)).wantsEvent(mouseEvent2)) continue;
            dragComp = component;
            mouseListener.mousePressed(mouseEvent2);
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2;
        MouseListener mouseListener;
        Object object;
        if (VisDisplay2.isSyncPosUpdateActive()) {
            return;
        }
        if (ModifierKeys.isRMB((MouseEvent)mouseEvent) && mouseEvent.isControlDown() && this.vis.getVisDisplay().getData().getPlugin().getPluginName() != PluginName.DEFAULT) {
            this.showImpaxToolboxPopup(mouseEvent);
        }
        if (ModifierKeys.isRMB((MouseEvent)mouseEvent) && (mouseEvent.getModifiers() & 0xB) == 0 && (acceptRMBClick || this.isShaggyMouse())) {
            if (this.getMouseModeInfo().getPlacedPresentationObject() == null || this.vis.getView().getMouseHandler().roiCreationInProgress()) {
                this.showTraditionalPopupMenu(mouseEvent);
            } else {
                this.getMouseModeInfo().handleEscape();
            }
        }
        if (ModifierKeys.isLMB((MouseEvent)mouseEvent) && this.isSpacePressedOrZoomPanTool(mouseEvent)) {
            HotRegion hotRegion = this.vis.getHRSet().getHR("PAN");
            if (hotRegion != null) {
                hotRegion.mouseReleased(mouseEvent);
                hotRegion.mouseExited(mouseEvent);
                hotRegion.setVisible(true);
            }
            return;
        }
        dragShiftHandler = null;
        if (mouseEvent.isShiftDown() && (ModifierKeys.isLMB((MouseEvent)mouseEvent) || ModifierKeys.isRMB((MouseEvent)mouseEvent))) {
            dragComp = null;
            return;
        }
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        VisMouseEventInfo visMouseEventInfo = this.analyzeEvent(mouseEvent, list);
        if (this.checkLocalizerHandler(mouseEvent, visMouseEventInfo)) {
            return;
        }
        MouseEvent mouseEvent3 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), this.dragStartPt.x + this.dragAbsX, this.dragStartPt.y + this.dragAbsY, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        if (dragComp != null && dragComp != this) {
            object = (MouseListener)((Object)dragComp);
            MouseEvent serializable2 = this.convertMouseEvent(mouseEvent3, dragComp);
            object.mouseReleased(serializable2);
        }
        if (dragComp == this) {
            this.onMouseRelease(mouseEvent3);
        }
        object = this.getComponentsAt(this.dragStartPt);
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (list.contains(component)) continue;
            mouseListener = (MouseListener)((Object)component);
            mouseEvent2 = this.convertMouseEvent(mouseEvent, component, 505);
            mouseListener.mouseExited(mouseEvent2);
        }
        for (Component component : list) {
            if (object.contains(component)) continue;
            mouseListener = (MouseListener)((Object)component);
            mouseEvent2 = this.convertMouseEvent(mouseEvent, component, 504);
            mouseListener.mouseEntered(mouseEvent2);
        }
        dragComp = null;
    }

    private boolean isShaggyMouse() {
        return System.currentTimeMillis() - lastMouseButtonPressedTime <= (long)MAX_TIME_BETWEEN_CLICKS && Math.abs(this.dragAbsX) <= POPUP_DRAG_TOLERANCE && Math.abs(this.dragAbsY) <= POPUP_DRAG_TOLERANCE;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (VisDisplay2.isSyncPosUpdateActive()) {
            return;
        }
        if (ModifierKeys.isMMB((MouseEvent)mouseEvent) && !this.vis.hasData()) {
            if (Config.impaxee.jvision.SEQPANEL.PreviewImagesInMMBContextMenu.get()) {
                DisplaySetSelectionPanel.showAsPopup(mouseEvent, this.vis.getVisDisplay());
            }
            return;
        }
        acceptRMBClick = true;
        List<Component> list = this.getComponentsAt(mouseEvent.getPoint());
        VisMouseEventInfo visMouseEventInfo = this.analyzeEvent(mouseEvent, list);
        if (!visMouseEventInfo.hotRegionImageDirectlyPressed) {
            for (Component component : list) {
                MouseEvent mouseEvent2 = this.convertMouseEvent(mouseEvent, component);
                MouseListener mouseListener = (MouseListener)((Object)component);
                if (component instanceof IViewMouseHandler) {
                    IViewMouseHandler iViewMouseHandler = (IViewMouseHandler)((Object)component);
                    if (!iViewMouseHandler.wantsEvent(mouseEvent2)) continue;
                    mouseListener.mouseClicked(mouseEvent2);
                    return;
                }
                mouseListener.mouseClicked(mouseEvent2);
                return;
            }
        }
    }

    private boolean checkLocalizerHandler(MouseEvent mouseEvent, VisMouseEventInfo visMouseEventInfo) {
        return !visMouseEventInfo.hotRegionImageDirectlyPressed && !visMouseEventInfo.roiPressed && !visMouseEventInfo.priorityROIPressed && this.vis.getView() != null && this.vis.getView().getMouseHandler() != null && this.vis.getView().getMouseHandler().handleLocalizer(mouseEvent);
    }

    public static boolean zoomByMouseWheel(MouseWheelEvent mouseWheelEvent, View view) {
        if (!view.getDisplay().isMouseWheelZoomEnabled()) {
            return false;
        }
        if (view.getVis() != VisData.getLastModified()) {
            return false;
        }
        IMouseModeInfo iMouseModeInfo = view.getVis().getParent().getDisplayPlugin().getMouseModeInfo();
        if (iMouseModeInfo.getSubMode().isMeasurement()) {
            if (zoomWheelMoude == ZoomWheelMode.AUTO && AbstractMouseModeInfo.deactivateMeasurementAfterDrawing) {
                return true;
            }
            if (zoomWheelMoude == ZoomWheelMode.ON) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        Object object;
        Object object2;
        Object object3;
        List<Component> list;
        if (this.vis == null || this.vis.getVisDisplay() == null || mouseWheelEvent.getWheelRotation() == 0) {
            return;
        }
        if (!this.vis.canHandleMouseWheel()) {
            return;
        }
        if (this.isSpacePressedOrZoomPanTool(mouseWheelEvent) || VisMouseHandler.zoomByMouseWheel(mouseWheelEvent, this.vis.getView())) {
            if (!this.vis.getVisDisplay().isMouseWheelZoomEnabled()) {
                return;
            }
            if (VisData.getLastModified() != this.vis.getData()) {
                this.vis.makeTheLastModified();
            }
            if (this.vis.getView().getRenderer().handleMouseWheel(mouseWheelEvent, this.vis.getView())) {
                return;
            }
        }
        if (mouseWheelEvent.isControlDown()) {
            IMouseModeInfo object42;
            list = this.vis.getVisDisplay().getData() != null ? this.vis.getVisDisplay().getData().getDisplayPlugin() : null;
            IMouseModeInfo iMouseModeInfo = object42 = list != null ? list.getMouseModeInfo() : null;
            if (object42 != null && (object3 = object42.getSubMode()) != null && ((MouseSubModes)((Object)object3)).isSegmentation()) {
                return;
            }
        }
        list = this.getComponentsAt(mouseWheelEvent.getPoint());
        for (Component component : list) {
            MouseWheelEvent mouseWheelEvent2 = this.convertMouseEvent(mouseWheelEvent, component);
            if (!(component instanceof IViewMouseHandler) || !(component instanceof MouseWheelListener)) continue;
            object2 = (MouseWheelListener)((Object)component);
            object = (IViewMouseHandler)((Object)component);
            if (!object.wantsEvent(mouseWheelEvent2)) continue;
            object2.mouseWheelMoved(mouseWheelEvent2);
            return;
        }
        MouseWheelEvent mouseWheelEvent3 = (MouseWheelEvent)eventQueue.peekEvent(mouseWheelEvent.getID());
        object3 = this.getMousePosition();
        int n = MOUSE_SCROLL_INVERSION_IMPAX_ES ? -mouseWheelEvent.getWheelRotation() : mouseWheelEvent.getWheelRotation();
        this.vis.getVisDisplay().handleMouseWheelMovement(n, mouseWheelEvent3 == null);
        if (this.vis.getView() instanceof ImgView2 && object3 != null) {
            object2 = (ImgView2)this.vis.getView();
            object = VisData.getLastModified();
            if (object != null && ((VisData)object).getParent() != this.vis.getData().getParent()) {
                TEvent tEvent = new TEvent(55);
                ((ImgView2)object2).handleTEvent(tEvent, ((VisData)object).getParent(), 0);
            }
        }
    }

    private MouseEvent convertMouseEvent(MouseEvent mouseEvent, Component component) {
        MouseEvent mouseEvent2 = mouseEvent;
        if (!(component instanceof IViewMouseHandler)) {
            mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), mouseEvent.getX() - component.getBounds().x, mouseEvent.getY() - component.getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }
        return mouseEvent2;
    }

    private MouseWheelEvent convertMouseEvent(MouseWheelEvent mouseWheelEvent, Component component) {
        MouseWheelEvent mouseWheelEvent2 = mouseWheelEvent;
        mouseWheelEvent2 = component instanceof IViewMouseHandler ? new MouseWheelEvent((Component)mouseWheelEvent.getSource(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()) : new MouseWheelEvent((Component)mouseWheelEvent.getSource(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX() - component.getBounds().x, mouseWheelEvent.getY() - component.getBounds().y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        return mouseWheelEvent2;
    }

    private MouseEvent convertMouseEvent(MouseEvent mouseEvent, Component component, int n) {
        MouseEvent mouseEvent2 = mouseEvent;
        mouseEvent2 = component instanceof IViewMouseHandler ? new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()) : new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - component.getBounds().x, mouseEvent.getY() - component.getBounds().y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        return mouseEvent2;
    }

    public boolean isMagnifierOn() {
        if (this.vis != null && this.vis.getData() != null) {
            return this.vis.getData().isMagnifierOn();
        }
        return false;
    }

    private IMouseModeInfo getMouseModeInfo() {
        if (this.vis != null && this.vis.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo() != null) {
            return this.vis.getVisDisplay().getData().getDisplayPlugin().getMouseModeInfo();
        }
        return null;
    }

    private static class VisMouseEventInfo {
        boolean hotRegionPressed = false;
        boolean hotRegionImageDirectlyPressed = false;
        boolean roiPressed = false;
        boolean priorityROIPressed = false;

        private VisMouseEventInfo() {
        }
    }

    private static enum ZoomWheelMode {
        AUTO,
        ON,
        OFF;

    }
}

