/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.model.enums.ZoomMode;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.toptoolbar.ZoomUtils;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Component;
import java.util.List;

public class ZoomModeNormalDataAction
extends AbstractPDataAction {
    public static final String ID = "ZOOM_NORMAL";

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new ZoomModeNormalAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class ZoomModeNormalAction
    extends AbstractPDataAction.SelectableInnerPAction {
        public ZoomModeNormalAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super("zoom.svg", pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public boolean isSelectedImpl() {
            AreaFitHandler areaFitHandler = this.getZoomHandler();
            if (areaFitHandler == null) {
                return false;
            }
            return areaFitHandler instanceof FullVisualFitHandler;
        }

        private AreaFitHandler getZoomHandler() {
            if (this.provider == null) {
                return null;
            }
            List<VisData> list = this.provider.getVisDatas();
            if (list.isEmpty()) {
                return null;
            }
            Renderer renderer = list.get(0).getView().getRenderer();
            if (renderer instanceof IRDCRenderer) {
                return ((IRDCRenderer)((Object)renderer)).getAreaFitHandler();
            }
            return null;
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("FixedActions.zoom.zoomModeNormal.ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            List<VisDisplay2> list = this.scope != null ? ZoomModeNormalDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (list.size() != 1) {
                return false;
            }
            ZoomUtils.ensureDeactivatedMagnifyingGlass(list.get(0));
            ZoomUtils.setZoomMode(list.get(0), ZoomMode.NORMAL);
            return true;
        }
    }
}

