/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseModeActionProvider;
import com.agfa.pacs.impaxee.mousemodeinfo.MouseSubModes;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.PresentationObject;
import java.awt.Component;

public class ToggleDisplayMarkups
extends SelectablePAction {
    public static final String ID = "TOGGLE_MARKUPS";
    private boolean selected = !PresentationObject.isHideAllROIs();

    public ToggleDisplayMarkups() {
        super("markup_off.svg");
    }

    @Override
    public String getCaption() {
        return Messages.getString("ToggleDisplayMarkups.Caption");
    }

    @Override
    public String getGroupName() {
        return MARKUPS_GROUP;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(77, 8);
    }

    @Override
    public String getToolTipText() {
        if (this.selected) {
            return Messages.getString("ToggleDisplayMarkups.ToolTip.Hide");
        }
        return Messages.getString("ToggleDisplayMarkups.ToolTip.Show");
    }

    @Override
    public boolean perform(Component component) {
        this.notifyActionPerformed();
        this.selected = !this.selected;
        this.onSetVisibilityOfROIs(this.selected);
        this.fireSelectionChanged();
        this.fireContentChanged(false);
        return true;
    }

    private void onSetVisibilityOfROIs(boolean bl) {
        PresentationObject.setHideAllROIs(!bl);
        TEvent tEvent = new TEvent(81);
        TEventDispatch.sendEvent(tEvent, null, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS | TEventDispatch.REGISTERED_LISTENERS);
        JVision2.getMainFrame().getJVisionContentPane().repaint();
        for (MouseSubModes mouseSubModes : MouseModeActionProvider.getUsableEnums()) {
            PAction pAction = PActionRegistry.getAction(MouseModeActionProvider.getIDForMode(mouseSubModes));
            pAction.fireEnabledChanged();
        }
    }
}

