/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.impl.SelectablePAction;
import com.agfa.pacs.impaxee.config.Config;
import com.tiani.config.mappingfonts.model.enums.LevelOfDetail;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.List;

public class ToggleDemographicsAction
extends SelectablePAction {
    public static final String ID = "TOGGLE_DEMOGRAPHICS";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getGroupName() {
        return GENERAL_GROUP;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ToggleDemographicsAction.Caption");
    }

    @Override
    public String getToolTipText() {
        if (this.isSelected()) {
            return Messages.getString("ToggleDemographicsAction.ToolTip.Show");
        }
        return Messages.getString("ToggleDemographicsAction.ToolTip.Hide");
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return new KeyShortcut(66, 8);
    }

    @Override
    public boolean perform(Component component) {
        LevelOfDetail levelOfDetail = View.getLevelOfDetailForDemographics();
        if (levelOfDetail == LevelOfDetail.LIMITED || levelOfDetail == LevelOfDetail.ALL) {
            this.setLevelOfDetail(LevelOfDetail.NONE);
        } else {
            this.setLevelOfDetail(LevelOfDetail.ALL);
        }
        return true;
    }

    @Override
    public boolean isSelected() {
        return View.getLevelOfDetailForDemographics() == LevelOfDetail.NONE;
    }

    private void setLevelOfDetail(LevelOfDetail levelOfDetail) {
        View.setLevelOfDetailForDemographics(levelOfDetail);
        Config.impaxee.jvision.MAPPING.LevelOfDetail.set(levelOfDetail.name());
        List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
        for (VisData object2 : list) {
            object2.getView().updateMapping(true);
        }
        TEvent tEvent = new TEvent(81);
        TEventDispatch.sendEvent(tEvent, null, TEventDispatch.ALL_DISPLAYS | TEventDispatch.ALL_VISUALS);
    }
}

