/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisDisplayData;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Component;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SynchronizeDataAction
extends AbstractPDataAction {
    public static final String ID = "SYNCHRONIZE";
    private static final ALogger log = ALogger.getLogger(SynchronizeDataAction.class);

    @Override
    protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
        return new SynchronizeAction(pDataScope, pDataProvider);
    }

    @Override
    public PDataScope[] getAvailableScopes() {
        return new PDataScope[]{PDataScope.CurrentDisplay, PDataScope.AllDisplayed};
    }

    @Override
    public String getID() {
        return ID;
    }

    private class SynchronizeAction
    extends AbstractPDataAction.SelectableInnerPAction {
        public SynchronizeAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope != PDataScope.AllDisplayed ? "synchronize.svg" : null, pDataScope, pDataProvider);
        }

        @Override
        public String getCaption() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("ACTION_SYNCHRONIZE_ALL");
            }
            return Messages.getString("CustomActions2.selectForSynchronization.ToolTip");
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            if (this.scope == PDataScope.AllDisplayed) {
                return new KeyShortcut(83, 2);
            }
            if (this.scope == PDataScope.CurrentDisplay) {
                return new KeyShortcut(83, 8);
            }
            return null;
        }

        @Override
        public boolean isSelectedImpl() {
            return this.provider.getVisDisplays().get(0).getData().isSynchronized();
        }

        @Override
        public String getToolTipText() {
            if (this.scope == PDataScope.AllDisplayed) {
                return Messages.getString("ACTION_SYNCHRONIZE_ALL_DESCRIPTION");
            }
            return Messages.getString("CustomActions2.selectForSynchronization.ToolTip");
        }

        @Override
        public boolean isEnabled(VisData visData) {
            return this.isEnabled();
        }

        @Override
        public boolean perform(Component component) {
            List<VisDisplay2> list = null;
            if (this.provider != null) {
                list = this.provider.getVisDisplays();
            } else if (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get() && component instanceof Vis2) {
                list = SynchronizeDataAction.getVisDisplaysBasedOnMousePosition();
                if (list == null) {
                    return false;
                }
            } else {
                list = SynchronizeDataAction.getVisDisplays(this.scope);
            }
            this.notifyActionPerformed();
            boolean bl = false;
            for (VisDisplay2 visDisplay2 : list) {
                if (!visDisplay2.hasData() || !visDisplay2.getData().isSynchronized()) continue;
                bl = true;
                break;
            }
            boolean bl2 = bl = !bl;
            if (list.size() == 1 && Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get()) {
                VisDisplayData visDisplayData = list.get(0).getData();
                IPatientRepresentation iPatientRepresentation = visDisplayData.getPatientRepresentation();
                if (bl) {
                    VisDisplayData visDisplayData2 = VisData.getLastModified().getParent();
                    if (visDisplayData.useLocationInformation() && visDisplayData2.useLocationInformation() && visDisplayData2.isSynchronized()) {
                        IImageInformation iImageInformation = visDisplayData.getFirstVis().getImageInformation();
                        String string = iImageInformation.getFrameOfReferenceUID();
                        String string2 = visDisplayData2.getFirstVis().getImageInformation().getFrameOfReferenceUID();
                        if (VisDisplayData.hasSameOrientation(iImageInformation, visDisplayData2.getFirstVis().getImageInformation()) && string != null && string2 != null && !string.equals(string2)) {
                            Vector3d vector3d = this.calculateShift(visDisplayData, visDisplayData2);
                            iPatientRepresentation.addLinkageInformation(visDisplayData.getDisplaySet(), visDisplayData2.getDisplaySet(), vector3d);
                            this.syncAll();
                            return true;
                        }
                    }
                } else {
                    iPatientRepresentation.removeLinkageInformation(visDisplayData.getDisplaySet());
                    this.syncAll();
                    return true;
                }
            }
            if (Config.impaxee.jvision.SYNCHRONIZE.AutoSync.get()) {
                log.info("Manual override atuomatic synchronisation");
                Config.impaxee.jvision.SYNCHRONIZE.AutoSync.set(false);
            }
            Double d = VisDisplayData.getDistanceToSyncPos();
            for (VisDisplay2 visDisplay2 : list) {
                if (d == null || !bl) {
                    visDisplay2.setSynchronized(bl);
                    continue;
                }
                int n = -1;
                double d2 = visDisplay2.getData().getDisplaySet().getRelativeSliceLocation(visDisplay2.getNavigPos());
                double d3 = Double.MAX_VALUE;
                IDisplaySet iDisplaySet = visDisplay2.getData().getDisplaySet();
                int n2 = 0;
                while (n2 < iDisplaySet.getFrameCount()) {
                    double d4 = d2 - iDisplaySet.getRelativeSliceLocation(n2);
                    if (Math.abs(d - d4) < d3) {
                        d3 = Math.abs(d - d4);
                        n = n2;
                    }
                    ++n2;
                }
                if (n != -1) {
                    visDisplay2.setSynchronized(bl, visDisplay2.getVis(n));
                    continue;
                }
                visDisplay2.setSynchronized(bl);
            }
            return true;
        }

        private void syncAll() {
            VisDisplayData visDisplayData = VisData.getLastModified().getParent();
            VisData.getLastModified().getParent().synchronizeWithOthers();
            List<VisScreen2> list = JVision2.getMainFrame().getScreens();
            for (VisScreen2 visScreen2 : list) {
                for (VisDisplay2 visDisplay2 : visScreen2.getSynchronizedDisplays()) {
                    if (visDisplay2 == visDisplayData.getVisDisplay()) continue;
                    visDisplay2.getData().synchronizeWithCurrentSyncPosition();
                }
            }
        }

        private Vector3d getSliceMidleLocation(IImageInformation iImageInformation) {
            Vector3d vector3d = iImageInformation.getVectorOrigin();
            Vector3d vector3d2 = iImageInformation.getScaledSizedVectorU();
            Vector3d vector3d3 = iImageInformation.getScaledSizedVectorV();
            if (vector3d == null || vector3d2 == null || vector3d3 == null) {
                return null;
            }
            Vector3d vector3d4 = new Vector3d(vector3d2);
            vector3d4.scale(0.5);
            Vector3d vector3d5 = new Vector3d(vector3d3);
            vector3d5.scale(0.5);
            vector3d.add((Tuple3d)vector3d4);
            vector3d.add((Tuple3d)vector3d5);
            return vector3d;
        }

        private Vector3d calculateShift(VisDisplayData visDisplayData, VisDisplayData visDisplayData2) {
            int n = visDisplayData.getVisDisplay().getNavigPos();
            int n2 = visDisplayData2.getVisDisplay().getNavigPos();
            VisData visData = visDisplayData.getVis(n);
            VisData visData2 = visDisplayData2.getVis(n2);
            Vector3d vector3d = this.getSliceMidleLocation(visData.getImageInformation());
            Vector3d vector3d2 = this.getSliceMidleLocation(visData2.getImageInformation());
            vector3d.sub((Tuple3d)vector3d2);
            return vector3d;
        }
    }
}

