/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.tiani.jvision.vis.VisDisplayData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3d;

public class StudyLinkageInfo {
    private Map<String, List<Linkage>> linkedFrameOfReference = new HashMap<String, List<Linkage>>(5);

    public static String getFrameOfReference(IDisplaySet iDisplaySet) {
        return iDisplaySet.getFrameOfReferenceUID();
    }

    private static Vector3d getOrientation(IDisplaySet iDisplaySet) {
        return iDisplaySet.getOneObject().getImageInformation().getPlaneNormalUV();
    }

    public synchronized void addLinkage(IDisplaySet iDisplaySet, Vector3d vector3d) {
        String string = StudyLinkageInfo.getFrameOfReference(iDisplaySet);
        List<Linkage> list = this.linkedFrameOfReference.get(string);
        Linkage linkage = new Linkage(vector3d, StudyLinkageInfo.getOrientation(iDisplaySet));
        if (list == null) {
            list = new ArrayList<Linkage>();
            this.linkedFrameOfReference.put(string, list);
        }
        list.remove(linkage);
        list.add(linkage);
    }

    public synchronized Vector3d getLinked(IDisplaySet iDisplaySet) {
        List<Linkage> list = this.linkedFrameOfReference.get(StudyLinkageInfo.getFrameOfReference(iDisplaySet));
        if (list == null) {
            return null;
        }
        Vector3d vector3d = StudyLinkageInfo.getOrientation(iDisplaySet);
        for (Linkage linkage : list) {
            if (!VisDisplayData.equalsOrientation(linkage.normal, vector3d)) continue;
            return linkage.shift;
        }
        return null;
    }

    public synchronized List<String> removeLinkage(IDisplaySet iDisplaySet) {
        Vector3d vector3d = StudyLinkageInfo.getOrientation(iDisplaySet);
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (Map.Entry<String, List<Linkage>> entry : this.linkedFrameOfReference.entrySet()) {
            Iterator<Linkage> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                if (!VisDisplayData.equalsOrientation(iterator.next().normal, vector3d)) continue;
                iterator.remove();
                arrayList.add(entry.getKey());
                continue block0;
            }
        }
        return arrayList;
    }

    private static class Linkage {
        public final Vector3d shift;
        public final Vector3d normal;

        public Linkage(Vector3d vector3d, Vector3d vector3d2) {
            this.shift = vector3d;
            this.normal = vector3d2;
        }

        public int hashCode() {
            return this.normal.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Linkage) {
                return VisDisplayData.equalsOrientation(((Linkage)object).normal, this.normal);
            }
            return false;
        }
    }
}

