/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.FixTextPAction;
import com.agfa.pacs.impaxee.actions.impl.FlatCompoundAbstractPAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SeriesNavigationProvider
implements PActionProvider {
    private static final ALogger LOG = ALogger.getLogger(SeriesNavigationProvider.class);
    public static final String NEXT_SERIE = "NEXT_SERIE";
    public static final String PREVIOUS_SERIE = "PREVIOUS_SERIE";
    private static final String SERIES_NAVIGATION = "SERIES_NAVIGATION";
    private NextSeriesAction next = new NextSeriesAction();
    private PreviousSeriesAction previous = new PreviousSeriesAction();
    private static String lastUsedStudy = null;
    private static List<WeakReference<VisDisplay2>> emptyDisplays;

    private static void addEmptyDisplays(String string, List<VisDisplay2> list) {
        if (CompareUtils.equals((Object)lastUsedStudy, (Object)string)) {
            List<VisDisplay2> list2 = JVision2.getMainFrame().getDisplays();
            for (WeakReference<VisDisplay2> weakReference : emptyDisplays) {
                VisDisplay2 visDisplay2 = (VisDisplay2)weakReference.get();
                if (visDisplay2 == null || !list2.contains(visDisplay2) || visDisplay2.hasData()) continue;
                list.add(visDisplay2);
            }
        } else {
            emptyDisplays = Collections.emptyList();
        }
    }

    private static boolean switchAllDisplays(boolean bl) {
        Object object;
        ISplitAndSortRuntime iSplitAndSortRuntime = DataSelectionManager.getInstance().getActiveHanging().getSplitAndSortRuntime();
        String string = null;
        VisDisplay2 visDisplay2 = null;
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            object = DataSelectionManager.getInstance().getActiveHanging();
            if (object == null) {
                return false;
            }
            string = object.getStudyContainer().getBaseStudy().getKey();
        } else {
            string = visData.getStudyData().getKey();
            visDisplay2 = visData.getParent().getVisDisplay();
        }
        object = JVision2.getMainFrame().getFilledDisplays();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            VisDisplay2 visDisplay22 = (VisDisplay2)iterator.next();
            if (visDisplay22.getData().getDisplaySet().getStudyUID().equals(string)) continue;
            iterator.remove();
        }
        int n = iSplitAndSortRuntime.getDisplaySetPosition(((VisDisplay2)object.get(bl ? object.size() - 1 : 0)).getData().getDisplaySet());
        SeriesNavigationProvider.addEmptyDisplays(string, (List<VisDisplay2>)object);
        if (n < 0) {
            return false;
        }
        List<IDisplaySet> list = SeriesNavigationProvider.getNextDisplaySets(bl, n, iSplitAndSortRuntime, object.size(), string);
        if (list.isEmpty()) {
            return false;
        }
        VisData.blockLastModifiedChange(true);
        try {
            lastUsedStudy = string;
            emptyDisplays = new ArrayList<WeakReference<VisDisplay2>>();
            int n2 = 0;
            while (n2 < object.size()) {
                VisDisplay2 visDisplay23 = (VisDisplay2)object.get(n2);
                if (n2 < list.size()) {
                    IDisplaySet iDisplaySet = list.get(n2);
                    if (visDisplay23.getData().getDisplayPlugin().isLayerable()) {
                        visDisplay23.clear(false, false);
                    }
                    visDisplay23.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
                } else {
                    emptyDisplays.add(new WeakReference<VisDisplay2>(visDisplay23));
                    visDisplay23.clear(false, false);
                    visDisplay23.resetType();
                    visDisplay23.resetFilter();
                }
                ++n2;
            }
        }
        finally {
            VisData.blockLastModifiedChange(false);
            if (visDisplay2 != null && visDisplay2.getVis(0) != null) {
                visDisplay2.getVis(0).makeTheLastModified();
            }
        }
        return true;
    }

    private static List<IDisplaySet> getNextDisplaySets(boolean bl, Integer n, ISplitAndSortRuntime iSplitAndSortRuntime, int n2, String string) {
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>(n2);
        int n3 = n;
        int n4 = iSplitAndSortRuntime.getDisplaySetCount();
        while (arrayList.size() < n2) {
            if ((n3 += bl ? 1 : -1) < 0 || n3 >= n4) {
                if (!Config.impaxee.jvision.SEQPANEL.DoWrapOnNextSeqEnd.get()) {
                    if (arrayList.size() > 0) break;
                    String string2 = bl ? Messages.getString("SEQPANEL_NO_NEXT_SEQ") : Messages.getString("SEQPANEL_NO_PREV_SEQ");
                    int n5 = Message.yesNo(Messages.getString("QUESTION"), string2);
                    if (n5 != 0) break;
                }
                int n6 = n3 = bl ? 0 : n4 - 1;
            }
            if (iSplitAndSortRuntime.getDisplaySetAt(n3).getStudyUID().equals(string)) {
                arrayList.add(iSplitAndSortRuntime.getDisplaySetAt(n3));
            }
            if (n3 == n || arrayList.size() == iSplitAndSortRuntime.getDisplaySetCount()) break;
        }
        if (!bl) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    private static boolean nextSeries(boolean bl) {
        boolean bl2 = Config.impaxee.jvision.SEQPANEL.NextSeqIntoLastMod.get();
        if (bl2) {
            VisData visData = VisData.getLastModified();
            VisDisplay2 visDisplay2 = null;
            if (visData != null) {
                IDisplaySet iDisplaySet;
                visDisplay2 = visData.getParent().getVisDisplay();
                if (visDisplay2.getVisScreen() == null) {
                    LOG.warn("Next Displayset, not available on floating window.");
                    return false;
                }
                boolean bl3 = Config.impaxee.jvision.SEQPANEL.DoWrapOnNextSeqEnd.get();
                IDisplaySet iDisplaySet2 = iDisplaySet = bl ? visDisplay2.displayNextSeries(bl3, true) : visDisplay2.displayPreviousSeries(bl3, true);
                if (iDisplaySet == null && !bl3) {
                    String string = bl ? Messages.getString("SEQPANEL_NO_NEXT_SEQ") : Messages.getString("SEQPANEL_NO_PREV_SEQ");
                    int n = Message.yesNo(Messages.getString("QUESTION"), string);
                    if (n == 0) {
                        if (bl) {
                            visDisplay2.displayNextSeries(true, true);
                        } else {
                            visDisplay2.displayPreviousSeries(true, true);
                        }
                    }
                    return true;
                }
                return false;
            }
            visDisplay2 = JVision2.getMainFrame().getFirstDisplay();
            List<IDisplaySet> list = DataSelectionManager.getInstance().getActiveHanging().getDisplaySets();
            if (list.size() > 0) {
                IDisplaySet iDisplaySet = list.get(0);
                visDisplay2.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
                return true;
            }
            return false;
        }
        return SeriesNavigationProvider.switchAllDisplays(bl);
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new SeriesNavigationAction(this.previous, this.next));
        arrayList.add(this.next);
        arrayList.add(this.previous);
        return arrayList;
    }

    private static class NextSeriesAction
    extends AbstractPAction {
        public NextSeriesAction() {
            super("next_item.svg");
        }

        @Override
        public String getName() {
            return Messages.getString("GeneralActions.nextSerie.Name");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getID() {
            return SeriesNavigationProvider.NEXT_SERIE;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(39, 2);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("GeneralActions.nextSerie.ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            return SeriesNavigationProvider.nextSeries(true);
        }
    }

    private static class PreviousSeriesAction
    extends AbstractPAction {
        public PreviousSeriesAction() {
            super("previous_item.svg");
        }

        @Override
        public String getName() {
            return Messages.getString("GeneralActions.previousSerie.Name");
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return IMAGE_DISPLAY_GROUP;
        }

        @Override
        public String getID() {
            return SeriesNavigationProvider.PREVIOUS_SERIE;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(37, 2);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("GeneralActions.previousSerie.ToolTip");
        }

        @Override
        public boolean perform(Component component) {
            return SeriesNavigationProvider.nextSeries(false);
        }
    }

    private static class SeriesNavigationAction
    extends FlatCompoundAbstractPAction {
        public SeriesNavigationAction(PAction pAction, PAction pAction2) {
            super(new PAction[]{pAction, new FixTextPAction(Messages.getString("GeneralActions.scrollSeries.Text")), pAction2});
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return SeriesNavigationProvider.SERIES_NAVIGATION;
        }

        @Override
        public String getCaption() {
            return Messages.getString("GeneralActions.SeriesNavigation.ToolTip");
        }
    }
}

