/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.tiani.jvision.overlay.MagnifierOverlay;
import com.tiani.jvision.toptoolbar.MagnifierAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class MagnifierZoomActions
implements PActionProvider {
    public static final String ID_PLUS = "MAGNIFIER_PLUS";
    public static final String ID_MINUS = "MAGNIFIER_MINUS";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new MagnifierZoomPlus());
        arrayList.add(new MagnifierZoomMinus());
        return arrayList;
    }

    private static class MagnifierZoomMinus
    extends AbstractPAction {
        private MagnifierZoomMinus() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAGNIFY_GLASS_ZOOM_OUT_DIV_2");
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getID() {
            return MagnifierZoomActions.ID_MINUS;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(109);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAGNIFY_GLASS_ZOOM_OUT_DIV_2_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MagnifierOverlay magnifierOverlay = MagnifierAction.getActiveMagnifier();
            if (magnifierOverlay != null) {
                int n = magnifierOverlay.getZoomFactor();
                if (n > 1) {
                    n /= 2;
                }
                magnifierOverlay.setZoomFactor(n);
                magnifierOverlay.getView().repaint();
            }
            return true;
        }
    }

    private static class MagnifierZoomPlus
    extends AbstractPAction {
        private MagnifierZoomPlus() {
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAGNIFY_GLASS_ZOOM_IN_X_2");
        }

        @Override
        public String getGroupName() {
            return MARKUPS_GROUP;
        }

        @Override
        public String getID() {
            return MagnifierZoomActions.ID_PLUS;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(107);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAGNIFY_GLASS_ZOOM_IN_X_2_DESCRIPTION");
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            MagnifierOverlay magnifierOverlay = MagnifierAction.getActiveMagnifier();
            if (magnifierOverlay != null) {
                int n = magnifierOverlay.getZoomFactor();
                if (n < 8) {
                    n *= 2;
                }
                magnifierOverlay.setZoomFactor(n);
                magnifierOverlay.getView().repaint();
            }
            return true;
        }
    }
}

