/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.ConfigValueAbstractPAction;
import com.agfa.pacs.impaxee.config.Config;
import java.util.ArrayList;
import java.util.List;

public class LoopModeActionProvider
implements PActionProvider {
    private static final String ID_PREFIX = "LOOP_MODE_";

    public static String getIDForMode(LoopMode loopMode) {
        return ID_PREFIX + loopMode.name();
    }

    public static LoopMode getCurrentLoopMode() {
        return LoopMode.valueOf(Config.impaxee.jvision.NAVIGATION.Modus.get());
    }

    public static void setCurrentLoopMode(LoopMode loopMode) {
        Config.impaxee.jvision.NAVIGATION.Modus.set(loopMode.name());
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        if (!Product.isReducedVersion()) {
            LoopMode[] loopModeArray = LoopMode.values();
            int n = loopModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LoopMode loopMode = loopModeArray[n2];
                arrayList.add(new LoopModeAction(loopMode));
                ++n2;
            }
        }
        return arrayList;
    }

    private String getIconImpl(LoopMode loopMode) {
        return "navigation_" + loopMode.name() + ".svg";
    }

    public static enum LoopMode {
        STOP,
        NEXT,
        LOOP;

    }

    private class LoopModeAction
    extends ConfigValueAbstractPAction {
        private LoopMode mode;

        public LoopModeAction(LoopMode loopMode) {
            super(Config.impaxee.jvision.NAVIGATION.Modus.getKey(), loopMode.name(), LoopModeActionProvider.this.getIconImpl(loopMode));
            this.mode = loopMode;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getName() {
            return Messages.getString("FixedActions.seriesNavigation." + this.mode.name() + ".Name");
        }

        @Override
        public String getGroupName() {
            return GENERAL_GROUP;
        }

        @Override
        public String getID() {
            return LoopModeActionProvider.getIDForMode(this.mode);
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("FixedActions.seriesNavigation." + this.mode.name() + ".ToolTip");
        }
    }
}

