/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class FilmLayoutActionProvider
implements PActionProvider {
    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        int n = 1;
        while (n <= 8) {
            arrayList.add(new FilmLayoutAction(n));
            ++n;
        }
        return arrayList;
    }

    static String getTypeString(int n) {
        return String.valueOf(Integer.toString(n)) + "x" + Integer.toString(n);
    }

    public static String getActionIDForCount(int n) {
        return "FILM_LAYOUT_" + Integer.toString(n);
    }

    private static class FilmLayoutAction
    extends AbstractPAction {
        private int count;

        public FilmLayoutAction(int n) {
            this.count = n;
        }

        @Override
        public String getCaption() {
            return this.getToolTipText();
        }

        @Override
        public String getGroupName() {
            return LAYOUT_GROUP;
        }

        @Override
        public boolean isAvailable() {
            return this.count == 1;
        }

        @Override
        protected boolean isEnabledImpl() {
            return JVision2.getMainFrame().getLytMode() == MainLayoutType.film;
        }

        @Override
        public String getID() {
            return FilmLayoutActionProvider.getActionIDForCount(this.count);
        }

        @Override
        public String getToolTipText() {
            return MessageFormat.format(Messages.getString("CustomActions1.screenLayoutFilm.screenLayoutFilm.ToolTip"), FilmLayoutActionProvider.getTypeString(this.count));
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            VisScreen2 visScreen2 = JVision2.getMainFrame().getScreens().get(0);
            visScreen2.setLytMode(visScreen2.getLytMode(), this.count, this.count, true);
            JVision2.getMainFrame().updateLytHRs();
            return true;
        }
    }
}

