/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataActionProvider;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.toptoolbar.DisplayLayoutChooserDataAction;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import com.tiani.jvision.vis.layout.LytDisplay;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class DisplayLayoutDataActionProvider
implements PDataActionProvider {
    private static final ALogger log = ALogger.getLogger(DisplayLayoutDataActionProvider.class);

    public static DISPLAY_LAYOUT getLayoutFromLyt(int n, int n2) {
        if (n == 1) {
            if (n2 == 1) {
                return DISPLAY_LAYOUT.LAYOUT_1x1;
            }
            return DISPLAY_LAYOUT.LAYOUT_1x2;
        }
        if (n == 2) {
            if (n2 == 1) {
                return DISPLAY_LAYOUT.LAYOUT_2x1;
            }
            if (n2 == 2) {
                return DISPLAY_LAYOUT.LAYOUT_2x2;
            }
            return DISPLAY_LAYOUT.LAYOUT_2x3;
        }
        if (n == 3) {
            if (n2 == 2) {
                return DISPLAY_LAYOUT.LAYOUT_3x2;
            }
            return DISPLAY_LAYOUT.LAYOUT_3x3;
        }
        if (n == 4) {
            return DISPLAY_LAYOUT.LAYOUT_4x4;
        }
        return DISPLAY_LAYOUT.LAYOUT_8x8;
    }

    @Override
    public List<PDataAction> getDataActions() {
        ArrayList<PDataAction> arrayList = new ArrayList<PDataAction>();
        DISPLAY_LAYOUT[] dISPLAY_LAYOUTArray = DISPLAY_LAYOUT.values();
        int n = dISPLAY_LAYOUTArray.length;
        int n2 = 0;
        while (n2 < n) {
            DISPLAY_LAYOUT dISPLAY_LAYOUT = dISPLAY_LAYOUTArray[n2];
            arrayList.add(new DisplayLayoutDataAction(dISPLAY_LAYOUT));
            ++n2;
        }
        return arrayList;
    }

    public static enum DISPLAY_LAYOUT {
        LAYOUT_1x1,
        LAYOUT_1x2,
        LAYOUT_2x1,
        LAYOUT_2x2,
        LAYOUT_2x3,
        LAYOUT_3x2,
        LAYOUT_3x3,
        LAYOUT_4x4,
        LAYOUT_8x8;


        public String getLayoutString() {
            return this.name().replace("LAYOUT_", "");
        }

        public String getActionID() {
            return "DISPLAY_" + this.name();
        }

        public int[] getDimensions() {
            String string = this.getLayoutString();
            int[] nArray = new int[]{Integer.parseInt(string.substring(0, 1)), Integer.parseInt(string.substring(2, 3))};
            return nArray;
        }
    }

    private static class DisplayLayoutDataAction
    extends AbstractPDataAction {
        final DISPLAY_LAYOUT type;

        public DisplayLayoutDataAction(DISPLAY_LAYOUT dISPLAY_LAYOUT) {
            super(true);
            this.type = dISPLAY_LAYOUT;
            this.init();
        }

        @Override
        protected PAction createDataAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            return new DisplayLayoutAction(pDataScope, pDataProvider);
        }

        @Override
        public PDataScope[] getAvailableScopes() {
            return new PDataScope[]{PDataScope.CurrentDisplay};
        }

        @Override
        public String getID() {
            return this.type.getActionID();
        }

        String getIconName() {
            String string = this.type == DISPLAY_LAYOUT.LAYOUT_8x8 ? ".gif" : ".svg";
            return "icon_display_layout_" + this.type.getLayoutString() + string;
        }

        private class DisplayLayoutAction
        extends AbstractPDataAction.SelectableInnerPAction {
            public DisplayLayoutAction(PDataScope pDataScope, PDataProvider pDataProvider) {
                super(DisplayLayoutDataAction.this.getIconName(), pDataScope, pDataProvider);
            }

            @Override
            public String getGroupName() {
                return LAYOUT_GROUP;
            }

            @Override
            public boolean isSelectedImpl() {
                VisDisplay2 visDisplay2 = this.getMyDisplay();
                LytDisplay lytDisplay = visDisplay2.getLyt();
                if (lytDisplay == null) {
                    return false;
                }
                DISPLAY_LAYOUT dISPLAY_LAYOUT = DisplayLayoutDataActionProvider.getLayoutFromLyt(lytDisplay.getCols(), lytDisplay.getRows());
                return dISPLAY_LAYOUT == DisplayLayoutDataAction.this.type;
            }

            private VisDisplay2 getMyDisplay() {
                List<VisDisplay2> list = this.scope != null ? DisplayLayoutDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
                if (list.isEmpty()) {
                    return null;
                }
                return list.get(0);
            }

            @Override
            protected boolean isEnabledImpl() {
                return JVision2.getMainFrame().getLytMode() == MainLayoutType.variable;
            }

            @Override
            public String getCaption() {
                return MessageFormat.format(Messages.getString("CustomActions1.displayLayout.displayLayout.Caption"), DisplayLayoutDataAction.this.type.getLayoutString());
            }

            @Override
            public String getToolTipText() {
                return MessageFormat.format(Messages.getString("CustomActions1.displayLayout.displayLayout.ToolTip"), DisplayLayoutDataAction.this.type.getLayoutString());
            }

            @Override
            public boolean perform(Component component) {
                Object object;
                if (this.isSelectable() && this.isSelected()) {
                    this.forcedSelectionChanged();
                    return false;
                }
                this.notifyActionPerformed();
                int[] nArray = DisplayLayoutDataAction.this.type.getDimensions();
                VisDisplay2 visDisplay2 = this.getMyDisplay();
                if (visDisplay2 == null) {
                    return false;
                }
                if (visDisplay2.getData().isSynchronized()) {
                    object = JVision2.getMainFrame();
                    ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
                    for (VisScreen2 multiMonitorComponent : ((MainFrame2)object).getScreens()) {
                        arrayList.addAll(multiMonitorComponent.getSynchronizedDisplays());
                    }
                    for (VisDisplay2 visDisplay22 : arrayList) {
                        visDisplay22.setLytMode(visDisplay22.getLyt(), nArray[0], nArray[1], true, false);
                        visDisplay22.getLyt().clearSavedStateLyt();
                        visDisplay22.repaint();
                    }
                } else {
                    visDisplay2.setLytMode(visDisplay2.getLyt(), nArray[0], nArray[1], true, false);
                    visDisplay2.repaint();
                }
                try {
                    object = PActionRegistry.getDataAction("DISPLAY_LAYOUT_CHOOSER", visDisplay2);
                    if (object instanceof DisplayLayoutChooserDataAction.DisplayLayoutChooserAction) {
                        ((DisplayLayoutChooserDataAction.DisplayLayoutChooserAction)object).updateComponent();
                    }
                }
                catch (Exception exception) {
                    log.error(null, (Throwable)exception);
                }
                return true;
            }
        }
    }
}

