/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.toptoolbar;

import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.integration.ext.ISimpleActor;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.tiani.jvision.toptoolbar.OpenTextAreaAction;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class AnaPlusActions
implements PActionProvider {
    private static ISimpleActor anaActor;
    private static String ID_BASE;

    static {
        ID_BASE = "ANA_PLUS_";
    }

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        if (this.isAnaPlusRunning()) {
            arrayList.add(new AnaPlusAction("U"));
            arrayList.add(new AnaPlusAction("B"));
            arrayList.add(new AnaPlusAction("A"));
        }
        return arrayList;
    }

    private boolean isAnaPlusRunning() {
        String string;
        return IntegrationFrameworkFactory.getInstance().isActorRunning("MEDOS") && (string = (anaActor = IntegrationFrameworkFactory.getInstance().getSimpleActorByName("MEDOS")).getProperty("system")) != null && string.equalsIgnoreCase("ana+");
    }

    private static class AnaPlusAction
    extends AbstractPAction {
        private final String code;

        public AnaPlusAction(String string) {
            super("AnaPlus" + string + ".svg");
            this.code = string;
        }

        @Override
        public String getID() {
            return String.valueOf(ID_BASE) + this.code;
        }

        @Override
        public String getGroupName() {
            return PAction.WORKFLOW_HANDLING_GROUP;
        }

        @Override
        public String getCaption() {
            return String.valueOf('<') + this.code + '>';
        }

        @Override
        public String getName() {
            return String.valueOf(Messages.getString("AnaPlusActions_AnaAction")) + ' ' + this.getCaption();
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean perform(Component component) {
            VisData visData = VisData.getLastModified();
            if (visData == null) {
                return false;
            }
            this.notifyActionPerformed();
            OpenTextAreaAction.sendStartReportEvent(this.code, visData.getImageInformation());
            return true;
        }
    }
}

