/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.tf.function;

import com.tiani.jvision.tf.function.ControlHandle;
import com.tiani.jvision.tf.function.LutFunction;
import com.tiani.jvision.tf.function.TransferFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class RgbFunction
extends TransferFunction
implements Serializable {
    private LutFunction red;
    private LutFunction green;
    private LutFunction blue;

    public RgbFunction(int[][] nArray, String string, String string2) {
        super(string, string2);
        this.red = new LutFunction(nArray, string, 4, string2);
        this.green = new LutFunction(nArray, string, 2, string2);
        this.blue = new LutFunction(nArray, string, 1, string2);
        this.recalcLut();
    }

    public RgbFunction(int n, int n2, String string, String string2) {
        super(string, string2);
        this.red = new LutFunction(n, n2, string, 4, string2);
        this.green = new LutFunction(n, n2, string, 2, string2);
        this.blue = new LutFunction(n, n2, string, 1, string2);
        this.recalcLut();
    }

    public RgbFunction(String string, String string2) {
        super(string, string2);
        this.red = new LutFunction(string, 4, string2);
        this.green = new LutFunction(string, 2, string2);
        this.blue = new LutFunction(string, 1, string2);
        this.recalcLut();
    }

    @Override
    protected RgbFunction cloneImpl() {
        RgbFunction rgbFunction = new RgbFunction(this.unit, this.description);
        rgbFunction.red = (LutFunction)this.red.clone();
        rgbFunction.green = (LutFunction)this.green.clone();
        rgbFunction.blue = (LutFunction)this.blue.clone();
        return rgbFunction;
    }

    @Override
    public int[] recalcLut() {
        int n;
        int n2;
        int n3;
        int[] nArray = this.red.getArgbLut();
        int[] nArray2 = this.green.getArgbLut();
        int[] nArray3 = this.blue.getArgbLut();
        int n4 = this.red.getOffset();
        int n5 = this.green.getOffset();
        int n6 = this.blue.getOffset();
        this.offset = Math.min(n4, Math.min(n5, n6));
        int n7 = Math.max(nArray.length + n4 - this.offset, Math.max(nArray2.length + n5 - this.offset, nArray3.length + n6 - this.offset));
        int[] nArray4 = this.createLUTArray(n7);
        if (this.isApplied()) {
            n3 = 0;
            n2 = this.offset;
            while (n3 < n7) {
                n = 0;
                int n8 = 0;
                int n9 = 0;
                n = n2 - n4 >= nArray.length ? nArray[nArray.length - 1] : (n2 < n4 ? nArray[0] : nArray[n2 - n4]);
                n8 = n2 - n5 >= nArray2.length ? nArray2[nArray2.length - 1] : (n2 < n5 ? nArray2[0] : nArray2[n2 - n5]);
                n9 = n2 - n6 >= nArray3.length ? nArray3[nArray3.length - 1] : (n2 < n6 ? nArray3[0] : nArray3[n2 - n6]);
                nArray4[n3] = n | n8 | n9;
                ++n3;
                ++n2;
            }
        } else {
            n3 = this.getMinPosition(7);
            n2 = this.getMaxPosition(7);
            n = n2 - n3;
            double d = 0.0;
            double d2 = 255.0 / (double)(n - 1);
            int n10 = 0;
            while (n10 < n) {
                int n11 = (int)(d + 0.5);
                nArray4[n10] = n11 << 16 | n11 << 8 | n11;
                ++n10;
                d += d2;
            }
            n10 = n;
            while (n10 < n7) {
                nArray4[n10] = nArray4[n - 1];
                ++n10;
            }
        }
        n3 = n7;
        while (n3 < nArray4.length) {
            nArray4[n3] = nArray4[n7 - 1];
            ++n3;
        }
        return nArray4;
    }

    @Override
    public Collection<ControlHandle> getHandles(int n) {
        Vector<ControlHandle> vector = new Vector<ControlHandle>();
        if ((n & 4) != 0) {
            vector.addAll(this.red.getHandles(4));
        }
        if ((n & 2) != 0) {
            vector.addAll(this.green.getHandles(2));
        }
        if ((n & 1) != 0) {
            vector.addAll(this.blue.getHandles(1));
        }
        return vector;
    }

    @Override
    public void addHandle(int n, int n2, int n3) {
        if ((n3 & 4) != 0) {
            this.red.addHandle(n, n2 >>> SHIFT[4] & 0xFF, 4);
        }
        if ((n3 & 2) != 0) {
            this.green.addHandle(n, n2 >>> SHIFT[2] & 0xFF, 2);
        }
        if ((n3 & 1) != 0) {
            this.blue.addHandle(n, n2 >>> SHIFT[1] & 0xFF, 1);
        }
    }

    @Override
    public void removeHandle(int n, int n2) {
        if ((n2 & 4) != 0) {
            this.red.removeHandle(n, 4);
        }
        if ((n2 & 2) != 0) {
            this.green.removeHandle(n, 2);
        }
        if ((n2 & 1) != 0) {
            this.blue.removeHandle(n, 1);
        }
    }

    @Override
    public void setApplied(boolean bl) {
        super.setApplied(bl);
        this.red.setApplied(bl);
        this.green.setApplied(bl);
        this.blue.setApplied(bl);
    }

    @Override
    public void setFlipped(boolean bl) {
        super.setFlipped(bl);
        this.red.setFlipped(bl);
        this.green.setFlipped(bl);
        this.blue.setFlipped(bl);
    }
}

