/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IRegionInfoSource;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.TransferFunction;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.image.fithandler.ViewportDefinition;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.IOverlayOwner;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.renderer.RendererSyncData;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.util.TicketOffice;
import com.tiani.util.expressions.IEvaluablePrivateData;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Renderer
implements Cloneable,
IEvaluablePrivateData,
IOverlayOwner {
    protected static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    private static final ALogger log = ALogger.getLogger(Renderer.class);
    public static final String DEFAULT_RENDERER_NAME = "Renderer";
    public static final int CONTENT_RGB = 0;
    static final int CONTENT_8 = 1;
    public static final int CONTENT_16 = 2;
    private static final AtomicInteger idCounter = new AtomicInteger();
    private long rgbContentStamp = 0L;
    protected int nodeID = Renderer.getNewNodeID();
    protected boolean invalid = true;
    private int currentWidth;
    private int currentHeight;
    private int currentOffset;
    private int currentLineWidth;
    private int currentSize;
    protected boolean fillBG = true;
    private String nodeName = "Renderer";

    public long getContentStamp(int n) {
        return this.rgbContentStamp;
    }

    public void setContentStamp(long l, int n) {
        this.rgbContentStamp = l;
    }

    protected void doFillBackground(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (n * n2 == nArray.length) {
            return;
        }
        int n6 = n3 > nArray.length ? nArray.length : n3;
        try {
            int n7 = 0;
            while (n7 < n6) {
                nArray[n7] = n5;
                ++n7;
            }
            if (n > 0) {
                int n8 = 0;
                while (n8 < n2 - 1) {
                    n7 += n;
                    int n9 = 0;
                    while (n9 < n4 - n) {
                        nArray[n7++] = n5;
                        ++n9;
                    }
                    ++n8;
                }
                n7 += n;
            }
            while (n7 < nArray.length) {
                nArray[n7] = n5;
                ++n7;
            }
        }
        catch (Exception exception) {
            log.error("Array too small", (Throwable)exception);
        }
    }

    protected void doFillBackground(short[] sArray, int n, int n2, int n3, int n4, short s) {
        if (n * n2 == sArray.length) {
            return;
        }
        int n5 = n3 > sArray.length ? sArray.length : n3;
        int n6 = 0;
        while (n6 < n5) {
            sArray[n6] = s;
            ++n6;
        }
        int n7 = 0;
        while (n7 < n2 - 1) {
            n6 += n;
            int n8 = 0;
            while (n8 < n4 - n) {
                sArray[n6++] = s;
                ++n8;
            }
            ++n7;
        }
        n6 += n;
        while (n6 < sArray.length) {
            sArray[n6] = s;
            ++n6;
        }
    }

    protected void doFillBackground(byte[] byArray, int n, int n2, int n3, int n4, byte by) {
        if (n * n2 == byArray.length) {
            return;
        }
        int n5 = 0;
        while (n5 < n3) {
            byArray[n5] = by;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2 - 1) {
            n5 += n;
            int n7 = 0;
            while (n7 < n4 - n) {
                byArray[n5++] = by;
                ++n7;
            }
            ++n6;
        }
        n5 += n;
        while (n5 < byArray.length) {
            byArray[n5] = by;
            ++n5;
        }
    }

    protected void raw8ToRGB(byte[] byArray, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5, int n6) {
        int n7 = 0;
        while (n7 < n2) {
            int n8 = n3 + n7 * n4;
            int n9 = n5 + n7 * n6;
            int n10 = 0;
            while (n10 < n) {
                nArray2[n9 + n10] = nArray[byArray[n8 + n10] & 0xFF];
                ++n10;
            }
            ++n7;
        }
    }

    protected void raw16ToRGB(short[] sArray, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5, int n6) {
        int n7 = 0;
        while (n7 < n2) {
            int n8 = n3 + n7 * n4;
            int n9 = n5 + n7 * n6;
            int n10 = 0;
            while (n10 < n) {
                nArray2[n9 + n10] = nArray[sArray[n8 + n10] & 0xFFFF];
                ++n10;
            }
            ++n7;
        }
    }

    protected void rawRGBToRGB(int[] nArray, int n, int n2, int n3, int n4, int[] nArray2, int n5, int n6) {
        int n7 = 0;
        while (n7 < n2) {
            int n8 = n3 + n7 * n4;
            int n9 = n5 + n7 * n6;
            int n10 = 0;
            while (n10 < n) {
                nArray2[n9 + n10] = nArray[n8 + n10];
                ++n10;
            }
            ++n7;
        }
    }

    public void setNodeID(int n) {
        this.nodeID = n;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public Renderer getNode(int n) {
        if (this.nodeID == n) {
            return this;
        }
        return null;
    }

    public Renderer getNode(String string) {
        if (string.equals(this.nodeName)) {
            return this;
        }
        return null;
    }

    public static int getNewNodeID() {
        return idCounter.incrementAndGet();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setCacheGeometry(boolean bl, int n, int n2, int n3, int n4, int n5) {
        this.currentWidth = n;
        this.currentHeight = n2;
        this.currentOffset = n3;
        this.currentLineWidth = n4;
        this.currentSize = n5;
    }

    public boolean isCacheGeometryValid(boolean bl, int n, int n2, int n3, int n4, int n5) {
        return n == this.currentWidth && n2 == this.currentHeight && this.currentOffset == n3 && this.currentLineWidth == n4 && this.currentSize == n5;
    }

    public void invalidate() {
        this.invalid = true;
        this.setContentStamp(TicketOffice.getNewStamp(), 0);
        this.setContentStamp(TicketOffice.getNewStamp(), this.getRawContentType());
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setValid() {
        this.invalid = false;
    }

    public int getRawContentType() {
        return 0;
    }

    public abstract Object getRaw(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    public void setRawBuffer(Object object) {
        this.rgbContentStamp = TicketOffice.getNewStamp();
    }

    public int[] getLUTForRaw() {
        return null;
    }

    public int getMaxRawValue() {
        return -1;
    }

    public int getRawValueOffset() {
        return 0;
    }

    public void fillBackground(boolean bl) {
        this.fillBG = bl;
    }

    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
    }

    public MousePositionDestination getMouseFollower() {
        return null;
    }

    public boolean handleHotRegionPressed(String string, Rectangle rectangle, MouseEvent mouseEvent, View view) {
        return false;
    }

    public boolean handleHotRegionReleased(String string, MouseEvent mouseEvent, int n, int n2, View view) {
        return false;
    }

    public boolean handleHotRegionDragged(String string, MouseEvent mouseEvent, int n, int n2, int n3, int n4, View view) {
        return false;
    }

    public boolean wantsMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return false;
    }

    public IRegionInfoSource getRegionSource() {
        return null;
    }

    public boolean handleMouseWheel(MouseWheelEvent mouseWheelEvent, View view) {
        return false;
    }

    protected static double getZoomFactorChange(MouseWheelEvent mouseWheelEvent) {
        double d = 1.0;
        int n = 0;
        while (n < Math.abs(mouseWheelEvent.getWheelRotation())) {
            d = mouseWheelEvent.getWheelRotation() < 0 ? (d *= 1.1) : (d /= 1.1);
            ++n;
        }
        return d;
    }

    public abstract void cleanUp();

    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return false;
        }
        if (tEvent.id == 88) {
            RendererSyncData rendererSyncData = (RendererSyncData)object;
            if (this.nodeName.equals(rendererSyncData.nodeName)) {
                this.setNodeID(rendererSyncData.nodeID);
            }
        }
        return false;
    }

    public void syncByName() {
        TEvent tEvent = new TEvent(88);
        RendererSyncData rendererSyncData = new RendererSyncData(this.nodeName);
        TEventDispatch.sendEvent(tEvent, rendererSyncData);
        this.setNodeID(rendererSyncData.nodeID);
    }

    public void setName(String string) {
        this.nodeName = string;
    }

    public String getName() {
        return this.nodeName;
    }

    public List<IMenuEntry> getLegacyMenuEntries(View view) {
        return new ArrayList<IMenuEntry>();
    }

    public abstract VisHRSet getHRSet(VisHRSet var1, Vis2 var2, View var3);

    @Override
    public abstract ImageState getImageState();

    public abstract void updateImageState();

    public abstract void addOverlay(Overlay var1);

    public abstract void removeOverlay(Overlay var1);

    public abstract List<Overlay> getOverlays();

    public abstract void paintOverlays(RGBBufferedImageHolder var1, Collection<Overlay> var2, boolean var3);

    public void broadcastUpdate(Object object) {
        TEvent tEvent = new TEvent();
        tEvent.id = 71;
        tEvent.source = this;
        tEvent.destinationNodeID = this.nodeID;
        TEventDispatch.sendEvent(tEvent, object);
    }

    public void broadcastViewportChange(ViewportDefinition viewportDefinition) {
        TEventDispatch.sendEvent(new TEvent(17), viewportDefinition);
    }

    public abstract void getOptimumOutputSize(SnapOutputGeometry var1);

    public abstract void storeToSnapshot(ViewSnapshot var1, SnapOutputGeometry var2);

    public abstract void storeOverlaysToSnapshot(ViewSnapshot var1, SnapOutputGeometry var2);

    public static void registerActions(String string) {
    }

    public abstract PickingResult pick(double var1, double var3);

    public IImageInformation getImageInformation() {
        return null;
    }

    public Renderer getLeaf() {
        return this;
    }

    public abstract TransferFunction getTransferFunction();

    public abstract void synchronizeWith(Renderer var1);

    public abstract Color getBackgroundColor();

    public Renderer findInstance(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    public void setGeometry(int n, int n2, int n3, int n4) {
    }

    public Rectangle getContentBounds() {
        return null;
    }

    public boolean containsRenderer(Renderer renderer) {
        return this == renderer;
    }

    public void removeAllROIs() {
    }

    @Override
    public Renderer getRenderer() {
        return this;
    }

    @Override
    public Object resolveString(String string) {
        return null;
    }
}

