/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IImageInformation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.image.IPickingHandler;
import com.tiani.jvision.image.PickingResult;
import com.tiani.jvision.image.View;
import com.tiani.jvision.info.ImageState;
import com.tiani.jvision.overlay.DataProfile;
import com.tiani.jvision.overlay.HistogramOverlay;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.OverlayContainer;
import com.tiani.jvision.overlay.PointSequence;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.renderer.Renderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class LeafRenderer
extends Renderer {
    protected List<Overlay> overlays = new CopyOnWriteArrayList<Overlay>();
    protected ImageState imageState = new ImageState();
    protected IImageInformation imageInformation;

    public LeafRenderer() {
    }

    public LeafRenderer(IImageInformation iImageInformation) {
        this();
        this.imageInformation = iImageInformation;
    }

    @Override
    public IImageInformation getImageInformation() {
        return this.imageInformation;
    }

    @Override
    public ImageState getImageState() {
        return this.imageState;
    }

    @Override
    public Renderer getLeaf() {
        return this;
    }

    @Override
    public void cleanUp() {
        List<Overlay> list = this.overlays;
        this.overlays = null;
        if (list != null) {
            for (Overlay overlay : list) {
                this.notifyOverlayRemoved(overlay);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HashMap<Overlay, Object> hashMap = new HashMap<Overlay, Object>();
        LeafRenderer leafRenderer = (LeafRenderer)super.clone();
        leafRenderer.overlays = new CopyOnWriteArrayList<Overlay>();
        for (Overlay object22 : this.overlays) {
            Object object = null;
            try {
                object = object22 instanceof HistogramOverlay || object22 instanceof DataProfile ? ((OverlayContainer)object22).cloneAllForPrinting() : (object22 instanceof PresentationObject ? ((PresentationObject)object22).cloneAll() : (Overlay)object22.clone());
                hashMap.put(object22, object);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ALogger.getLogger(LeafRenderer.class).error("Clone Exception", (Throwable)cloneNotSupportedException);
            }
            if (object == null) {
                object = object22;
            }
            leafRenderer.overlays.add((Overlay)object);
        }
        List<DataProfile> list = Overlay.filter(DataProfile.class, this.overlays);
        for (Object dataProfile : list) {
            ((DataProfile)dataProfile).setPointSequence((PointSequence)hashMap.get(((DataProfile)dataProfile).getPointSequence()));
        }
        return leafRenderer;
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (overlay == null) {
            return;
        }
        if (this.overlays.contains(overlay)) {
            return;
        }
        if (overlay instanceof PresentationObject && ((PresentationObject)overlay).isShutter()) {
            this.overlays.add(0, overlay);
        } else {
            this.overlays.add(overlay);
        }
        if (overlay.getImageState() == null) {
            overlay.setImageState(this.getImageState());
        }
    }

    @Override
    public void removeOverlay(Overlay overlay) {
        if (this.overlays != null && this.overlays.remove(overlay)) {
            this.notifyOverlayRemoved(overlay);
        }
    }

    protected void notifyOverlayRemoved(Overlay overlay) {
        overlay.presentationObjectRemoved(null);
    }

    @Override
    public void removeAllROIs() {
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        for (Overlay overlay : this.overlays) {
            if (!(overlay instanceof PresentationObject) || !((PresentationObject)overlay).isROI()) continue;
            arrayList.add(overlay);
            this.notifyOverlayRemoved(overlay);
        }
        this.overlays.removeAll(arrayList);
    }

    void removeAllNonImageOverlayBitmaps() {
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        for (Overlay overlay : this.overlays) {
            OverlayBitmap overlayBitmap;
            String string;
            if (!(overlay instanceof OverlayBitmap) || (string = (overlayBitmap = (OverlayBitmap)overlay).getOverlayDefinition().getProviderUID()) != null && string.equals(this.imageInformation.getSOPInstanceUID())) continue;
            arrayList.add(overlay);
            this.notifyOverlayRemoved(overlay);
        }
        this.overlays.removeAll(arrayList);
    }

    protected void removeAll(Class<? extends Overlay> clazz) {
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        for (Overlay overlay : this.overlays) {
            if (!clazz.isInstance(overlay)) continue;
            arrayList.add(overlay);
            this.notifyOverlayRemoved(overlay);
        }
        this.overlays.removeAll(arrayList);
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    protected void updateOverlays(int n, int n2) {
        ImageState imageState = this.getImageState();
        if (this.overlays != null) {
            for (Overlay overlay : this.overlays) {
                if (!overlay.isVisible()) continue;
                overlay.setSize(n, n2, imageState);
            }
        }
    }

    @Override
    public void paintOverlays(RGBBufferedImageHolder rGBBufferedImageHolder, Collection<Overlay> collection, boolean bl) {
        if (this.overlays == null) {
            this.overlays = new CopyOnWriteArrayList<Overlay>();
        }
        if (collection == null) {
            for (Overlay overlay : this.overlays) {
                overlay.paint(rGBBufferedImageHolder);
            }
        } else if (bl) {
            for (Overlay overlay : this.overlays) {
                if (!collection.contains(overlay)) continue;
                overlay.paint(rGBBufferedImageHolder);
            }
        } else {
            for (Overlay overlay : this.overlays) {
                if (collection.contains(overlay)) continue;
                overlay.paint(rGBBufferedImageHolder);
            }
        }
    }

    public IPickingHandler getPickingHandler() {
        return null;
    }

    @Override
    public PickingResult pick(double d, double d2) {
        if (this.getPickingHandler() == null) {
            return null;
        }
        return this.getPickingHandler().pick(d, d2, this.getImageState(), this.imageInformation);
    }

    @Override
    public Color getBackgroundColor() {
        return Color.BLACK;
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.destinationNodeID != 0 && tEvent.destinationNodeID != this.nodeID) {
            return false;
        }
        return super.handleTEvent(tEvent, object, n, view);
    }

    public void screenToImage(double[] dArray, double[] dArray2) {
        this.imageState.screenToImage(dArray, dArray2, null);
    }

    public void imageToScreen(double[] dArray, double[] dArray2) {
        this.imageState.imageToScreen(dArray, dArray2, null);
    }
}

