/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.menu.AbstractRadioButtonMenuItem;
import com.agfa.pacs.impaxee.menu.IMenuEntry;
import com.agfa.pacs.impaxee.plugin.PluggableComponent;
import com.agfa.pacs.listtext.pixeldata.frame.PixelDataUtilities;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.RawDataContainer;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.image.MousePositionDestination;
import com.tiani.jvision.image.SnapOutputGeometry;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.ViewSnapshot;
import com.tiani.jvision.renderer.BinaryNode;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.renderer.fusion.FusionOperator;
import com.tiani.jvision.renderer.fusion.FusionOperatorFactory;
import java.util.List;

public class FusionNode
extends BinaryNode {
    private static final ALogger log = ALogger.getLogger(FusionNode.class);
    private static final int SRC_GRAY = 0;
    private static final int SRC_GRAY_LUT = 1;
    private static final int SRC_RGB = 2;
    protected FusionOperator op = null;
    private int sourceMode;

    public FusionNode(Renderer renderer, Renderer renderer2) {
        super(renderer, renderer2);
        this.setOperator(Messages.getString("FUSION_OPERATOR_CROSS"));
    }

    @Override
    public MousePositionDestination getMouseFollower() {
        if (this.op instanceof MousePositionDestination) {
            return (MousePositionDestination)((Object)this.op);
        }
        return super.getMouseFollower();
    }

    @Override
    public String getName() {
        if (this.op == null) {
            return "Fusion";
        }
        return "Fusion/" + this.op.getComponentName();
    }

    public void setOperator(FusionOperator fusionOperator) {
        this.op = fusionOperator;
        if (this.child1 != null && this.child2 != null) {
            this.determineFuseMode();
            this.invalidate();
        }
    }

    public FusionOperator getOperator() {
        return this.op;
    }

    public void setOperator(String string) {
        this.setOperator((FusionOperator)FusionOperatorFactory.getInstance().getComponent(string));
    }

    @Override
    public void addChild(Renderer renderer) {
        super.addChild(renderer);
        this.determineFuseMode();
    }

    @Override
    public void setChild(Renderer renderer, int n) {
        super.setChild(renderer, n);
        this.determineFuseMode();
    }

    private void determineFuseMode() {
        if (this.child1 == null || this.child2 == null || this.op == null) {
            return;
        }
        int n = this.child1.getRawContentType();
        int n2 = this.child2.getRawContentType();
        this.sourceMode = n == 0 || n2 == 0 ? 2 : (this.child1.getMaxRawValue() != this.child2.getMaxRawValue() || !this.op.postLutPreferred() ? 1 : 0);
    }

    @Override
    public int getRawContentType() {
        if (this.sourceMode == 0) {
            return this.child1.getRawContentType();
        }
        return 0;
    }

    @Override
    public int[] getLUTForRaw() {
        if (this.activeChild != null) {
            return this.activeChild.getLUTForRaw();
        }
        return this.child1.getLUTForRaw();
    }

    @Override
    public int getMaxRawValue() {
        if (this.activeChild != null) {
            return this.activeChild.getMaxRawValue();
        }
        return this.child1.getMaxRawValue();
    }

    @Override
    public int getRawValueOffset() {
        if (this.activeChild != null) {
            return this.activeChild.getRawValueOffset();
        }
        return this.child1.getRawValueOffset();
    }

    @Override
    public boolean isInvalid() {
        return super.isInvalid() || this.child1.isInvalid() || this.child2.isInvalid();
    }

    @Override
    protected void produceRGBContent(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.extractTo(nArray, n, n2, n3, n4, bl);
    }

    @Override
    protected void produce8Content(byte[] byArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.op.fuse((byte[])this.child1.getRaw(n, n2, n3, n4, n5, this.child1.getRawContentType(), bl), (byte[])this.child2.getRaw(n, n2, n3, n4, n5, this.child2.getRawContentType(), bl), (byte[])this.cachedRaw, n, n2, n3, n4, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
    }

    @Override
    protected void produce16Content(short[] sArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.op.fuse((short[])this.child1.getRaw(n, n2, n3, n4, n5, this.child1.getRawContentType(), bl), (short[])this.child2.getRaw(n, n2, n3, n4, n5, this.child2.getRawContentType(), bl), (short[])this.cachedRaw, n, n2, n3, n4, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
    }

    private void extractTo(int[] nArray, int n, int n2, int n3, int n4, boolean bl) {
        this.extractTo(this.child1.getRaw(n, n2, n3, n4, nArray.length, this.child1.getRawContentType(), bl), this.child2.getRaw(n, n2, n3, n4, nArray.length, this.child2.getRawContentType(), bl), nArray, n, n2, n3, n4, bl);
    }

    private void extractTo(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, boolean bl) {
        switch (this.sourceMode) {
            case 0: {
                log.debug("extract g...");
                Renderer renderer = this.activeChild != null ? this.activeChild : this.child1;
                int[] nArray2 = renderer.getLUTForRaw();
                int n5 = renderer.getRawValueOffset();
                if (this.child1.getRawContentType() == 2) {
                    this.op.fuse((short[])object, (short[])object2, nArray, nArray2, n5, n, n2, n3, n4, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
                } else {
                    this.op.fuse((byte[])object, (byte[])object2, nArray, nArray2, n5, n, n2, n3, n4, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
                }
                this.updateImageState();
                break;
            }
            case 1: {
                log.debug("extract gLUT...");
                this.op.fuse(object, this.child1.getLUTForRaw(), this.child1.getRawValueOffset(), object2, this.child2.getLUTForRaw(), this.child2.getRawValueOffset(), nArray, n, n2, n3, n4, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
                this.updateImageState();
                break;
            }
            case 2: {
                log.debug("extract rgb...");
                this.op.fuse((int[])this.child1.getRaw(n, n2, n3, n4, nArray.length, 0, bl), (int[])this.child2.getRaw(n, n2, n3, n4, nArray.length, 0, bl), nArray, n, n2, n3, n4, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
                this.updateImageState();
            }
        }
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        this.extractTo(rGBBufferedImageHolder.data, n, n2, n3, n4, bl);
        if (this.fillBG) {
            this.doFillBackground(rGBBufferedImageHolder.data, n, n2, n3, n4, this.getBackgroundColor().getRGB());
        }
        this.setValid();
    }

    @Override
    public List<IMenuEntry> getLegacyMenuEntries(View view) {
        List<IMenuEntry> list = super.getLegacyMenuEntries(view);
        list.add(new FusionOp());
        return list;
    }

    @Override
    public boolean handleTEvent(TEvent tEvent, Object object, int n, View view) {
        if (tEvent.id == 84 && (tEvent.destinationNodeID == 0 || tEvent.destinationNodeID == this.nodeID)) {
            if (object instanceof String) {
                this.setOperator((String)object);
            } else {
                this.setOperator((FusionOperator)((FusionOperator)object).getInstance());
            }
            view.delayedRepaint();
            return true;
        }
        return super.handleTEvent(tEvent, object, n, view);
    }

    @Override
    public void storeToSnapshot(ViewSnapshot viewSnapshot, SnapOutputGeometry snapOutputGeometry) {
        Object object;
        snapOutputGeometry.aspectRatioChangeAllowed = false;
        int n = viewSnapshot.getWidth();
        int n2 = viewSnapshot.getHeight();
        int n3 = n * n2;
        boolean bl = viewSnapshot.forceRGB();
        viewSnapshot.setForceRGB(false);
        this.child1.storeToSnapshot(viewSnapshot, snapOutputGeometry);
        Object object2 = viewSnapshot.getDataBuffer();
        Object[] objectArray = null;
        if (object2 instanceof short[]) {
            objectArray = new short[n3];
            object = (short[])viewSnapshot.getDataBuffer();
            System.arraycopy(object, 0, objectArray, 0, n3);
        } else if (object2 instanceof byte[]) {
            objectArray = new byte[n3];
            object = (byte[])viewSnapshot.getDataBuffer();
            System.arraycopy(object, 0, objectArray, 0, n3);
        } else if (object2 instanceof int[]) {
            objectArray = new int[n3];
            object = (int[])viewSnapshot.getDataBuffer();
            System.arraycopy(object, 0, objectArray, 0, n3);
        }
        this.child2.storeToSnapshot(viewSnapshot, snapOutputGeometry);
        object = viewSnapshot.getDataBuffer();
        Object[] objectArray2 = null;
        int n4 = this.getRawContentType();
        if (bl) {
            n4 = 0;
        }
        switch (n4) {
            case 0: {
                objectArray2 = cache.allocInts((long)n3);
                this.extractTo(objectArray, object, (int[])objectArray2, n, n2, 0, n, false);
                break;
            }
            case 2: {
                objectArray2 = cache.allocShorts((long)n3);
                this.op.fuse((short[])objectArray, (short[])object, (short[])objectArray2, n, n2, 0, n, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
                this.updateImageState();
                break;
            }
            case 1: {
                objectArray2 = cache.allocBytes((long)n3);
                this.op.fuse((byte[])objectArray, (byte[])object, (byte[])objectArray2, n, n2, 0, n, this.getMaxRawValue(), this.child1.getImageState(), this.child2.getImageState());
                this.updateImageState();
            }
        }
        viewSnapshot.setDataBuffer(objectArray2);
    }

    public IPixelDataFrame<?> getRaw(int n) {
        boolean bl;
        boolean bl2 = bl = this.child1 instanceof IRDCRenderer && this.child2 instanceof IRDCRenderer;
        if (!bl) {
            return null;
        }
        IRDCRenderer iRDCRenderer = (IRDCRenderer)((Object)this.child1);
        IRDCRenderer iRDCRenderer2 = (IRDCRenderer)((Object)this.child2);
        if (n == 1) {
            iRDCRenderer = (IRDCRenderer)((Object)this.child2);
            iRDCRenderer2 = (IRDCRenderer)((Object)this.child1);
        }
        RawDataContainer rawDataContainer = iRDCRenderer.getRawDataContainer();
        RawDataContainer rawDataContainer2 = iRDCRenderer2.getRawDataContainer();
        IPixelAccessor<?> iPixelAccessor = rawDataContainer.getData();
        IPixelAccessor<?> iPixelAccessor2 = rawDataContainer2.getData();
        Object object = iPixelAccessor.getData();
        Object object2 = iPixelAccessor2.getData();
        short[] sArray = null;
        int n2 = -1;
        if (object instanceof short[]) {
            short[] sArray2 = (short[])object;
            short[] sArray3 = (short[])object2;
            n2 = sArray2.length;
            sArray = new short[n2];
            int n3 = 0;
            while (n3 < rawDataContainer.getRows()) {
                int n4 = 0;
                while (n4 < rawDataContainer.getColumns()) {
                    double[] dArray = new double[]{n4, n3};
                    double[] dArray2 = new double[2];
                    iRDCRenderer.getImageState().imageToScreen(dArray, dArray2, null);
                    double[] dArray3 = new double[2];
                    iRDCRenderer2.getImageState().screenToImage(dArray2, dArray3, null);
                    int n5 = n3 * rawDataContainer.getColumns() + n4;
                    sArray[n5] = sArray2[n5];
                    if (dArray3[0] >= 0.0 && dArray3[0] < (double)rawDataContainer2.getColumns() && dArray3[1] >= 0.0 && dArray3[1] < (double)rawDataContainer2.getRows()) {
                        int n6 = (int)dArray3[1] * rawDataContainer2.getColumns() + (int)dArray3[0];
                        sArray[n5] = (short)(sArray2[n5] - sArray3[n6]);
                        if (sArray[n5] < 0) {
                            sArray[n5] = -sArray[n5];
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            n2 = byArray.length;
            sArray = DataCacheProviderFactory.getCache().allocShorts((long)n2);
            int n7 = 0;
            while (n7 < n2) {
                sArray[n7] = (short)(byArray[n7] - byArray2[n7]);
                if (sArray[n7] < 0) {
                    sArray[n7] = -sArray[n7];
                }
                ++n7;
            }
        }
        iPixelAccessor.release();
        iPixelAccessor2.release();
        return PixelDataUtilities.createShortGrayPixelDataFrame((int)rawDataContainer.getColumns(), (int)rawDataContainer.getRows(), (int)16, (boolean)false, (short[])sArray);
    }

    private class FusionOp
    extends AbstractRadioButtonMenuItem {
        public FusionOp() {
            super(true);
            List<PluggableComponent> list = FusionOperatorFactory.getInstance().getAllComponents();
            this.displayName = new String[list.size()];
            this.actionCommand = new String[list.size()];
            int n = 0;
            while (n < list.size()) {
                PluggableComponent pluggableComponent = list.get(n);
                this.displayName[n] = pluggableComponent.getComponentName();
                this.actionCommand[n] = pluggableComponent.getComponentName();
                ++n;
            }
        }

        @Override
        public void menuItemSelected(String string) {
            FusionNode.this.setOperator(string);
            TEvent tEvent = new TEvent();
            tEvent.source = null;
            tEvent.id = 84;
            tEvent.destinationNodeID = FusionNode.this.nodeID;
            TEventDispatch.sendEvent(tEvent, string);
        }
    }
}

