/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.renderer;

import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.tiani.jvision.renderer.IntermediateNode;

abstract class CachingIntermediateNode
extends IntermediateNode {
    protected Object cachedRaw;

    protected void finalize() throws Throwable {
        this.discardCache();
        super.finalize();
    }

    private void readCacheB(boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (this.cachedRaw == null) {
            this.cachedRaw = cache.allocBytes((long)n5);
            this.setCacheGeometry(bl, n, n2, n3, n4, n5);
        }
    }

    private void readCacheS(boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (this.cachedRaw == null) {
            this.cachedRaw = cache.allocShorts((long)n5);
            this.setCacheGeometry(bl, n, n2, n3, n4, n5);
        }
    }

    private void readCacheI(boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (this.cachedRaw == null) {
            this.cachedRaw = cache.allocInts((long)n5);
            this.setCacheGeometry(bl, n, n2, n3, n4, n5);
        }
    }

    private void discardCache() {
        if (this.cachedRaw != null) {
            if (this.cachedRaw instanceof byte[]) {
                cache.free((byte[])this.cachedRaw);
            } else if (this.cachedRaw instanceof short[]) {
                cache.free((short[])this.cachedRaw);
            } else if (this.cachedRaw instanceof int[]) {
                cache.free((int[])this.cachedRaw);
            }
            this.cachedRaw = null;
            this.invalidate();
        }
    }

    @Override
    public boolean isCacheGeometryValid(boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (this.cachedRaw == null) {
            return false;
        }
        return super.isCacheGeometryValid(bl, n, n2, n3, n4, n5);
    }

    @Override
    public void setRawBuffer(Object object) {
        super.setRawBuffer(object);
        if (this.cachedRaw != null && this.cachedRaw != object) {
            if (this.cachedRaw instanceof byte[]) {
                cache.free((byte[])this.cachedRaw);
            } else if (this.cachedRaw instanceof short[]) {
                cache.free((short[])this.cachedRaw);
            } else if (this.cachedRaw instanceof int[]) {
                cache.free((int[])this.cachedRaw);
            }
        }
        this.cachedRaw = object;
    }

    protected abstract void produceRGBContent(int[] var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    protected abstract void produce8Content(byte[] var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    protected abstract void produce16Content(short[] var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    @Override
    public Object getRaw(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n6 == 0) {
            if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, n5) || this.isInvalid()) {
                this.discardCache();
                this.readCacheI(bl, n, n2, n3, n4, n5);
                this.produceRGBContent((int[])this.cachedRaw, n, n2, n3, n4, n5, bl);
                this.updateImageState();
            }
            this.setValid();
            return this.cachedRaw;
        }
        if (n6 == 2) {
            if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, n5) || this.isInvalid()) {
                this.discardCache();
                this.readCacheS(bl, n, n2, n3, n4, n5);
                this.produce16Content((short[])this.cachedRaw, n, n2, n3, n4, n5, bl);
                this.updateImageState();
            }
            this.setValid();
            return this.cachedRaw;
        }
        if (!this.isCacheGeometryValid(bl, n, n2, n3, n4, n5) || this.isInvalid()) {
            this.discardCache();
            this.readCacheB(bl, n, n2, n3, n4, n5);
            this.produce8Content((byte[])this.cachedRaw, n, n2, n3, n4, n5, bl);
            this.updateImageState();
        }
        this.setValid();
        return this.cachedRaw;
    }

    @Override
    public void paint(RGBBufferedImageHolder rGBBufferedImageHolder, int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray = (int[])this.getRaw(n, n2, 0, n, n * n2, 0, bl);
        int n5 = 0;
        while (n5 < n2) {
            System.arraycopy(nArray, n5 * n, rGBBufferedImageHolder.data, n3 + n5 * n4, n);
            ++n5;
        }
        this.invalid = false;
    }
}

