/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.studies;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.icon.IAIconFactory;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.listtext.swingx.util.graphics.IconLoader;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.overlay.demographics.PriorStudyColoring;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.studies.StudyTableData;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.dcm4che3.data.Attributes;

class StudyTableModel
extends AbstractTableModel {
    static final int ICON_SIZE = GUI.getScaledDiagnosticInt((int)16);
    private static final Icon ICON_REMOVE = IconLoader.getScaledIcon((String)"icons/study_remove.gif", (ClassLoader)StudyTableModel.class.getClassLoader(), (int)ICON_SIZE, (int)ICON_SIZE);
    private static final Icon ICON_OPENED = IconLoader.getScaledIcon((String)"icons/study_opened.gif", (ClassLoader)StudyTableModel.class.getClassLoader(), (int)ICON_SIZE, (int)ICON_SIZE);
    private static final Icon ICON_CLOSED = IconLoader.getScaledIcon((String)"icons/study_closed.gif", (ClassLoader)StudyTableModel.class.getClassLoader(), (int)ICON_SIZE, (int)ICON_SIZE);
    private static IAIconFactory iconFactory = new IAIconFactory(17);
    private static final Icon ICON_EXPANDED = iconFactory.loadIcon("showimages.svg");
    private static final Icon ICON_COLLAPSED = iconFactory.loadIcon("showkeyimages.svg");
    private Map<String, StudyTableData> studiesMap;
    private List<StudyTableData> studies = new ArrayList<StudyTableData>();
    private StudyComparator studyComparator;
    private static final Icon ICON_OPENED_PRIO1 = StudyTableModel.colorIcon(ICON_OPENED, PriorStudyColoring.mappingColorPrior1);
    private static final Icon ICON_OPENED_PRIOX = StudyTableModel.colorIcon(ICON_OPENED, PriorStudyColoring.mappingColorPriorX);
    private static final Icon ICON_OPENED_MERGED_STUDY = StudyTableModel.colorIcon(ICON_OPENED, PriorStudyColoring.mappingColorMergedStudies);
    private static final Icon ICON_CLOSED_PRIO1 = StudyTableModel.colorIcon(ICON_CLOSED, PriorStudyColoring.mappingColorPrior1);
    private static final Icon ICON_CLOSED_PRIOX = StudyTableModel.colorIcon(ICON_CLOSED, PriorStudyColoring.mappingColorPriorX);
    private static final Icon ICON_CLOSED_MERGED_STUDY = StudyTableModel.colorIcon(ICON_CLOSED, PriorStudyColoring.mappingColorMergedStudies);
    private static final Icon ICON_REMOVE_PRIO1 = StudyTableModel.colorIcon(ICON_REMOVE, PriorStudyColoring.mappingColorPrior1);
    private static final Icon ICON_REMOVE_PRIOX = StudyTableModel.colorIcon(ICON_REMOVE, PriorStudyColoring.mappingColorPriorX);
    private static final Icon ICON_REMOVE_MERGED_STUDY = StudyTableModel.colorIcon(ICON_REMOVE, PriorStudyColoring.mappingColorMergedStudies);

    private static Icon colorIcon(Icon icon, Color color) {
        BufferedImage bufferedImage = new BufferedImage(ICON_SIZE, ICON_SIZE, 2);
        icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        int n = 0;
        while (n < ICON_SIZE) {
            int n2 = 0;
            while (n2 < ICON_SIZE) {
                int n3 = bufferedImage.getRGB(n, n2);
                int n4 = n3 >> 24;
                int n5 = n3 >> 16 & color.getRed();
                int n6 = n3 >> 8 & color.getGreen();
                int n7 = n3 >> 0 & color.getBlue();
                n3 = n4 << 24 | n5 << 16 | n6 << 8 | n7 << 0;
                bufferedImage.setRGB(n, n2, n3);
                ++n2;
            }
            ++n;
        }
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        return imageIcon;
    }

    public StudyTableModel() {
        this.studiesMap = new HashMap<String, StudyTableData>();
        this.studyComparator = new StudyComparator();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.studies.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n <= 2 ? Icon.class : String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        StudyTableData studyTableData = this.studies.get(n);
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return studyTableData.isCollapsable();
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        StudyTableData studyTableData = this.studies.get(n);
        switch (n2) {
            case 0: {
                return this.getRemoveIcon(studyTableData);
            }
            case 1: {
                return studyTableData.isOpen() ? this.getOpenedIcon(studyTableData) : this.getClosedStudyIcon(studyTableData);
            }
            case 2: {
                return studyTableData.isCollapsable() ? (studyTableData.isCollapsed() ? ICON_COLLAPSED : ICON_EXPANDED) : null;
            }
            case 3: {
                return studyTableData.toHtmlString();
            }
        }
        return null;
    }

    private StudyType getStudyType(String string) {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null && iHanging.getStudyContainer() != null) {
            return iHanging.getStudyContainer().getStudyType(string);
        }
        return StudyType.UNKNOWN;
    }

    private Icon getRemoveIcon(StudyTableData studyTableData) {
        if (!PriorStudyColoring.useDifferentColorsForPriors || !GuiUtil.isOnColorMonitor()) {
            return ICON_REMOVE;
        }
        StudyType studyType = this.getStudyType(studyTableData.getStudy().getKey());
        switch (studyType) {
            case BASE_STUDY: 
            case UNKNOWN: {
                return ICON_REMOVE;
            }
            case FIRST_PRIOR: {
                return ICON_REMOVE_PRIO1;
            }
            case MERGED: {
                return ICON_REMOVE_MERGED_STUDY;
            }
        }
        return ICON_REMOVE_PRIOX;
    }

    private Icon getClosedStudyIcon(StudyTableData studyTableData) {
        if (!PriorStudyColoring.useDifferentColorsForPriors || !GuiUtil.isOnColorMonitor()) {
            return ICON_CLOSED;
        }
        StudyType studyType = this.getStudyType(studyTableData.getStudy().getKey());
        switch (studyType) {
            case BASE_STUDY: 
            case UNKNOWN: {
                return ICON_CLOSED;
            }
            case FIRST_PRIOR: {
                return ICON_CLOSED_PRIO1;
            }
            case MERGED: {
                return ICON_CLOSED_MERGED_STUDY;
            }
        }
        return ICON_CLOSED_PRIOX;
    }

    private Icon getOpenedIcon(StudyTableData studyTableData) {
        if (!PriorStudyColoring.useDifferentColorsForPriors || !GuiUtil.isOnColorMonitor()) {
            return ICON_OPENED;
        }
        StudyType studyType = this.getStudyType(studyTableData.getStudy().getKey());
        switch (studyType) {
            case BASE_STUDY: 
            case UNKNOWN: {
                return ICON_OPENED;
            }
            case FIRST_PRIOR: {
                return ICON_OPENED_PRIO1;
            }
            case MERGED: {
                return ICON_OPENED_MERGED_STUDY;
            }
        }
        return ICON_OPENED_PRIOX;
    }

    StudyTableData getStudyAt(int n) throws IndexOutOfBoundsException {
        return this.studies.get(n);
    }

    boolean hasStudy(IStudyData iStudyData) {
        return this.studiesMap.containsKey(iStudyData.getKey());
    }

    StudyTableData findStudy(IStudyData iStudyData) {
        return this.findStudy(iStudyData.getKey());
    }

    StudyTableData findStudy(String string) {
        return this.studiesMap.get(string);
    }

    public Iterable<StudyTableData> getStudies() {
        return new ArrayList<StudyTableData>(this.studies);
    }

    void setStudyOpen(StudyTableData studyTableData, boolean bl) {
        studyTableData.setOpen(bl);
        int n = this.studies.indexOf(studyTableData);
        if (n >= 0) {
            this.fireTableCellUpdated(n, 1);
        }
    }

    void addStudies(Collection<StudyTableData> collection) throws NullPointerException {
        int n = this.studies.size();
        StudyTableData studyTableData = null;
        for (StudyTableData studyTableData2 : collection) {
            if (this.studies.contains(studyTableData2)) continue;
            this.studies.add(studyTableData2);
            this.studiesMap.put(studyTableData2.getStudy().getKey(), studyTableData2);
            if (studyTableData != null) continue;
            studyTableData = studyTableData2;
        }
        Collections.sort(this.studies, this.studyComparator);
        if (this.studies.size() == n + 1 && CompareUtils.equals((Object)this.studies.get(this.studies.size() - 1), studyTableData)) {
            this.fireTableRowsInserted(n, n);
        } else {
            this.fireTableDataChanged();
        }
    }

    void removeStudy(StudyTableData studyTableData) throws NullPointerException {
        if (studyTableData == null) {
            return;
        }
        int n = this.studies.indexOf(studyTableData);
        this.studiesMap.remove(studyTableData.getStudy().getKey());
        if (this.studies.remove(n) != null) {
            this.fireTableRowsDeleted(n, n);
        }
    }

    void removeAllStudies() {
        int n = this.studies.size();
        if (n > 0) {
            this.studies.clear();
            this.studiesMap.clear();
            this.fireTableRowsDeleted(0, n);
        }
    }

    private static class StudyComparator
    implements Comparator<StudyTableData> {
        private StudyComparator() {
        }

        @Override
        public int compare(StudyTableData studyTableData, StudyTableData studyTableData2) {
            Date date = this.getCreationDateTime(studyTableData);
            Date date2 = this.getCreationDateTime(studyTableData2);
            int n = 0;
            if (date != null && date2 != null) {
                n = date2.compareTo(date);
            }
            return n != 0 ? n : studyTableData2.getStudy().getStudyInstanceUID().compareTo(studyTableData.getStudy().getStudyInstanceUID());
        }

        private Date getCreationDateTime(StudyTableData studyTableData) {
            assert (studyTableData != null) : "Resolving study date and time failed: Study is null!";
            return DateTimeUtils.getStudyDateTime((Attributes)studyTableData.getStudy().getDicomObject());
        }
    }
}

