/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.hanging.snapshots;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.gui.mvc.AbstractSelectionController;
import com.agfa.pacs.impaxee.gui.mvc.IMutableSelectionModel;
import com.agfa.pacs.impaxee.gui.mvc.IPopupMenuAction;
import com.agfa.pacs.impaxee.gui.mvc.SelectionView;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.DefaultHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.HangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.MultiPatientHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotAction;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotView;
import java.awt.Component;

public class SnapshotController
extends AbstractSelectionController<AbstractSnapshotRuntime>
implements IHanging.SnapshotModel.Listener {
    private static final SnapshotController INSTANCE = new SnapshotController();
    private static AbstractSnapshotRuntime[] pastedSnapshot;
    private IHanging.SnapshotModel snapshotModel;

    private SnapshotController() {
    }

    public static SnapshotController getInstance() {
        return INSTANCE;
    }

    public static SelectionView<AbstractSnapshotRuntime> createSnapshotView() {
        return new SnapshotView(INSTANCE);
    }

    @Override
    protected boolean isPopupMenuEnabled() {
        return !Product.isCDViewer() && (Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") || Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions"));
    }

    public void createSnapshot() {
        DataSelectionManager.getInstance().setBlockCapturing(true);
        IHanging iHanging = this.getCurrentHanging();
        AbstractSnapshotRuntime abstractSnapshotRuntime = iHanging.getSnapshotModel().newInstance();
        if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
            ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setUseRuntimeForSave(true);
        }
        iHanging.getSnapshotModel().add(abstractSnapshotRuntime);
        DataSelectionManager.getInstance().setBlockCapturing(false);
    }

    public void updateSnapshot() {
        int n = this.getAndCheckPosition();
        IHanging iHanging = this.getCurrentHanging();
        iHanging.getSnapshotModel().update(n);
    }

    public void removeSnapshot() {
        IHanging iHanging = this.getCurrentHanging();
        this.deleteSnapshot(iHanging, this.getAndCheckPosition());
    }

    public void cutSnapshot() {
        IHanging iHanging = this.getCurrentHanging();
        pastedSnapshot = new AbstractSnapshotRuntime[1];
        SnapshotController.pastedSnapshot[0] = this.removeSnapshot(iHanging, this.getAndCheckPosition());
    }

    public void pasteBeforeSnapshot() {
        this.paste(this.getAndCheckPosition());
    }

    public void pasteAfterSnapshot() {
        this.paste(this.getAndCheckPosition() + 1);
    }

    private void paste(int n) {
        this.insertSnapshot(this.getCurrentHanging(), this.getAndCheckClipboard(), n);
        this.clearClipboard();
    }

    @Override
    protected void initDataModel(IMutableSelectionModel<AbstractSnapshotRuntime> iMutableSelectionModel) {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        AbstractSnapshotRuntime abstractSnapshotRuntime = iHanging != null ? DataSelectionManager.getInstance().getActiveSnapshot(iHanging) : null;
        IHanging.SnapshotModel snapshotModel = this.snapshotModel = iHanging != null ? iHanging.getSnapshotModel() : null;
        if (this.snapshotModel != null) {
            this.snapshotModel.removeListener(this);
        }
        int n = 0;
        while (this.snapshotModel != null && n < this.snapshotModel.size()) {
            AbstractSnapshotRuntime abstractSnapshotRuntime2 = this.snapshotModel.get(n);
            iMutableSelectionModel.addElement(abstractSnapshotRuntime2);
            if (abstractSnapshotRuntime2 == abstractSnapshotRuntime) {
                iMutableSelectionModel.setSelectedIndex(n);
            }
            ++n;
        }
        if (this.snapshotModel != null) {
            this.snapshotModel.addListener(this);
        }
    }

    @Override
    protected void afterRefresh() {
    }

    @Override
    public void selectionActivated(Component component, int n) {
        if (this.snapshotModel.getSelected() != n) {
            try {
                CursorUtil.setWaitCursor((Component)component);
                AbstractSnapshotRuntime abstractSnapshotRuntime = (AbstractSnapshotRuntime)this.getElementAt(n);
                DataSelectionManager.getInstance().setActiveSnapshot(DataSelectionManager.getInstance().getActiveHanging(), abstractSnapshotRuntime);
                this.snapshotModel.select(n);
            }
            finally {
                CursorUtil.resetWaitCursor((Component)component);
            }
        }
    }

    @Override
    public void selectionDeactivated() {
        DataSelectionManager.getInstance().setActiveSnapshot(DataSelectionManager.getInstance().getActiveHanging(), (AbstractSnapshotRuntime)null);
        this.snapshotModel.select(-1);
    }

    @Override
    protected IPopupMenuAction[] getPopupMenuActions() {
        this.enableActions();
        return SnapshotAction.values();
    }

    private void enableActions() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        boolean bl = iHanging instanceof HangingProtocolRuntime && Permissions.getInstance().isAllowed("ImageArea/AllowedToEditHangingProtocols") || iHanging instanceof IHangingSession && Permissions.getInstance().isAllowed("ImageArea/AllowedToCreateAndSaveSessions");
        boolean bl2 = (bl &= !(iHanging instanceof DefaultHangingProtocolRuntime) && !(iHanging instanceof MultiPatientHangingProtocolRuntime)) && this.snapshotModel.getSelected() >= 0;
        boolean bl3 = bl2 && this.getElementCount() > 1;
        SnapshotAction.CREATE.getSwingAction().setEnabled(bl);
        SnapshotAction.REMOVE.getSwingAction().setEnabled(bl3);
        SnapshotAction.CUT.getSwingAction().setEnabled(bl3);
        SnapshotAction.PASTE_BEFORE.getSwingAction().setEnabled(bl2 && !this.isClipboardEmpty());
        SnapshotAction.PASTE_AFTER.getSwingAction().setEnabled(bl2 && !this.isClipboardEmpty());
    }

    private IHanging getCurrentHanging() {
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        assert (iHanging != null) : "There must be a current hanging state for all snapshot actions!";
        return iHanging;
    }

    private int getAndCheckPosition() {
        int n = this.snapshotModel.getSelected();
        assert (n >= 0) : "No snapshot item is selected!";
        assert (this.getElementAt(n) == DataSelectionManager.getInstance().getActiveSnapshot()) : "Selected snapshot is not the one in selection manager!";
        return n;
    }

    private AbstractSnapshotRuntime getAndCheckClipboard() {
        assert (!this.isClipboardEmpty()) : "No pasted item present!";
        return pastedSnapshot[0];
    }

    private boolean isClipboardEmpty() {
        return pastedSnapshot == null || pastedSnapshot.length <= 0 || pastedSnapshot[0] == null;
    }

    private void clearClipboard() {
        pastedSnapshot = null;
    }

    private void insertSnapshot(IHanging iHanging, AbstractSnapshotRuntime abstractSnapshotRuntime, int n) {
        if (n < 0 || n > iHanging.getSnapshotModel().size()) {
            n = iHanging.getSnapshotModel().size();
        }
        iHanging.getSnapshotModel().insertAt(n, abstractSnapshotRuntime);
    }

    private void deleteSnapshot(IHanging iHanging, int n) {
        this.removeSnapshot(iHanging, n, true);
    }

    private AbstractSnapshotRuntime removeSnapshot(IHanging iHanging, int n) {
        return this.removeSnapshot(iHanging, n, false);
    }

    private AbstractSnapshotRuntime removeSnapshot(IHanging iHanging, int n, boolean bl) {
        AbstractSnapshotRuntime abstractSnapshotRuntime = null;
        if (bl) {
            iHanging.getSnapshotModel().delete(n);
        } else {
            abstractSnapshotRuntime = iHanging.getSnapshotModel().remove(n);
        }
        return abstractSnapshotRuntime;
    }

    @Override
    public void snapshotAdded(int n, AbstractSnapshotRuntime abstractSnapshotRuntime) {
        this.snapshotModel.removeListener(this);
        this.insertElementAt(n, abstractSnapshotRuntime);
        this.snapshotModel.addListener(this);
    }

    @Override
    public void snapshotRemoved(int n) {
        this.removeElementAt(n);
    }

    @Override
    public void snapshotSelected(int n) {
        this.selectElementAt(n);
    }

    @Override
    public void snapshotUpdated(int n) {
    }
}

