/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo.hanging;

import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionProvider;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.hanging.snapshots.SnapshotController;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SnapshotActions
implements PActionProvider {
    private static final String CAPTURE = "CAPTURE_SNAPSHOT";
    private static final String NEXT = "NEXT_SNAPSHOT";
    private static final String PREVIOUS = "PREVIOUS_SNAPSHOT";

    @Override
    public List<PAction> getActions() {
        ArrayList<PAction> arrayList = new ArrayList<PAction>();
        arrayList.add(new CaptureSnapshotAction());
        arrayList.add(new NextSnapshotAction());
        arrayList.add(new PrevSnapshotAction());
        return arrayList;
    }

    private class CaptureSnapshotAction
    extends SnapshotAction {
        public CaptureSnapshotAction() {
            super("CAPTURE");
        }

        @Override
        public String getID() {
            return SnapshotActions.CAPTURE;
        }

        @Override
        public boolean perform(Component component) {
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging instanceof IMultiplePatientHanging) {
                ALogger.getLogger(SnapshotActions.class).info("Creating snapshots while comparing patients is not possible!");
                Message.info(super.getCaption(), Messages.getString("SnapshotActions.CREATE.MultiPatientError.Msg"));
                return false;
            }
            this.notifyActionPerformed();
            SnapshotController.getInstance().createSnapshot();
            return true;
        }
    }

    private class NextSnapshotAction
    extends SnapshotAction {
        public NextSnapshotAction() {
            super("NEXT");
        }

        @Override
        public String getID() {
            return SnapshotActions.NEXT;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(39, 1);
        }

        @Override
        public boolean perform(Component component) {
            Object object;
            this.notifyActionPerformed();
            boolean bl = false;
            if (SnapshotController.getInstance().getSelectedElement() instanceof HangingProtocolSnapshotRuntime && ((HangingProtocolSnapshotRuntime)(object = (HangingProtocolSnapshotRuntime)SnapshotController.getInstance().getSelectedElement())).getConditionalHanging() != null && ((HangingProtocolSnapshotRuntime)object).getConditionalHanging().getStartQuadrantViewing().booleanValue()) {
                bl = true;
            }
            if (bl) {
                object = new TEvent(128);
                VisDisplay2 visDisplay2 = AbstractPDataAction.getCurrentDisplay();
                if (visDisplay2 == null) {
                    return false;
                }
                TEventDispatch.sendEvent(visDisplay2, (TEvent)object, null, false);
            } else {
                SnapshotController.getInstance().setSelectedItemRelative(1);
            }
            return true;
        }
    }

    private class PrevSnapshotAction
    extends SnapshotAction {
        public PrevSnapshotAction() {
            super("PREV");
        }

        @Override
        public String getID() {
            return SnapshotActions.PREVIOUS;
        }

        @Override
        public KeyShortcut getDefaultShortcut() {
            return new KeyShortcut(37, 1);
        }

        @Override
        public boolean perform(Component component) {
            this.notifyActionPerformed();
            SnapshotController.getInstance().setSelectedItemRelative(-1);
            return true;
        }
    }

    private abstract class SnapshotAction
    extends AbstractPAction {
        private String name;

        public SnapshotAction(String string) {
            this.name = string;
        }

        @Override
        public String getCaption() {
            return Messages.getString("ACTION_MAIN_HANGINGS_SNAPSHOT_" + this.name);
        }

        @Override
        public String getGroupName() {
            return HANGINGS_GROUP;
        }

        @Override
        public String getToolTipText() {
            return Messages.getString("ACTION_MAIN_HANGINGS_SNAPSHOT_" + this.name + "_DESCRIPTION");
        }
    }
}

