/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.splitsort.model.ISplitAndSortRuntime;
import com.agfa.pacs.listtext.swingx.borders.CustomLineBorder;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.Modes;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.DisplaySetLabel;
import com.tiani.jvision.patinfo.DisplaySetPanel;
import com.tiani.jvision.patinfo.DisplaySetScrollPane;
import com.tiani.jvision.patinfo.studies.StudyTableController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.dcm4che3.data.Attributes;

public class DisplaySetLabelGroup
extends JPanel {
    private static Modes.PaletteOrientation orientation;
    public static final boolean CLOSE_STUDY_BY_DEFAULT;
    private final ISplitAndSortRuntime sasRuntime;
    private final IStudyData study;
    private String studyDigest;
    private boolean opened;
    private boolean highlighted;
    private List<DisplaySetLabel> labels;
    private CustomLineBorder lineBorder;
    private TitledBorder border;
    private Color bg;
    private LabelComparator comparator;
    private DisplaySetPanel dispPanel;

    static {
        CLOSE_STUDY_BY_DEFAULT = Config.impaxee.jvision.SEQPANEL.CloseStudiesByDefault.get();
    }

    public DisplaySetLabelGroup(DisplaySetScrollPane displaySetScrollPane, ISplitAndSortRuntime iSplitAndSortRuntime, IStudyData iStudyData) {
        super(null);
        this.sasRuntime = iSplitAndSortRuntime;
        this.study = iStudyData;
        this.comparator = new LabelComparator();
        this.labels = new ArrayList<DisplaySetLabel>();
        this.studyDigest = DisplaySetLabelGroup.getStudyDigest(iStudyData);
        this.bg = this.getBackground();
        this.dispPanel = displaySetScrollPane.getSequencePanel();
        this.highlighted = false;
        this.opened = this.isStudyOpened();
        if (orientation == null) {
            orientation = displaySetScrollPane.getOrientation();
        }
        this.lineBorder = new GroupLineBorder(this.getTitleColor(), 2, true, false, false, orientation.isHorizontal());
        this.border = ComponentFactory.instance.createTitledBorder((Border)this.lineBorder, this.studyDigest, 1, 2, null, this.getTitleColor());
        this.setBorder(this.border);
        this.setFont(this.getFont().deriveFont(GUI.getScaledDiagnosticInt((int)this.getFont().getSize())));
        this.setHighlightedInt(this.highlighted);
        this.addMouseListener(new ExpandListener());
    }

    private boolean isStudyOpened() {
        if (CLOSE_STUDY_BY_DEFAULT) {
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            return iHanging == null || iHanging instanceof IMultiplePatientHanging;
        }
        return true;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public IStudyData getStudy() {
        return this.study;
    }

    public DisplaySetLabel findDisplaySetLabel(IDisplaySet iDisplaySet) {
        for (DisplaySetLabel displaySetLabel : this.labels) {
            if (displaySetLabel.getDisplaySet().getID() != iDisplaySet.getID()) continue;
            return displaySetLabel;
        }
        return null;
    }

    public int getNumberOfDisplaySetLabels() {
        return this.labels.size();
    }

    public List<DisplaySetLabel> getDisplaySetLabels() {
        return this.labels;
    }

    public void addDisplaySetLabel(DisplaySetLabel displaySetLabel) {
        if (!this.labels.contains(displaySetLabel)) {
            displaySetLabel.setVisible(this.opened);
            this.labels.add(displaySetLabel);
            Collections.sort(this.labels, this.comparator);
            this.add(displaySetLabel, null, this.labels.indexOf(displaySetLabel));
        }
    }

    public void removeDisplaySetLabel(DisplaySetLabel displaySetLabel) {
        if (this.labels.remove(displaySetLabel)) {
            displaySetLabel.cleanUp();
            this.remove(displaySetLabel);
        }
    }

    void updateLayout() {
        if (orientation.isHorizontal()) {
            this.updateLayoutHorizontal();
        } else {
            this.updateLayoutVertical();
        }
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.validate();
        }
    }

    public void removeAllDisplaySetLabels() {
        for (DisplaySetLabel displaySetLabel : this.labels) {
            displaySetLabel.cleanUp();
        }
        this.labels.clear();
        this.removeAll();
    }

    public void open() {
        if (!this.opened) {
            this.opened = true;
            this.highlighted = false;
            for (DisplaySetLabel displaySetLabel : this.labels) {
                displaySetLabel.setVisible(true);
            }
            this.updateLayout();
        }
    }

    public void close() {
        if (this.opened) {
            this.opened = false;
            int n = orientation.isHorizontal() ? 1 : 0;
            while (n < this.labels.size()) {
                this.labels.get(n).setVisible(false);
                ++n;
            }
            this.setHighlighted(false);
            this.updateLayout();
        }
    }

    public void jumpTo() {
        JViewport jViewport = this.findViewport();
        if (jViewport != null) {
            jViewport.setViewPosition(this.getLocation());
            jViewport.getParent().invalidate();
            jViewport.getParent().validate();
        }
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        if (this.highlighted != bl) {
            this.highlighted = bl;
            this.setHighlightedInt(bl);
            this.repaint();
        }
    }

    private void setHighlightedInt(boolean bl) {
        if (bl) {
            this.setBackground(this.getTitleColor());
            this.lineBorder.setLineColor(this.bg);
            this.border.setTitleColor(this.bg);
        } else {
            this.setBackground(this.bg);
            this.lineBorder.setLineColor(this.getTitleColor());
            this.border.setTitleColor(this.getTitleColor());
        }
    }

    public static String getStudyDigest(IStudyData iStudyData) {
        Date date = DateTimeUtils.getStudyDateTime((Attributes)iStudyData.getDicomObject());
        String string = DisplaySetLabelGroup.getModalityString(iStudyData);
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            if (date != null) {
                stringBuilder.append(" | ");
            }
        }
        if (date != null) {
            stringBuilder.append(DateTimeUtils.dateTime2String((Date)date));
        }
        return stringBuilder.toString();
    }

    private static String getModalityString(IStudyData iStudyData) {
        String string;
        String[] stringArray = new String[]{"SR", "KO", "PR"};
        String[] stringArray2 = iStudyData.resolveStrings(524385);
        if ((stringArray2 == null || stringArray2.length == 0) && (string = iStudyData.resolveString(524384)) != null) {
            stringArray2 = new String[]{string};
        }
        string = "";
        if (stringArray2 != null) {
            String[] stringArray3 = stringArray2;
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray3[n2];
                if (!DisplaySetLabelGroup.contains(stringArray, string2)) {
                    string = string.length() == 0 ? string2 : String.valueOf(string) + "," + string2;
                }
                ++n2;
            }
        }
        return string;
    }

    private static boolean contains(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private JViewport findViewport() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                return (JViewport)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private Color getTitleColor() {
        Color color = UIManager.getColor("color.primary.3");
        if (color == null) {
            color = UIManager.getColor("Label.foreground");
        }
        return color;
    }

    private void updateLayoutVertical() {
        int n = this.getInsets().top;
        int n2 = this.getParent() != null ? this.getParent().getWidth() : 0;
        int n3 = 0;
        int n4 = 10;
        int n5 = 0;
        for (DisplaySetLabel displaySetLabel : this.labels) {
            if (!displaySetLabel.isVisible()) continue;
            n5 = 0;
            n3 = displaySetLabel.getImageWidth();
            int n6 = displaySetLabel.getHeight() + 3;
            displaySetLabel.setBounds(0, n, n3, n6);
            if ((n5 += n3 + n4) > n2) {
                n2 = n5;
            }
            n += n6;
        }
        this.setPreferredSize(new Dimension(n2, n));
    }

    private void updateLayoutHorizontal() {
        int n = 0;
        int n2 = this.getInsets().top;
        int n3 = this.getInsets().left;
        int n4 = GUI.getScaledDiagnosticInt((int)5);
        if (!this.opened) {
            this.labels.get(0).setVisible(true);
        }
        for (DisplaySetLabel displaySetLabel : this.labels) {
            if (!displaySetLabel.isVisible()) continue;
            int n5 = displaySetLabel.getHeight();
            if (n5 > n) {
                n = n5;
            }
            displaySetLabel.setBounds(n3, n2, displaySetLabel.getImageWidth(), n5);
            n3 += displaySetLabel.getWidth() + n4;
        }
        this.setPreferredSize(new Dimension(n3 + this.getInsets().right, n + this.getInsets().top + this.getInsets().bottom));
    }

    private class ExpandListener
    extends MouseAdapter {
        private ExpandListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                DisplaySetLabelGroup.this.setHighlighted(false);
                IEventEngine iEventEngine = EventEngineFactory.getInstance();
                IEvent iEvent = null;
                iEvent = DisplaySetLabelGroup.this.opened ? iEventEngine.createEvent(StudyTableController.STUDY_CLOSED_EVENT_ID, null, (Object)this, null, ActionInfo.SINGLE) : iEventEngine.createEvent(StudyTableController.STUDY_OPENED_EVENT_ID, null, (Object)this, null, ActionInfo.SINGLE);
                if (iEvent != null) {
                    iEvent.setPayload((Object)new StudyTableController.StudyVisibilityEventPayload(DisplaySetLabelGroup.this.study.getKey(), false, DisplaySetLabelGroup.this.dispPanel));
                    iEvent.setDestination(null, "StudyTableController.EventPath");
                    iEventEngine.sendEvent(iEvent);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Color color = DisplaySetLabelGroup.this.getTitleColor();
            DisplaySetLabelGroup.this.border.setTitleColor(ColorUtils.brighter((Color)color, (float)0.7f));
            DisplaySetLabelGroup.this.lineBorder.setLineColor(ColorUtils.brighter((Color)color, (float)0.7f));
            DisplaySetLabelGroup.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            DisplaySetLabelGroup.this.setHighlightedInt(DisplaySetLabelGroup.this.highlighted);
            DisplaySetLabelGroup.this.repaint();
        }
    }

    private class GroupLineBorder
    extends CustomLineBorder {
        public GroupLineBorder(Color color, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(color, n, bl4, bl, bl2, bl3);
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = super.getBorderInsets(component);
            if (orientation.isHorizontal() && !DisplaySetLabelGroup.this.opened) {
                insets.right += GUI.getScaledDiagnosticInt((int)4);
            }
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = super.getBorderInsets(component, insets);
            if (orientation.isHorizontal() && !DisplaySetLabelGroup.this.opened) {
                insets2.right += GUI.getScaledDiagnosticInt((int)4);
            }
            return insets2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (orientation.isHorizontal()) {
                Color color = graphics.getColor();
                graphics.setColor(this.lineColor);
                int n5 = 0;
                while (n5 < this.thickness) {
                    int n6;
                    if (this.leftBorder) {
                        n6 = n2 - GUI.getScaledInt((int)5);
                        graphics.drawLine(n + n5, n6, n + n5, n6 + n4);
                    }
                    if (this.topBorder && DisplaySetLabelGroup.this.opened && DisplaySetLabelGroup.this.labels.size() > 1 && graphics instanceof Graphics2D) {
                        Color color2 = this.lineColor;
                        Color color3 = new Color(this.lineColor.getRed(), this.lineColor.getGreen(), this.lineColor.getRed(), (int)((double)this.lineColor.getAlpha() * 0.75));
                        Color color4 = new Color(this.lineColor.getRed(), this.lineColor.getGreen(), this.lineColor.getRed(), 0);
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setPaint(new LinearGradientPaint(n, n2, n + n3, n2, new float[]{0.0f, 0.5f, 0.95f}, new Color[]{color2, color3, color4}));
                        graphics2D.drawLine(n + GUI.getScaledDiagnosticInt((int)10), n2 + n5, n + n3, n2 + n5);
                        graphics2D.setPaint(null);
                    }
                    if (!DisplaySetLabelGroup.this.opened && DisplaySetLabelGroup.this.labels.size() > 1) {
                        n6 = GUI.getScaledDiagnosticInt((int)4);
                        int n7 = DisplaySetLabelGroup.this.getInsets().top / 2 - GUI.getScaledDiagnosticInt((int)2);
                        int n8 = n + n3 - DisplaySetLabelGroup.this.getInsets().right;
                        graphics.fillPolygon(new int[]{n8 - n6 / 2, n8 + n6 / 2, n8 - n6 / 2}, new int[]{n7 - n6, n7, n7 + n6}, 3);
                    }
                    if (this.bottomBorder) {
                        graphics.drawLine(n, n2 + n4 - n5, n + n3, n2 + n4 - n5);
                    }
                    ++n5;
                }
                graphics.setColor(color);
            } else {
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        }
    }

    private class LabelComparator
    implements Comparator<DisplaySetLabel> {
        private LabelComparator() {
        }

        @Override
        public int compare(DisplaySetLabel displaySetLabel, DisplaySetLabel displaySetLabel2) {
            Integer n = DisplaySetLabelGroup.this.sasRuntime.getDisplaySetPosition(displaySetLabel.getDisplaySet());
            Integer n2 = DisplaySetLabelGroup.this.sasRuntime.getDisplaySetPosition(displaySetLabel2.getDisplaySet());
            return n.compareTo(n2);
        }
    }
}

