/*
 * Decompiled with CFR 0.152.
 */
package com.tiani.jvision.patinfo;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.hanging.HangingUtil;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.ISinglePatientHanging;
import com.agfa.pacs.impaxee.hanging.model.HangingProtocolSnapshotRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.MultiPatientHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.runtime.UserDefinedHangingProtocolRuntime;
import com.agfa.pacs.impaxee.hanging.snapshot.AbstractSnapshotRuntime;
import com.agfa.pacs.impaxee.sessions.Session;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.TEventHandler;
import com.tiani.jvision.image.View;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.patinfo.ISelectionListener;
import com.tiani.jvision.toptoolbar.StoreTemporarySessions;
import com.tiani.jvision.vis.VisDisplayData;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;

public class DataSelectionManager {
    private static final DataSelectionManager instance = new DataSelectionManager();
    private static final ALogger log = ALogger.getLogger(DataSelectionManager.class);
    private final boolean captureSnapshotStatus = Config.impaxee.jvision.HANGMAN.CaptureSnapshotStatus.get();
    private List<IDataSelectionListener> listeners;
    private DataManager dm = DataManager.getInstance();
    private PAction escapeMouseMode;
    private List<ISelectionListener> selectionListeners;
    private IPatientRepresentation currentPatient;
    private AbstractSnapshotRuntime currentSnapshot;
    private MyActiveImageEventHandler myActiveImageEventHandler;
    private boolean isMultiPatientCompareActive;
    private MultiPatientHangingProtocolRuntime multiPatientHangingProtocolRuntime;
    private boolean blockCapturing = false;

    public static DataSelectionManager getInstance() {
        return instance;
    }

    private DataSelectionManager() {
        this.listeners = new CopyOnWriteArrayList<IDataSelectionListener>();
        this.selectionListeners = new CopyOnWriteArrayList<ISelectionListener>();
        DataManager.getInstance().addListener(new MapCleaningDataManagerListener());
        this.addListener(new LoadPriorityUpdaterListener());
        this.myActiveImageEventHandler = new MyActiveImageEventHandler();
        TEventDispatch.addListener(this.myActiveImageEventHandler);
    }

    private MultiPatientHangingProtocolRuntime getMultiPatientHangingProtocolRuntime() {
        if (this.multiPatientHangingProtocolRuntime == null) {
            this.multiPatientHangingProtocolRuntime = new MultiPatientHangingProtocolRuntime(this.getMultiPatientHPId());
        }
        return this.multiPatientHangingProtocolRuntime;
    }

    public String getMultiPatientHPId() {
        return "--" + Messages.getString("DataSelectionManager.MultiPatientHangingName") + "--";
    }

    public void displayCurrentPatient(String string) {
        IPatientRepresentation iPatientRepresentation = null;
        if (string != null) {
            iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(string);
        }
        if (iPatientRepresentation == null) {
            return;
        }
        boolean bl = iPatientRepresentation == DataSelectionManager.getInstance().getCurrentPatient();
        DataManager.getInstance().refreshHangings(iPatientRepresentation, true, !bl || iPatientRepresentation.getActiveHanging() == null || DataManager.NEW_STUDIES_GET_ACTIVATED);
        this.setCurrentPatient(iPatientRepresentation);
    }

    public IPatientRepresentation getCurrentPatient() {
        return this.currentPatient;
    }

    public boolean isCurrentPatient(IPatientData iPatientData) {
        if (iPatientData == null || this.currentPatient == null) {
            return false;
        }
        return iPatientData.equals(this.currentPatient.getPatientData());
    }

    public void patientClicked(IPatientRepresentation iPatientRepresentation, int n) {
        this.notifyPatientClicked(iPatientRepresentation.getPatientData(), n);
    }

    private void handleMouseMode() {
        if (this.escapeMouseMode == null) {
            this.escapeMouseMode = PActionRegistry.getAction("MOUSE_MODE_NORMAL");
        }
        this.escapeMouseMode.perform(null);
    }

    public boolean setCurrentPatient(IPatientRepresentation iPatientRepresentation) {
        boolean bl = Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get();
        if (iPatientRepresentation == null && bl) {
            IPatientRepresentation iPatientRepresentation2 = this.currentPatient;
            this.currentPatient = null;
            if (iPatientRepresentation2 != null) {
                this.notifyNewPatientSelected(iPatientRepresentation2, null);
                this.handleMouseMode();
            }
            this.clearCurrentSnapshot();
            return true;
        }
        if (this.currentPatient != iPatientRepresentation) {
            boolean bl2;
            this.captureCurrentHangup(false);
            this.handleAutomaticSessionStorage(this.currentPatient, bl);
            IPatientRepresentation iPatientRepresentation3 = this.currentPatient;
            this.currentPatient = iPatientRepresentation;
            if (this.isPatientCompareOrPatientMergeActive()) {
                Config.impaxee.jvision.MAPPING.UseAnonymousMode.set(false);
            }
            IHanging iHanging = null;
            boolean bl3 = true;
            if (iPatientRepresentation != null) {
                iHanging = iPatientRepresentation.getActiveHanging();
                if (iHanging == null && (iHanging = DataManager.getInstance().refreshHangings(iPatientRepresentation, true, true)) == null) {
                    bl3 = false;
                }
                if (this.isMultiPatientCompareActive) {
                    if (!iPatientRepresentation.containsHanging(this.multiPatientHangingProtocolRuntime)) {
                        iPatientRepresentation.addHanging(this.multiPatientHangingProtocolRuntime);
                        this.multiPatientHangingProtocolRuntime.addPatient(iPatientRepresentation);
                        iHanging = this.multiPatientHangingProtocolRuntime;
                    }
                    iPatientRepresentation.setActiveHanging(null);
                }
            }
            String string = iHanging != null ? iHanging.getIdentifier() : null;
            this.clearCurrentSnapshot();
            if (iPatientRepresentation3 != null) {
                this.handleMouseMode();
            }
            this.notifyNewPatientSelected(iPatientRepresentation3, iPatientRepresentation);
            if (bl3 && iPatientRepresentation != null) {
                iPatientRepresentation.setActiveHanging(null);
                this.setActiveHanging(iPatientRepresentation, string);
            }
            if (iPatientRepresentation3 != null && !(bl2 = Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) && !this.isMultiPatientCompareActive && this.dm.getPatientCount() > 2) {
                for (IPatientRepresentation iPatientRepresentation4 : this.dm.getPatientRepresentations()) {
                    if (iPatientRepresentation4 == iPatientRepresentation || iPatientRepresentation4 == null) continue;
                    iPatientRepresentation4.getPatientData().storeToCache();
                }
            }
            return true;
        }
        return false;
    }

    private void handleAutomaticSessionStorage(IPatientRepresentation iPatientRepresentation, boolean bl) {
        if (iPatientRepresentation == null) {
            return;
        }
        if (!bl && !this.isMultiPatientCompareActive && StoreTemporarySessions.isActivated() && DataManager.getInstance().getPatientRepresentations().contains(iPatientRepresentation)) {
            iPatientRepresentation.createTemporarySession(true);
        } else {
            iPatientRepresentation.createTemporarySession(false);
        }
    }

    private void captureCurrentHangup(boolean bl) {
        if (this.blockCapturing) {
            return;
        }
        IHanging iHanging = this.getActiveHanging();
        boolean bl2 = iHanging instanceof UserDefinedHangingProtocolRuntime;
        if (!bl || !bl2) {
            AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot();
            if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).capture();
            }
            if (abstractSnapshotRuntime != null && bl2) {
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setClearCachedDSAfterFirstUse(true);
                ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setHangingApplied(true);
            }
        }
    }

    public IHanging getActiveHanging() {
        return this.getActiveHanging(this.getCurrentPatient());
    }

    public IHanging getActiveHanging(IPatientRepresentation iPatientRepresentation) {
        if (iPatientRepresentation == null) {
            return null;
        }
        return iPatientRepresentation.getActiveHanging();
    }

    public void setActiveHanging(IPatientRepresentation iPatientRepresentation, String string) {
        IHanging iHanging = iPatientRepresentation != null ? iPatientRepresentation.getHanging(string) : null;
        this.setActiveHanging(iPatientRepresentation, iHanging, true, false);
    }

    public void setActiveHanging(IPatientRepresentation iPatientRepresentation, IHanging iHanging, boolean bl, boolean bl2) {
        if (iHanging != null && !HangingUtil.belongsToPatient(iPatientRepresentation, iHanging)) {
            throw new IllegalArgumentException("Hanging must belong to given patient");
        }
        IHanging iHanging2 = null;
        if (iPatientRepresentation != null) {
            iHanging2 = iPatientRepresentation.getActiveHanging();
        }
        if (iHanging2 != iHanging) {
            this.captureCurrentHangup(!this.captureSnapshotStatus);
            iPatientRepresentation.setActiveHanging(iHanging);
            if (iPatientRepresentation == this.getCurrentPatient() && iHanging != null) {
                AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot(iHanging);
                if (abstractSnapshotRuntime == null) {
                    abstractSnapshotRuntime = iHanging.getSnapshotModel().size() > 0 ? iHanging.getSnapshotModel().get(0) : null;
                }
                this.setActiveSnapshot(iHanging, abstractSnapshotRuntime != null ? abstractSnapshotRuntime.getName() : null);
                if (bl) {
                    this.notifyNewHangingCaseSelected(iPatientRepresentation, iHanging2, iHanging, bl2);
                }
            }
        }
    }

    public AbstractSnapshotRuntime getActiveSnapshot() {
        return this.getActiveSnapshot(this.getActiveHanging());
    }

    private IPatientRepresentation getPatientForHanging(IHanging iHanging) {
        if (iHanging instanceof ISinglePatientHanging) {
            return ((ISinglePatientHanging)iHanging).getPatient();
        }
        if (iHanging instanceof IMultiplePatientHanging) {
            return ((IMultiplePatientHanging)iHanging).getPatients().iterator().next();
        }
        return this.getCurrentPatient();
    }

    public AbstractSnapshotRuntime getActiveSnapshot(IHanging iHanging) {
        if (iHanging == null) {
            return null;
        }
        return this.getPatientForHanging(iHanging).getActiveSnapshot(iHanging);
    }

    public void setActiveSnapshot(IHanging iHanging, String string) {
        this.setActiveSnapshot(iHanging, iHanging.getSnapshotModel().get(string));
    }

    public void setActiveSnapshot(IHanging iHanging, AbstractSnapshotRuntime abstractSnapshotRuntime) {
        if (this.getActiveSnapshot() != abstractSnapshotRuntime) {
            this.captureCurrentHangup(!this.captureSnapshotStatus);
        }
        this.getPatientForHanging(iHanging).setActiveSnapshot(iHanging, abstractSnapshotRuntime);
        this.hangup();
    }

    public void setBlockCapturing(boolean bl) {
        this.blockCapturing = bl;
    }

    public void clearCurrentSnapshot() {
        this.currentSnapshot = null;
    }

    private void hangup() {
        AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot();
        if (abstractSnapshotRuntime == this.currentSnapshot) {
            return;
        }
        this.currentSnapshot = abstractSnapshotRuntime;
        if (!Product.isHeadless()) {
            if (this.currentSnapshot != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JVision2.getMainFrame().clearAllDisplays();
                        JComponent jComponent = JVision2.getMainFrame().getJVisionContentPane();
                        jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                        JVision2.getMainFrame().hangup(DataSelectionManager.this.getActiveHanging(), DataSelectionManager.this.currentSnapshot != null ? DataSelectionManager.this.currentSnapshot.getName() : null);
                    }
                };
                this.executeInEventThread(runnable);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JVision2.getMainFrame().clearAllDisplays();
                    }
                };
                this.executeInEventThread(runnable);
            }
        }
    }

    public void addListener(IDataSelectionListener iDataSelectionListener) {
        if (!this.listeners.contains(iDataSelectionListener)) {
            this.listeners.add(iDataSelectionListener);
        }
    }

    public void removeListener(IDataSelectionListener iDataSelectionListener) {
        this.listeners.remove(iDataSelectionListener);
    }

    public void addSelectionListener(ISelectionListener iSelectionListener) {
        if (!this.selectionListeners.contains(iSelectionListener)) {
            this.selectionListeners.add(iSelectionListener);
        }
    }

    public void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.selectionListeners.remove(iSelectionListener);
    }

    private void notifyNewPatientSelected(final IPatientRepresentation iPatientRepresentation, final IPatientRepresentation iPatientRepresentation2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n = DataSelectionManager.this.dm.getPatientPosition(iPatientRepresentation2);
                IPatientRepresentation iPatientRepresentation3 = null;
                if (n != -1) {
                    iPatientRepresentation3 = DataSelectionManager.this.dm.getPatientOnPosition(n + 1);
                }
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.newPatientSelected(DataSelectionManager.this, iPatientRepresentation, iPatientRepresentation2, iPatientRepresentation3);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyNewHangingCaseSelected(final IPatientRepresentation iPatientRepresentation, final IHanging iHanging, final IHanging iHanging2, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl2 = bl;
                if (!bl2) {
                    bl2 = DataSelectionManager.this.isMultiPatientCompareActive || iHanging instanceof Session || iHanging2 instanceof Session;
                }
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.newHangingCaseSelected(iPatientRepresentation, iHanging, iHanging2, bl2);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyNewActiveStudySelected(MyActiveImageEventHandler myActiveImageEventHandler, final IStudyData iStudyData) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.newActiveStudySelected(iStudyData);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    private void notifyPatientClicked(final IPatientData iPatientData, final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.patientClicked(iPatientData, n);
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyPriorsChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.priorsChanged();
                }
            }
        };
        this.executeInEventThread(runnable);
    }

    public void notifyLastModifiedChanged(final int n, final VisDisplayData visDisplayData) {
        Object object;
        IDisplaySet iDisplaySet;
        if (this.currentPatient != null && (iDisplaySet = (object = this.currentPatient.getDecompositionRuntime()).getDisplaySetByID(n)) != null) {
            iDisplaySet.setIsActive(false, false);
        }
        if (visDisplayData != null && visDisplayData.getDisplaySet() != null) {
            visDisplayData.getDisplaySet().setIsActive(true, false);
        }
        object = new Runnable(){

            @Override
            public void run() {
                for (ISelectionListener iSelectionListener : DataSelectionManager.this.selectionListeners) {
                    iSelectionListener.lastModifiedChanged(n, visDisplayData);
                }
            }
        };
        this.executeInEventThread((Runnable)object);
    }

    public void notifyLoadingPriorsInProgress(final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (IDataSelectionListener iDataSelectionListener : DataSelectionManager.this.listeners) {
                    iDataSelectionListener.notifyPriorStudyLoadingInProgress(bl);
                }
            }
        };
        try {
            EventUtil.invoke((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void executeInEventThread(Runnable runnable) {
        try {
            EventUtil.invokeSynchronous((Runnable)runnable);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    public void reHangup() {
        IHanging iHanging = this.getActiveHanging();
        AbstractSnapshotRuntime abstractSnapshotRuntime = this.getActiveSnapshot(iHanging);
        if (abstractSnapshotRuntime instanceof HangingProtocolSnapshotRuntime) {
            ((HangingProtocolSnapshotRuntime)abstractSnapshotRuntime).setHangingApplied(false);
        }
        this.clearCurrentSnapshot();
        this.setActiveSnapshot(iHanging, abstractSnapshotRuntime);
    }

    public boolean isPatientCompareOrPatientMergeActive() {
        if (this.isMultiPatientCompareActive) {
            return true;
        }
        if (this.currentPatient == null) {
            return false;
        }
        return PatientMergeUtilities.getPatientMergeStatus((Attributes)this.currentPatient.getPatientData().getQueryObject().getAttributes()) != PatientMergeUtilities.PatientMergeStatus.NotMerged;
    }

    public boolean isMultiPatientCompareActive() {
        return this.isMultiPatientCompareActive;
    }

    public void setMultiPatientCompareActive(boolean bl) {
        this.isMultiPatientCompareActive = bl;
        MultiPatientHangingProtocolRuntime multiPatientHangingProtocolRuntime = this.getMultiPatientHangingProtocolRuntime();
        if (bl) {
            Config.impaxee.jvision.MAPPING.UseAnonymousMode.set(false);
            if (this.currentPatient != null) {
                multiPatientHangingProtocolRuntime.getHangingDefinition().getSnapshot(0).capture();
                this.currentPatient.addHanging(multiPatientHangingProtocolRuntime);
                multiPatientHangingProtocolRuntime.addPatient(this.currentPatient);
                this.setActiveHanging(this.currentPatient, multiPatientHangingProtocolRuntime, true, true);
            }
        } else {
            IHanging iHanging = this.getActiveHanging();
            for (IPatientRepresentation iPatientRepresentation : this.dm.getPatientRepresentations()) {
                iPatientRepresentation.removeHanging(multiPatientHangingProtocolRuntime.getIdentifier());
                multiPatientHangingProtocolRuntime.removePatient(iPatientRepresentation);
                if (iPatientRepresentation == this.currentPatient || iPatientRepresentation.getActiveHanging() != null || iPatientRepresentation.countHangings() <= 0) continue;
                iPatientRepresentation.setActiveHanging(iPatientRepresentation.getHanging(0));
            }
            if (iHanging == multiPatientHangingProtocolRuntime) {
                this.setActiveHanging(this.currentPatient, this.currentPatient.getDefaultHanging(), true, true);
            }
            DataManager.getInstance().removeListener(this.multiPatientHangingProtocolRuntime);
            this.multiPatientHangingProtocolRuntime = null;
        }
        PActionRegistry.getAction("SHOW_TEXT_AREA").fireEnabledChanged();
    }

    public static class LoadPriorityUpdaterListener
    extends DataSelectionListenerAdapter {
        @Override
        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            if (iPatientRepresentation != null && iPatientRepresentation != iPatientRepresentation3 && !DataSelectionManager.getInstance().isMultiPatientCompareActive()) {
                iPatientRepresentation.setLoadPriority(null);
            }
            if (iPatientRepresentation2 != null) {
                iPatientRepresentation2.setLoadPriority((byte)5);
            }
            if (iPatientRepresentation3 != null) {
                iPatientRepresentation3.setLoadPriority((byte)6);
            }
        }
    }

    private class MapCleaningDataManagerListener
    extends DataManagerListenerAdapter {
        private MapCleaningDataManagerListener() {
        }

        @Override
        public void patientRemoved(IPatientRepresentation iPatientRepresentation) {
            IPatientRepresentation iPatientRepresentation2 = DataSelectionManager.this.getCurrentPatient();
            if (iPatientRepresentation.equals(iPatientRepresentation2)) {
                DataSelectionManager.this.setCurrentPatient(null);
            }
            DataSelectionManager.this.myActiveImageEventHandler.setStudyUIDLastActive(null);
        }

        @Override
        public void hangingStateRemoved(IHanging iHanging) {
            DataSelectionManager.this.myActiveImageEventHandler.setStudyUIDLastActive(null);
        }
    }

    private class MyActiveImageEventHandler
    implements TEventHandler {
        private String studyUIDLastActive;

        private MyActiveImageEventHandler() {
        }

        @Override
        public void handleTEvent(TEvent tEvent, Object object, int n) {
            if (tEvent.id == 53) {
                try {
                    View view = (View)object;
                    if (view.getVis() == null) {
                        return;
                    }
                    IStudyData iStudyData = view.getVis().getStudyData();
                    if (iStudyData.getParent().getStudies().contains(iStudyData)) {
                        String string = iStudyData.getKey();
                        if (this.studyUIDLastActive != null && this.studyUIDLastActive.equals(string)) {
                            return;
                        }
                        this.studyUIDLastActive = string;
                        log.info("Trigger SetActiveStudyEvent for " + string);
                        DataSelectionManager.this.notifyNewActiveStudySelected(this, iStudyData);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void setStudyUIDLastActive(String string) {
            this.studyUIDLastActive = string;
        }
    }
}

